/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.gcs;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.ReadChannel;
import com.google.cloud.WriteChannel;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageOptions;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.store.BufferedIndexInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.apache.solr.gcs.GCSConfigParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCSBackupRepository
implements BackupRepository {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int LARGE_BLOB_THRESHOLD_BYTE_SIZE = 0x500000;
    private static final Storage.BlobWriteOption[] NO_WRITE_OPTIONS = new Storage.BlobWriteOption[0];
    protected Storage storage;
    private NamedList<?> config = null;
    protected String bucketName = null;
    protected String credentialPath = null;
    protected int writeBufferSizeBytes;
    protected int readBufferSizeBytes;
    protected StorageOptions.Builder storageOptionsBuilder = null;

    protected Storage initStorage() {
        if (this.storage != null) {
            return this.storage;
        }
        try {
            if (this.credentialPath != null) {
                log.info("Creating GCS client using credential at {}", (Object)this.credentialPath);
                GoogleCredentials credential = GoogleCredentials.fromStream((InputStream)new FileInputStream(this.credentialPath));
                this.storageOptionsBuilder.setCredentials((Credentials)credential);
            } else {
                log.warn(GCSConfigParser.potentiallyMissingCredentialMsg());
            }
            this.storage = (Storage)this.storageOptionsBuilder.build().getService();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return this.storage;
    }

    public void init(NamedList<?> args) {
        this.config = args;
        GCSConfigParser configReader = new GCSConfigParser();
        GCSConfigParser.GCSConfig parsedConfig = configReader.parseConfiguration(this.config);
        this.bucketName = parsedConfig.getBucketName();
        this.credentialPath = parsedConfig.getCredentialPath();
        this.writeBufferSizeBytes = parsedConfig.getWriteBufferSize();
        this.readBufferSizeBytes = parsedConfig.getReadBufferSize();
        this.storageOptionsBuilder = parsedConfig.getStorageOptionsBuilder();
        this.initStorage();
    }

    public <T> T getConfigProperty(String name) {
        return (T)this.config.get(name);
    }

    public URI createURI(String location) {
        URI result;
        Objects.requireNonNull(location);
        try {
            result = new URI(location);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Error on creating URI", e);
        }
        return result;
    }

    public URI createDirectoryURI(String location) {
        Objects.requireNonNull(location);
        if (!((String)location).endsWith("/")) {
            location = (String)location + "/";
        }
        return this.createURI((String)location);
    }

    public URI resolve(URI baseUri, String ... pathComponents) {
        StringBuilder builder = new StringBuilder(baseUri.toString());
        for (String path : pathComponents) {
            if (path == null || path.isEmpty()) continue;
            if (builder.charAt(builder.length() - 1) != '/') {
                builder.append('/');
            }
            builder.append(path);
        }
        return URI.create(builder.toString()).normalize();
    }

    public URI resolveDirectory(URI baseUri, String ... pathComponents) {
        if (pathComponents.length > 0) {
            if (!pathComponents[pathComponents.length - 1].endsWith("/")) {
                pathComponents[pathComponents.length - 1] = pathComponents[pathComponents.length - 1] + "/";
            }
        } else if (!baseUri.getPath().endsWith("/")) {
            baseUri = URI.create(baseUri + "/");
        }
        return this.resolve(baseUri, pathComponents);
    }

    public boolean exists(URI path) throws IOException {
        return this.exists(path.toString());
    }

    public boolean exists(String path) throws IOException {
        if (path.equals(this.getConfigProperty("location"))) {
            return true;
        }
        if (path.endsWith("/")) {
            return this.storage.get(this.bucketName, path, new Storage.BlobGetOption[]{Storage.BlobGetOption.fields((Storage.BlobField[])new Storage.BlobField[0])}) != null;
        }
        String filePath = path;
        String directoryPath = path + "/";
        return this.storage.get(this.bucketName, filePath, new Storage.BlobGetOption[]{Storage.BlobGetOption.fields((Storage.BlobField[])new Storage.BlobField[0])}) != null || this.storage.get(this.bucketName, directoryPath, new Storage.BlobGetOption[]{Storage.BlobGetOption.fields((Storage.BlobField[])new Storage.BlobField[0])}) != null;
    }

    public BackupRepository.PathType getPathType(URI path) throws IOException {
        if (path.toString().endsWith("/")) {
            return BackupRepository.PathType.DIRECTORY;
        }
        Blob blob = this.storage.get(this.bucketName, path.toString() + "/", new Storage.BlobGetOption[]{Storage.BlobGetOption.fields((Storage.BlobField[])new Storage.BlobField[0])});
        if (blob != null) {
            return BackupRepository.PathType.DIRECTORY;
        }
        return BackupRepository.PathType.FILE;
    }

    public String[] listAll(URI path) throws IOException {
        String blobName;
        String pathStr = blobName = this.appendTrailingSeparatorIfNecessary(path.toString());
        LinkedList result = new LinkedList();
        this.storage.list(this.bucketName, new Storage.BlobListOption[]{Storage.BlobListOption.currentDirectory(), Storage.BlobListOption.prefix((String)pathStr), Storage.BlobListOption.fields((Storage.BlobField[])new Storage.BlobField[0])}).iterateAll().forEach(blob -> {
            assert (blob.getName().startsWith(pathStr));
            String suffixName = blob.getName().substring(pathStr.length());
            if (!suffixName.isEmpty()) {
                if (suffixName.endsWith("/")) {
                    result.add(suffixName.substring(0, suffixName.length() - 1));
                } else {
                    result.add(suffixName);
                }
            }
        });
        return result.toArray(new String[0]);
    }

    public IndexInput openInput(URI dirPath, String fileName, IOContext ctx) throws IOException {
        return this.openInput(dirPath, fileName, ctx, this.readBufferSizeBytes);
    }

    private IndexInput openInput(URI dirPath, String fileName, IOContext ctx, int bufferSize) {
        String blobName = this.resolve(dirPath, fileName).toString();
        BlobId blobId = BlobId.of((String)this.bucketName, (String)blobName);
        final Blob blob = this.storage.get(blobId, new Storage.BlobGetOption[]{Storage.BlobGetOption.fields((Storage.BlobField[])new Storage.BlobField[]{Storage.BlobField.SIZE})});
        final ReadChannel readChannel = blob.reader(new Blob.BlobSourceOption[0]);
        readChannel.setChunkSize(bufferSize);
        return new BufferedIndexInput(blobName, bufferSize){

            public long length() {
                return blob.getSize();
            }

            protected void readInternal(ByteBuffer b) throws IOException {
                readChannel.read(b);
            }

            protected void seekInternal(long pos) throws IOException {
                readChannel.seek(pos);
            }

            public void close() throws IOException {
                readChannel.close();
            }
        };
    }

    public OutputStream createOutput(URI path) throws IOException {
        BlobInfo blobInfo = BlobInfo.newBuilder((String)this.bucketName, (String)path.toString()).build();
        final WriteChannel writeChannel = this.storage.writer(blobInfo, this.getDefaultBlobWriteOptions());
        return Channels.newOutputStream(new WritableByteChannel(){

            @Override
            public int write(ByteBuffer src) throws IOException {
                return writeChannel.write(src);
            }

            @Override
            public boolean isOpen() {
                return writeChannel.isOpen();
            }

            @Override
            public void close() throws IOException {
                writeChannel.close();
            }
        });
    }

    public void createDirectory(URI path) throws IOException {
        String name = this.appendTrailingSeparatorIfNecessary(path.toString());
        if (!this.exists(name)) {
            this.storage.create(BlobInfo.newBuilder((String)this.bucketName, (String)name).build(), new Storage.BlobTargetOption[0]);
        }
    }

    public void deleteDirectory(URI path) throws IOException {
        List<BlobId> blobIds = this.allBlobsAtDir(path);
        if (!blobIds.isEmpty()) {
            this.storage.delete(blobIds);
        } else {
            log.debug("Path:{} doesn't have any blobs", (Object)path);
        }
    }

    protected List<BlobId> allBlobsAtDir(URI path) throws IOException {
        String blobName = this.appendTrailingSeparatorIfNecessary(path.toString());
        ArrayList<BlobId> result = new ArrayList<BlobId>();
        String pathStr = blobName;
        this.storage.list(this.bucketName, new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)pathStr), Storage.BlobListOption.fields((Storage.BlobField[])new Storage.BlobField[0])}).iterateAll().forEach(blob -> result.add(blob.getBlobId()));
        return result;
    }

    public void delete(URI path, Collection<String> files, boolean ignoreNoSuchFileException) throws IOException {
        int failedDelete;
        if (files.isEmpty()) {
            return;
        }
        String prefix = this.appendTrailingSeparatorIfNecessary(path.toString());
        List blobDeletes = files.stream().map(file -> BlobId.of((String)this.bucketName, (String)(prefix + file))).collect(Collectors.toList());
        List result = this.storage.delete(blobDeletes);
        if (!ignoreNoSuchFileException && (failedDelete = result.indexOf(Boolean.FALSE)) != -1) {
            throw new NoSuchFileException("File " + ((BlobId)blobDeletes.get(failedDelete)).getName() + " was not found");
        }
    }

    public void copyIndexFileFrom(Directory sourceDir, String sourceFileName, URI destDir, String destFileName) throws IOException {
        Object blobName = destDir.toString();
        blobName = this.appendTrailingSeparatorIfNecessary((String)blobName);
        blobName = (String)blobName + destFileName;
        BlobInfo blobInfo = BlobInfo.newBuilder((String)this.bucketName, (String)blobName).build();
        try (ChecksumIndexInput input = sourceDir.openChecksumInput(sourceFileName, DirectoryFactory.IOCONTEXT_NO_CACHE);){
            if (input.length() <= (long)CodecUtil.footerLength()) {
                throw new CorruptIndexException("file is too small:" + input.length(), (DataInput)input);
            }
            if (input.length() > 0x500000L) {
                this.writeBlobResumable(blobInfo, input);
            } else {
                this.writeBlobMultipart(blobInfo, input, (int)input.length());
            }
        }
    }

    public void copyIndexFileTo(URI sourceRepo, String sourceFileName, Directory dest, String destFileName) throws IOException {
        try {
            Object blobName = sourceRepo.toString();
            blobName = this.appendTrailingSeparatorIfNecessary((String)blobName);
            blobName = (String)blobName + sourceFileName;
            BlobId blobId = BlobId.of((String)this.bucketName, (String)blobName);
            try (ReadChannel readChannel = this.storage.reader(blobId, new Storage.BlobSourceOption[0]);
                 IndexOutput output = dest.createOutput(destFileName, DirectoryFactory.IOCONTEXT_NO_CACHE);){
                ByteBuffer buffer = ByteBuffer.allocate(this.readBufferSizeBytes);
                while (readChannel.read(buffer) > 0) {
                    buffer.flip();
                    byte[] arr = buffer.array();
                    output.writeBytes(arr, buffer.position(), buffer.limit() - buffer.position());
                    buffer.clear();
                }
            }
        }
        catch (Exception e) {
            log.info("Here's an exception e", (Throwable)e);
        }
    }

    public void close() throws IOException {
    }

    private void writeBlobMultipart(BlobInfo blobInfo, ChecksumIndexInput indexInput, int blobSize) throws IOException {
        byte[] bytes = new byte[blobSize];
        indexInput.readBytes(bytes, 0, blobSize - CodecUtil.footerLength());
        long checksum = CodecUtil.checkFooter((ChecksumIndexInput)indexInput);
        ByteBuffer footerBuffer = ByteBuffer.wrap(bytes, blobSize - CodecUtil.footerLength(), CodecUtil.footerLength());
        this.writeFooter(checksum, footerBuffer);
        try {
            this.storage.create(blobInfo, bytes, new Storage.BlobTargetOption[]{Storage.BlobTargetOption.doesNotExist()});
        }
        catch (StorageException se) {
            if (se.getCode() == 412) {
                throw new FileAlreadyExistsException(blobInfo.getBlobId().getName(), null, se.getMessage());
            }
            throw se;
        }
    }

    private void writeBlobResumable(BlobInfo blobInfo, ChecksumIndexInput indexInput) throws IOException {
        try {
            int byteReads;
            WriteChannel writeChannel = this.storage.writer(blobInfo, this.getDefaultBlobWriteOptions());
            ByteBuffer buffer = ByteBuffer.allocate(this.writeBufferSizeBytes);
            writeChannel.setChunkSize(this.writeBufferSizeBytes);
            for (long remain = indexInput.length() - (long)CodecUtil.footerLength(); remain > 0L; remain -= (long)byteReads) {
                byteReads = (int)Math.min((long)buffer.capacity(), remain);
                indexInput.readBytes(buffer.array(), 0, byteReads);
                buffer.position(byteReads);
                buffer.flip();
                writeChannel.write(buffer);
                buffer.clear();
            }
            long checksum = CodecUtil.checkFooter((ChecksumIndexInput)indexInput);
            ByteBuffer bytes = this.getFooter(checksum);
            writeChannel.write(bytes);
            writeChannel.close();
        }
        catch (StorageException se) {
            if (se.getCode() == 412) {
                throw new FileAlreadyExistsException(blobInfo.getBlobId().getName(), null, se.getMessage());
            }
            throw se;
        }
    }

    private ByteBuffer getFooter(long checksum) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(CodecUtil.footerLength());
        this.writeFooter(checksum, buffer);
        return buffer;
    }

    private void writeFooter(final long checksum, final ByteBuffer buffer) throws IOException {
        IndexOutput out = new IndexOutput("", ""){

            public void writeByte(byte b) throws IOException {
                buffer.put(b);
            }

            public void writeBytes(byte[] b, int offset, int length) throws IOException {
                buffer.put(b, offset, length);
            }

            public void close() throws IOException {
            }

            public long getFilePointer() {
                return 0L;
            }

            public long getChecksum() throws IOException {
                return checksum;
            }
        };
        CodecUtil.writeFooter((IndexOutput)out);
        buffer.flip();
    }

    protected Storage.BlobWriteOption[] getDefaultBlobWriteOptions() {
        return NO_WRITE_OPTIONS;
    }

    private String appendTrailingSeparatorIfNecessary(String blobName) {
        if (!blobName.endsWith("/")) {
            return blobName + "/";
        }
        return blobName;
    }
}

