/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.change.AbstractChange;
import liquibase.change.ChangeStatus;
import liquibase.change.CheckSum;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.DbmsTargetedChange;
import liquibase.change.core.RawSQLChange;
import liquibase.database.Database;
import liquibase.database.core.Db2zDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawCompoundStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.util.StringUtil;

public abstract class AbstractSQLChange
extends AbstractChange
implements DbmsTargetedChange {
    private boolean stripComments;
    private boolean splitStatements;
    private boolean splitStatementsSet;
    private String endDelimiter;
    private String sql;
    private String dbms;
    protected String encoding;

    protected AbstractSQLChange() {
        this.setStripComments(null);
        this.setSplitStatements(null);
    }

    public InputStream openSqlStream() throws IOException {
        return null;
    }

    @Override
    @DatabaseChangeProperty(since="3.0", exampleValue="h2, oracle")
    public String getDbms() {
        return this.dbms;
    }

    @Override
    public void setDbms(String dbms) {
        this.dbms = dbms;
    }

    @Override
    public boolean supports(Database database) {
        return true;
    }

    @Override
    public Warnings warn(Database database) {
        return new Warnings();
    }

    @Override
    public ValidationErrors validate(Database database) {
        ValidationErrors validationErrors = new ValidationErrors();
        if (StringUtil.trimToNull(this.sql) == null) {
            validationErrors.addError("'sql' is required");
        }
        return validationErrors;
    }

    @DatabaseChangeProperty(description="Set to true to remove any comments in the SQL before executing, otherwise false. Defaults to false if not set")
    public Boolean isStripComments() {
        return this.stripComments;
    }

    public void setStripComments(Boolean stripComments) {
        this.stripComments = stripComments == null ? false : stripComments;
    }

    @DatabaseChangeProperty(description="Set to false to not have liquibase split statements on ;'s and GO's. Defaults to true if not set")
    public Boolean isSplitStatements() {
        return this.splitStatements;
    }

    public void setSplitStatements(Boolean splitStatements) {
        if (splitStatements == null) {
            this.splitStatements = true;
        } else {
            this.splitStatements = splitStatements;
            this.splitStatementsSet = true;
        }
    }

    @Deprecated
    public boolean isSplitStatementsSet() {
        return this.splitStatementsSet;
    }

    @DatabaseChangeProperty(serializationType=LiquibaseSerializable.SerializationType.DIRECT_VALUE)
    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = StringUtil.trimToNull(sql);
    }

    @DatabaseChangeProperty(description="Delimiter to apply to the end of the statement. Defaults to ';', may be set to ''.", exampleValue="\\nGO")
    public String getEndDelimiter() {
        return this.endDelimiter;
    }

    public void setEndDelimiter(String endDelimiter) {
        this.endDelimiter = endDelimiter;
    }

    @Override
    public CheckSum generateCheckSum() {
        InputStream stream = null;
        try {
            stream = this.openSqlStream();
            String sql = this.sql;
            if (stream == null && sql == null) {
                sql = "";
            }
            if (sql != null) {
                stream = new ByteArrayInputStream(sql.getBytes(GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue()));
            }
            CheckSum checkSum = CheckSum.compute(new NormalizingStream(this.getEndDelimiter(), this.isSplitStatements(), this.isStripComments(), stream), false);
            return checkSum;
        }
        catch (IOException e) {
            throw new UnexpectedLiquibaseException(e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    Scope.getCurrentScope().getLog(this.getClass()).fine("Error closing stream", e);
                }
            }
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) {
        ArrayList<RawSqlStatement> returnStatements = new ArrayList<RawSqlStatement>();
        String sql = StringUtil.trimToNull(this.getSql());
        if (sql == null) {
            return SqlStatement.EMPTY_SQL_STATEMENT;
        }
        String processedSQL = this.normalizeLineEndings(sql);
        if (this instanceof RawSQLChange && ((RawSQLChange)this).isRerunnable()) {
            returnStatements.add(new RawSqlStatement(processedSQL, this.getEndDelimiter()));
            return returnStatements.toArray(SqlStatement.EMPTY_SQL_STATEMENT);
        }
        for (String statement : StringUtil.processMultiLineSQL(processedSQL, this.isStripComments(), this.isSplitStatements(), this.getEndDelimiter())) {
            if (database instanceof MSSQLDatabase) {
                statement = statement.replaceAll("\\n", "\r\n");
            }
            String escapedStatement = statement;
            try {
                if (database.getConnection() != null) {
                    escapedStatement = database.getConnection().nativeSQL(statement);
                }
            }
            catch (DatabaseException e) {
                escapedStatement = statement;
            }
            if (database instanceof Db2zDatabase && escapedStatement.toUpperCase().startsWith("CALL")) {
                returnStatements.add(new RawCompoundStatement(escapedStatement, this.getEndDelimiter()));
                continue;
            }
            returnStatements.add(new RawSqlStatement(escapedStatement, this.getEndDelimiter()));
        }
        return returnStatements.toArray(SqlStatement.EMPTY_SQL_STATEMENT);
    }

    @Override
    public boolean generateStatementsVolatile(Database database) {
        return false;
    }

    @Override
    public boolean generateRollbackStatementsVolatile(Database database) {
        return false;
    }

    @Override
    public ChangeStatus checkStatus(Database database) {
        return new ChangeStatus().unknown("Cannot check raw sql status");
    }

    protected String normalizeLineEndings(String string) {
        return string.replace("\r", "");
    }

    public static class NormalizingStream
    extends InputStream {
        private ByteArrayInputStream headerStream;
        private PushbackInputStream stream;
        private byte[] quickBuffer = new byte[100];
        private List<Byte> resizingBuffer = new ArrayList<Byte>();
        private int lastChar = 88;
        private boolean seenNonSpace;

        public NormalizingStream(String endDelimiter, Boolean splitStatements, Boolean stripComments, InputStream stream) {
            this.stream = new PushbackInputStream(stream, 2048);
            try {
                this.headerStream = new ByteArrayInputStream((endDelimiter + ":" + splitStatements + ":" + stripComments + ":").getBytes(GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue()));
            }
            catch (UnsupportedEncodingException e) {
                throw new UnexpectedLiquibaseException(e);
            }
        }

        @Override
        public int read() throws IOException {
            int returnChar;
            if (this.headerStream != null) {
                returnChar = this.headerStream.read();
                if (returnChar != -1) {
                    return returnChar;
                }
                this.headerStream = null;
            }
            if (this.isWhiteSpace(returnChar = this.stream.read())) {
                returnChar = 32;
            }
            while (!(returnChar != 32 || this.seenNonSpace && this.lastChar != 32)) {
                returnChar = this.stream.read();
                if (!this.isWhiteSpace(returnChar)) continue;
                returnChar = 32;
            }
            this.seenNonSpace = true;
            this.lastChar = returnChar;
            if (this.lastChar == 32 && this.isOnlyWhitespaceRemaining()) {
                return -1;
            }
            return returnChar;
        }

        @Override
        public int available() throws IOException {
            return this.stream.available();
        }

        @Override
        public boolean markSupported() {
            return this.stream.markSupported();
        }

        @Override
        public synchronized void mark(int readLimit) {
            this.stream.mark(readLimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.stream.reset();
        }

        private boolean isOnlyWhitespaceRemaining() throws IOException {
            try {
                int quickBufferUsed = 0;
                while (true) {
                    byte read = (byte)this.stream.read();
                    if (quickBufferUsed >= this.quickBuffer.length) {
                        this.resizingBuffer.add(read);
                    } else {
                        this.quickBuffer[quickBufferUsed++] = read;
                    }
                    if (read == -1) {
                        boolean bl = true;
                        return bl;
                    }
                    if (this.isWhiteSpace(read)) continue;
                    if (!this.resizingBuffer.isEmpty()) {
                        byte[] buf = new byte[this.resizingBuffer.size()];
                        for (int i = 0; i < this.resizingBuffer.size(); ++i) {
                            buf[i] = this.resizingBuffer.get(i);
                        }
                        this.stream.unread(buf);
                    }
                    this.stream.unread(this.quickBuffer, 0, quickBufferUsed);
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.resizingBuffer.clear();
            }
        }

        private boolean isWhiteSpace(int read) {
            return read == 32 || read == 10 || read == 13 || read == 9;
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
        }
    }
}

