/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.spring;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import liquibase.Contexts;
import liquibase.GlobalConfiguration;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.Scope;
import liquibase.configuration.ConfiguredValue;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.OfflineConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.integration.commandline.LiquibaseCommandLineConfiguration;
import liquibase.integration.spring.SpringResourceAccessor;
import liquibase.logging.Logger;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StringUtil;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;

public class SpringLiquibase
implements InitializingBean,
BeanNameAware,
ResourceLoaderAware {
    protected final Logger log = Scope.getCurrentScope().getLog(SpringLiquibase.class);
    protected String beanName;
    protected ResourceLoader resourceLoader;
    protected DataSource dataSource;
    protected String changeLog;
    protected String contexts;
    protected String labelFilter;
    protected String tag;
    protected Map<String, String> parameters;
    protected String defaultSchema;
    protected String liquibaseSchema;
    protected String databaseChangeLogTable;
    protected String databaseChangeLogLockTable;
    protected String liquibaseTablespace;
    protected boolean dropFirst;
    protected boolean clearCheckSums;
    protected boolean shouldRun = true;
    protected File rollbackFile;
    protected boolean testRollbackOnUpdate = false;

    public boolean isDropFirst() {
        return this.dropFirst;
    }

    public void setDropFirst(boolean dropFirst) {
        this.dropFirst = dropFirst;
    }

    public boolean isClearCheckSums() {
        return this.clearCheckSums;
    }

    public void setClearCheckSums(boolean clearCheckSums) {
        this.clearCheckSums = clearCheckSums;
    }

    public void setShouldRun(boolean shouldRun) {
        this.shouldRun = shouldRun;
    }

    public String getDatabaseProductName() throws DatabaseException {
        Connection connection = null;
        Database database = null;
        String name = "unknown";
        try {
            connection = this.getDataSource().getConnection();
            database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation(new JdbcConnection(connection));
            name = database.getDatabaseProductName();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            if (database != null) {
                database.close();
            } else if (connection != null) {
                try {
                    if (!connection.getAutoCommit()) {
                        connection.rollback();
                    }
                    connection.close();
                }
                catch (SQLException e) {
                    this.log.warning("problem closing connection", e);
                }
            }
        }
        return name;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getChangeLog() {
        return this.changeLog;
    }

    public void setChangeLog(String dataModel) {
        this.changeLog = dataModel;
    }

    public String getContexts() {
        return this.contexts;
    }

    public void setContexts(String contexts) {
        this.contexts = contexts;
    }

    public String getLabels() {
        return this.getLabelFilter();
    }

    public void setLabels(String labels) {
        this.setLabelFilter(labels);
    }

    public String getLabelFilter() {
        return this.labelFilter;
    }

    public void setLabelFilter(String labelFilter) {
        this.labelFilter = labelFilter;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    public String getLiquibaseTablespace() {
        return this.liquibaseTablespace;
    }

    public void setLiquibaseTablespace(String liquibaseTablespace) {
        this.liquibaseTablespace = liquibaseTablespace;
    }

    public String getLiquibaseSchema() {
        return this.liquibaseSchema;
    }

    public void setLiquibaseSchema(String liquibaseSchema) {
        this.liquibaseSchema = liquibaseSchema;
    }

    public String getDatabaseChangeLogTable() {
        return this.databaseChangeLogTable;
    }

    public void setDatabaseChangeLogTable(String databaseChangeLogTable) {
        this.databaseChangeLogTable = databaseChangeLogTable;
    }

    public String getDatabaseChangeLogLockTable() {
        return this.databaseChangeLogLockTable;
    }

    public void setDatabaseChangeLogLockTable(String databaseChangeLogLockTable) {
        this.databaseChangeLogLockTable = databaseChangeLogLockTable;
    }

    public boolean isTestRollbackOnUpdate() {
        return this.testRollbackOnUpdate;
    }

    public void setTestRollbackOnUpdate(boolean testRollbackOnUpdate) {
        this.testRollbackOnUpdate = testRollbackOnUpdate;
    }

    public void afterPropertiesSet() throws LiquibaseException {
        ConfiguredValue<Boolean> shouldRunProperty = LiquibaseCommandLineConfiguration.SHOULD_RUN.getCurrentConfiguredValue();
        if (!shouldRunProperty.getValue().booleanValue()) {
            Scope.getCurrentScope().getLog(this.getClass()).info("Liquibase did not run because " + shouldRunProperty.getProvidedValue().describe() + " was set to false");
            return;
        }
        if (!this.shouldRun) {
            Scope.getCurrentScope().getLog(this.getClass()).info("Liquibase did not run because 'shouldRun' property was set to false on " + this.getBeanName() + " Liquibase Spring bean.");
            return;
        }
        Connection c = null;
        try (Liquibase liquibase = null;){
            c = this.getDataSource().getConnection();
            liquibase = this.createLiquibase(c);
            this.generateRollbackFile(liquibase);
            this.performUpdate(liquibase);
        }
    }

    private void generateRollbackFile(Liquibase liquibase) throws LiquibaseException {
        if (this.rollbackFile != null) {
            try (FileOutputStream fileOutputStream = new FileOutputStream(this.rollbackFile);
                 OutputStreamWriter output = new OutputStreamWriter((OutputStream)fileOutputStream, GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue());){
                if (this.tag != null) {
                    liquibase.futureRollbackSQL(this.tag, new Contexts(this.getContexts()), new LabelExpression(this.getLabelFilter()), (Writer)output);
                } else {
                    liquibase.futureRollbackSQL(new Contexts(this.getContexts()), new LabelExpression(this.getLabelFilter()), (Writer)output);
                }
            }
            catch (IOException e) {
                throw new LiquibaseException("Unable to generate rollback file.", e);
            }
        }
    }

    protected void performUpdate(Liquibase liquibase) throws LiquibaseException {
        if (this.isClearCheckSums()) {
            liquibase.clearCheckSums();
        }
        if (this.isTestRollbackOnUpdate()) {
            if (this.tag != null) {
                liquibase.updateTestingRollback(this.tag, new Contexts(this.getContexts()), new LabelExpression(this.getLabelFilter()));
            } else {
                liquibase.updateTestingRollback(new Contexts(this.getContexts()), new LabelExpression(this.getLabelFilter()));
            }
        } else if (this.tag != null) {
            liquibase.update(this.tag, new Contexts(this.getContexts()), new LabelExpression(this.getLabelFilter()));
        } else {
            liquibase.update(new Contexts(this.getContexts()), new LabelExpression(this.getLabelFilter()));
        }
    }

    protected Liquibase createLiquibase(Connection c) throws LiquibaseException {
        SpringResourceAccessor resourceAccessor = this.createResourceOpener();
        Liquibase liquibase = new Liquibase(this.getChangeLog(), (ResourceAccessor)resourceAccessor, this.createDatabase(c, resourceAccessor));
        if (this.parameters != null) {
            for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
                liquibase.setChangeLogParameter(entry.getKey(), entry.getValue());
            }
        }
        if (this.isDropFirst()) {
            liquibase.dropAll();
        }
        return liquibase;
    }

    protected Database createDatabase(Connection c, ResourceAccessor resourceAccessor) throws DatabaseException {
        DatabaseConnection liquibaseConnection;
        if (c == null) {
            this.log.warning("Null connection returned by liquibase datasource. Using offline unknown database");
            liquibaseConnection = new OfflineConnection("offline:unknown", resourceAccessor);
        } else {
            liquibaseConnection = new JdbcConnection(c);
        }
        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation(liquibaseConnection);
        if (StringUtil.trimToNull(this.defaultSchema) != null) {
            if (database.supportsSchemas()) {
                database.setDefaultSchemaName(this.defaultSchema);
            } else if (database.supportsCatalogs()) {
                database.setDefaultCatalogName(this.defaultSchema);
            }
        }
        if (StringUtil.trimToNull(this.liquibaseSchema) != null) {
            if (database.supportsSchemas()) {
                database.setLiquibaseSchemaName(this.liquibaseSchema);
            } else if (database.supportsCatalogs()) {
                database.setLiquibaseCatalogName(this.liquibaseSchema);
            }
        }
        if (StringUtil.trimToNull(this.liquibaseTablespace) != null && database.supportsTablespaces()) {
            database.setLiquibaseTablespaceName(this.liquibaseTablespace);
        }
        if (StringUtil.trimToNull(this.databaseChangeLogTable) != null) {
            database.setDatabaseChangeLogTableName(this.databaseChangeLogTable);
        }
        if (StringUtil.trimToNull(this.databaseChangeLogLockTable) != null) {
            database.setDatabaseChangeLogLockTableName(this.databaseChangeLogLockTable);
        }
        return database;
    }

    public void setChangeLogParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    protected SpringResourceAccessor createResourceOpener() {
        return new SpringResourceAccessor(this.resourceLoader);
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setRollbackFile(File rollbackFile) {
        this.rollbackFile = rollbackFile;
    }

    public boolean isIgnoreClasspathPrefix() {
        return true;
    }

    public void setIgnoreClasspathPrefix(boolean ignoreClasspathPrefix) {
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.getResourceLoader().toString() + ")";
    }
}

