/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.internal.Nullable;
import java.util.Map;

public final class OutgoingHttpRequest {
    private final String method;
    private final String url;
    private final HttpContent content;
    private final Map<String, Object> headers;

    public OutgoingHttpRequest(String method, String url) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)method) ? 1 : 0) != 0, (Object)"method must not be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)url) ? 1 : 0) != 0, (Object)"url must not be empty");
        this.method = method;
        this.url = url;
        this.content = null;
        this.headers = ImmutableMap.of();
    }

    OutgoingHttpRequest(HttpRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request must not be null");
        this.method = request.getRequestMethod();
        this.url = request.getUrl().toString();
        this.content = request.getContent();
        this.headers = ImmutableMap.copyOf((Map)request.getHeaders());
    }

    public String getMethod() {
        return this.method;
    }

    public String getUrl() {
        return this.url;
    }

    @Nullable
    public HttpContent getContent() {
        return this.content;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }
}

