/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.resource;

import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Date;
import javax.annotation.security.PermitAll;
import javax.inject.Inject;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.traccar.api.BaseResource;
import org.traccar.api.security.LoginService;
import org.traccar.api.signature.TokenManager;
import org.traccar.helper.DataConverter;
import org.traccar.helper.LogAction;
import org.traccar.helper.ServletHelper;
import org.traccar.model.User;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

@Path(value="session")
@Produces(value={"application/json"})
@Consumes(value={"application/x-www-form-urlencoded"})
public class SessionResource
extends BaseResource {
    public static final String USER_ID_KEY = "userId";
    public static final String USER_COOKIE_KEY = "user";
    public static final String PASS_COOKIE_KEY = "password";
    @Inject
    private LoginService loginService;
    @Inject
    private TokenManager tokenManager;
    @Context
    private HttpServletRequest request;

    @PermitAll
    @GET
    public User get(@QueryParam(value="token") String token) throws StorageException, IOException, GeneralSecurityException {
        User user;
        if (token != null && (user = this.loginService.login(token)) != null) {
            this.request.getSession().setAttribute(USER_ID_KEY, (Object)user.getId());
            LogAction.login(user.getId(), ServletHelper.retrieveRemoteAddress(this.request));
            return user;
        }
        Long userId = (Long)this.request.getSession().getAttribute(USER_ID_KEY);
        if (userId == null) {
            User user2;
            Cookie[] cookies = this.request.getCookies();
            String email = null;
            String password = null;
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (cookie.getName().equals(USER_COOKIE_KEY)) {
                        byte[] emailBytes = DataConverter.parseBase64(URLDecoder.decode(cookie.getValue(), StandardCharsets.US_ASCII));
                        email = new String(emailBytes, StandardCharsets.UTF_8);
                        continue;
                    }
                    if (!cookie.getName().equals(PASS_COOKIE_KEY)) continue;
                    byte[] passwordBytes = DataConverter.parseBase64(URLDecoder.decode(cookie.getValue(), StandardCharsets.US_ASCII));
                    password = new String(passwordBytes, StandardCharsets.UTF_8);
                }
            }
            if (email != null && password != null && (user2 = this.loginService.login(email, password)) != null) {
                this.request.getSession().setAttribute(USER_ID_KEY, (Object)user2.getId());
                LogAction.login(user2.getId(), ServletHelper.retrieveRemoteAddress(this.request));
                return user2;
            }
        } else {
            User user3 = this.permissionsService.getUser(userId);
            if (user3 != null) {
                return user3;
            }
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).build());
    }

    @Path(value="{id}")
    @GET
    public User get(@PathParam(value="id") long userId) throws StorageException {
        this.permissionsService.checkAdmin(this.getUserId());
        User user = this.storage.getObject(User.class, new Request((Columns)new Columns.All(), new Condition.Equals("id", userId)));
        this.request.getSession().setAttribute(USER_ID_KEY, (Object)user.getId());
        LogAction.login(user.getId(), ServletHelper.retrieveRemoteAddress(this.request));
        return user;
    }

    @PermitAll
    @POST
    public User add(@FormParam(value="email") String email, @FormParam(value="password") String password) throws StorageException {
        User user = this.loginService.login(email, password);
        if (user != null) {
            this.request.getSession().setAttribute(USER_ID_KEY, (Object)user.getId());
            LogAction.login(user.getId(), ServletHelper.retrieveRemoteAddress(this.request));
            return user;
        }
        LogAction.failedLogin(ServletHelper.retrieveRemoteAddress(this.request));
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
    }

    @DELETE
    public Response remove() {
        LogAction.logout(this.getUserId(), ServletHelper.retrieveRemoteAddress(this.request));
        this.request.getSession().removeAttribute(USER_ID_KEY);
        return Response.noContent().build();
    }

    @Path(value="token")
    @POST
    public String requestToken(@FormParam(value="expiration") Date expiration) throws StorageException, GeneralSecurityException, IOException {
        return this.tokenManager.generateToken(this.getUserId(), expiration);
    }
}

