/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler.events;

import io.netty.channel.ChannelHandler;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.traccar.config.Keys;
import org.traccar.handler.events.BaseEventHandler;
import org.traccar.helper.model.AttributeUtil;
import org.traccar.helper.model.PositionUtil;
import org.traccar.model.Device;
import org.traccar.model.Event;
import org.traccar.model.Position;
import org.traccar.session.cache.CacheManager;

@Singleton
@ChannelHandler.Sharable
public class FuelEventHandler
extends BaseEventHandler {
    private final CacheManager cacheManager;

    @Inject
    public FuelEventHandler(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    protected Map<Event, Position> analyzePosition(Position position) {
        Position lastPosition;
        Device device = this.cacheManager.getObject(Device.class, position.getDeviceId());
        if (device == null) {
            return null;
        }
        if (!PositionUtil.isLatest(this.cacheManager, position)) {
            return null;
        }
        if (position.hasAttribute("fuel") && (lastPosition = this.cacheManager.getPosition(position.getDeviceId())) != null && lastPosition.hasAttribute("fuel")) {
            double threshold;
            double before = lastPosition.getDouble("fuel");
            double after = position.getDouble("fuel");
            double change = after - before;
            if (change > 0.0) {
                double threshold2 = AttributeUtil.lookup(this.cacheManager, Keys.EVENT_FUEL_INCREASE_THRESHOLD, position.getDeviceId());
                if (threshold2 > 0.0 && change >= threshold2) {
                    return Map.of(new Event("deviceFuelIncrease", position), position);
                }
            } else if (change < 0.0 && (threshold = AttributeUtil.lookup(this.cacheManager, Keys.EVENT_FUEL_DROP_THRESHOLD, position.getDeviceId()).doubleValue()) > 0.0 && Math.abs(change) >= threshold) {
                return Map.of(new Event("deviceFuelDrop", position), position);
            }
        }
        return null;
    }
}

