/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.authentication;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.zaproxy.zap.authentication.AbstractCredentialsOptionsPanel;
import org.zaproxy.zap.authentication.AuthenticationCredentials;
import org.zaproxy.zap.authentication.AuthenticationMethodType;
import org.zaproxy.zap.extension.api.ApiDynamicActionImplementor;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.users.ExtensionUserManagement;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.utils.ApiUtils;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.LayoutHelper;

public class UsernamePasswordAuthenticationCredentials
implements AuthenticationCredentials {
    private static final String API_NAME = "UsernamePasswordAuthenticationCredentials";
    private static final String NULL_CREDENTIALS = "AA==";
    private static String FIELD_SEPARATOR = "~";
    private String username;
    private String password;
    private static final String ACTION_SET_CREDENTIALS = "formBasedAuthenticationCredentials";
    private static final String PARAM_USERNAME = "username";
    private static final String PARAM_PASSWORD = "password";

    public UsernamePasswordAuthenticationCredentials() {
    }

    public UsernamePasswordAuthenticationCredentials(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public boolean isConfigured() {
        return this.username != null && this.password != null;
    }

    @Override
    public String encode(String parentStringSeparator) {
        if (FIELD_SEPARATOR.equals(parentStringSeparator)) {
            throw new IllegalArgumentException("The string separator must not be the same as Field Separator (" + FIELD_SEPARATOR + ").");
        }
        if (this.username == null) {
            return NULL_CREDENTIALS;
        }
        StringBuilder out = new StringBuilder();
        out.append(Base64.encodeBase64String(this.username.getBytes())).append(FIELD_SEPARATOR);
        out.append(Base64.encodeBase64String(this.password.getBytes())).append(FIELD_SEPARATOR);
        return out.toString();
    }

    @Override
    public void decode(String encodedCredentials) {
        if (NULL_CREDENTIALS.equals(encodedCredentials)) {
            this.username = null;
            this.password = null;
            return;
        }
        String[] pieces = encodedCredentials.split(FIELD_SEPARATOR);
        if (pieces.length == 0) {
            this.username = "";
            this.password = "";
            return;
        }
        this.username = new String(Base64.decodeBase64(pieces[0]));
        this.password = pieces.length > 1 ? new String(Base64.decodeBase64(pieces[1])) : "";
    }

    @Override
    public ApiResponse getApiResponseRepresentation() {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("type", API_NAME);
        values.put(PARAM_USERNAME, this.username);
        values.put(PARAM_PASSWORD, this.password);
        return new ApiResponseSet("credentials", values);
    }

    public static ApiDynamicActionImplementor getSetCredentialsForUserApiAction(final AuthenticationMethodType methodType) {
        return new ApiDynamicActionImplementor(ACTION_SET_CREDENTIALS, new String[]{PARAM_USERNAME, PARAM_PASSWORD}, null){

            @Override
            public void handleAction(JSONObject params) throws ApiException {
                Context context = ApiUtils.getContextByParamId(params, "contextId");
                int userId = ApiUtils.getIntParam(params, "userId");
                if (!methodType.isTypeForMethod(context.getAuthenticationMethod())) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "User's credentials should match authentication method type of the context: " + context.getAuthenticationMethod().getType().getName());
                }
                ExtensionUserManagement extensionUserManagement = Control.getSingleton().getExtensionLoader().getExtension(ExtensionUserManagement.class);
                User user = extensionUserManagement.getContextUserAuthManager(context.getId()).getUserById(userId);
                if (user == null) {
                    throw new ApiException(ApiException.Type.USER_NOT_FOUND, "userId");
                }
                UsernamePasswordAuthenticationCredentials credentials = new UsernamePasswordAuthenticationCredentials();
                credentials.username = ApiUtils.getNonEmptyStringParam(params, UsernamePasswordAuthenticationCredentials.PARAM_USERNAME);
                credentials.password = params.optString(UsernamePasswordAuthenticationCredentials.PARAM_PASSWORD, "");
                user.setAuthenticationCredentials(credentials);
            }
        };
    }

    protected static class UsernamePasswordAuthenticationCredentialsOptionsPanel
    extends AbstractCredentialsOptionsPanel<UsernamePasswordAuthenticationCredentials> {
        private static final long serialVersionUID = 8881019014296985804L;
        private static final String USERNAME_LABEL = Constant.messages.getString("authentication.method.fb.credentials.field.label.user");
        private static final String PASSWORD_LABEL = Constant.messages.getString("authentication.method.fb.credentials.field.label.pass");
        private ZapTextField usernameTextField;
        private JPasswordField passwordTextField;

        public UsernamePasswordAuthenticationCredentialsOptionsPanel(UsernamePasswordAuthenticationCredentials credentials) {
            super(credentials);
            this.initialize();
        }

        private void initialize() {
            this.setLayout(new GridBagLayout());
            this.add((Component)new JLabel(USERNAME_LABEL), LayoutHelper.getGBC(0, 0, 1, 0.0));
            this.usernameTextField = new ZapTextField();
            if (((UsernamePasswordAuthenticationCredentials)this.getCredentials()).username != null) {
                this.usernameTextField.setText(((UsernamePasswordAuthenticationCredentials)this.getCredentials()).username);
            }
            this.add((Component)this.usernameTextField, LayoutHelper.getGBC(1, 0, 1, 0.0, new Insets(0, 4, 0, 0)));
            this.add((Component)new JLabel(PASSWORD_LABEL), LayoutHelper.getGBC(0, 1, 1, 0.0));
            this.passwordTextField = new JPasswordField();
            if (((UsernamePasswordAuthenticationCredentials)this.getCredentials()).password != null) {
                this.passwordTextField.setText(((UsernamePasswordAuthenticationCredentials)this.getCredentials()).password);
            }
            this.add((Component)this.passwordTextField, LayoutHelper.getGBC(1, 1, 1, 1.0, new Insets(0, 4, 0, 0)));
        }

        @Override
        public boolean validateFields() {
            if (this.usernameTextField.getText().isEmpty()) {
                JOptionPane.showMessageDialog(this, Constant.messages.getString("authentication.method.fb.credentials.dialog.error.user.text"), Constant.messages.getString("authentication.method.fb.dialog.error.title"), 2);
                this.usernameTextField.requestFocusInWindow();
                return false;
            }
            return true;
        }

        @Override
        public void saveCredentials() {
            ((UsernamePasswordAuthenticationCredentials)this.getCredentials()).username = this.usernameTextField.getText();
            ((UsernamePasswordAuthenticationCredentials)this.getCredentials()).password = new String(this.passwordTextField.getPassword());
        }
    }
}

