/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.socket.jdk8;

import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.socket.BaseDelegatingSocketChannel;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;

class DelegatingSocketChannel<T extends SocketChannel>
extends BaseDelegatingSocketChannel<T>
implements SelChImpl {
    private static final Logger classLogger = Logger.getLogger(DelegatingSocketChannel.class.getName());
    protected final SelChImpl delegateAsSelChImpl;
    private final Method translateAndSetInterestOpsMethod;
    private final Method translateInterestOpsMethod;

    public DelegatingSocketChannel(T delegate) {
        super(delegate);
        Method method;
        this.delegateAsSelChImpl = delegate instanceof SelChImpl ? (SelChImpl)delegate : null;
        try {
            method = SelChImpl.class.getMethod("translateAndSetInterestOps", Integer.TYPE, SelectionKeyImpl.class);
        }
        catch (NoSuchMethodException e) {
            method = null;
        }
        this.translateAndSetInterestOpsMethod = method;
        try {
            method = SelChImpl.class.getMethod("translateInterestOps", Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            method = null;
        }
        this.translateInterestOpsMethod = method;
        if (this.translateInterestOpsMethod == null && this.translateAndSetInterestOpsMethod == null) {
            classLogger.log(Level.SEVERE, "Cannot find translateInterestOps or translateAndSetInterestOps!");
        }
    }

    @Override
    public FileDescriptor getFD() {
        return this.delegateAsSelChImpl.getFD();
    }

    @Override
    public int getFDVal() {
        return this.delegateAsSelChImpl.getFDVal();
    }

    @Override
    public void kill() throws IOException {
        this.delegateAsSelChImpl.kill();
    }

    public void translateAndSetInterestOps(int ops, SelectionKeyImpl sk) {
        try {
            if (this.translateAndSetInterestOpsMethod != null) {
                this.translateAndSetInterestOpsMethod.invoke((Object)this.delegateAsSelChImpl, ops, sk);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            classLogger.log(Level.SEVERE, "Cannot execute method translateAndSetInterestOpsMethod", e);
        }
    }

    @Override
    public int translateInterestOps(int ops) {
        try {
            if (this.translateInterestOpsMethod != null) {
                return (Integer)this.translateInterestOpsMethod.invoke((Object)this.delegateAsSelChImpl, ops);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            classLogger.log(Level.SEVERE, "Cannot execute method translateInterestOpsMethod", e);
        }
        return 0;
    }

    @Override
    public boolean translateAndSetReadyOps(int ops, SelectionKeyImpl sk) {
        return this.delegateAsSelChImpl.translateAndSetReadyOps(ops, sk);
    }

    @Override
    public boolean translateAndUpdateReadyOps(int ops, SelectionKeyImpl sk) {
        return this.delegateAsSelChImpl.translateAndUpdateReadyOps(ops, sk);
    }
}

