/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.FormatAdapter;
import jalview.FormatProperties;
import jalview.Popup;
import java.awt.Choice;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextArea;

public class OutputPopup
extends Popup {
    TextArea ta = new TextArea(25, 80);
    Label format;
    Choice f;

    public OutputPopup(Frame frame, String string) {
        super(frame, string);
        this.ta.setFont(new Font("Courier", 0, 12));
        this.format = new Label("Alignment format");
        this.f = new Choice();
        int n = 0;
        while (n < FormatProperties.formats.size()) {
            this.f.addItem((String)FormatProperties.formats.elementAt(n));
            ++n;
        }
        this.gbc.fill = 0;
        this.gbc.insets = new Insets(20, 20, 20, 20);
        this.add(this.ta, this.gb, this.gbc, 0, 0, 4, 4);
        this.add(this.format, this.gb, this.gbc, 0, 4, 1, 1);
        this.add(this.f, this.gb, this.gbc, 1, 4, 1, 1);
        this.add(this.apply, this.gb, this.gbc, 0, 5, 1, 1);
        this.add(this.close, this.gb, this.gbc, 1, 5, 1, 1);
        this.pack();
        super.show();
    }

    public boolean handleEvent(Event event) {
        if (event.target == this.apply && event.id == 1001) {
            if (FormatProperties.contains(this.f.getSelectedItem())) {
                if (this.parent instanceof AlignFrame) {
                    AlignFrame alignFrame = (AlignFrame)this.parent;
                    String string = FormatAdapter.get(this.f.getSelectedItem().toUpperCase(), alignFrame.ap.seqPanel.align.sequences);
                    this.ta.setText(string);
                } else {
                    System.out.println("Error : parent isn't Alignment Frame");
                }
            } else {
                System.out.println("Not yet supported");
            }
            return true;
        }
        if (event.target == this.f) {
            return false;
        }
        return super.handleEvent(event);
    }
}

