/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex;

import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.android.dex.format.DexConstants;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemBase;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.GFileSystemBaseFactory;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.CryptoException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.jf.baksmali.baksmali;
import org.jf.dexlib.DexFile;

@FileSystemInfo(type="dex2smali", description="Android DEX to SMALI", factory=GFileSystemBaseFactory.class)
public class DexToSmaliFileSystem
extends GFileSystemBase {
    private Map<GFile, File> map = new HashMap<GFile, File>();

    public DexToSmaliFileSystem(String fileSystemName, ByteProvider provider) {
        super(fileSystemName, provider);
    }

    protected InputStream getData(GFile file, TaskMonitor monitor) throws IOException, CancelledException, CryptoException {
        File entry = this.map.get(file);
        return new FileInputStream(entry);
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        if (directory == null || directory.equals(this.root)) {
            ArrayList<GFile> roots = new ArrayList<GFile>();
            for (GFile file : this.map.keySet()) {
                if (file.getParentFile() != this.root && !file.getParentFile().equals(this.root)) continue;
                roots.add(file);
            }
            return roots;
        }
        ArrayList<GFile> tmp = new ArrayList<GFile>();
        for (GFile file : this.map.keySet()) {
            if (file.getParentFile() == null || !file.getParentFile().equals(directory)) continue;
            tmp.add(file);
        }
        return tmp;
    }

    public boolean isValid(TaskMonitor monitor) throws IOException {
        return DexConstants.isDexFile(this.provider);
    }

    public void open(TaskMonitor monitor) throws IOException, CryptoException, CancelledException {
        monitor.setMessage("Converting DEX to SMALI...");
        File dexFileFile = this.provider.getFile();
        boolean isFixRegisters = false;
        boolean isNoParameterRegisters = false;
        boolean isUseLocalsDirective = false;
        boolean isUseSequentialLabels = false;
        boolean isOutputDebugInfo = true;
        boolean isAddCodeOffsets = false;
        boolean isDeOdex = false;
        boolean isVerify = false;
        boolean isIgnoreErrors = false;
        int registerInfo = 0;
        boolean isNoAccessorComments = false;
        String inlineTable = null;
        boolean isCheckPackagePrivateAccess = false;
        String baseTempPath = System.getProperty("java.io.tmpdir");
        int rand = new Random().nextInt() & 0xFFFF;
        File tempOutputDirectory = new File(baseTempPath + File.separator + "ghidra_file_system_" + rand);
        String bootClassPath = "core.jar:ext.jar:framework.jar:android.policy.jar:services.jar";
        StringBuffer extraBootClassPathEntries = new StringBuffer();
        ArrayList<String> bootClassPathDirs = new ArrayList<String>();
        bootClassPathDirs.add(".");
        DexFile dexFile = new DexFile(dexFileFile, !isFixRegisters, false);
        String[] bootClassPathDirsArray = new String[bootClassPathDirs.size()];
        for (int i = 0; i < bootClassPathDirsArray.length; ++i) {
            bootClassPathDirsArray[i] = (String)bootClassPathDirs.get(i);
        }
        baksmali.disassembleDexFile((String)dexFileFile.getPath(), (DexFile)dexFile, (boolean)isDeOdex, (String)tempOutputDirectory.getPath(), (String[])bootClassPathDirsArray, (String)bootClassPath, (String)extraBootClassPathEntries.toString(), (boolean)isNoParameterRegisters, (boolean)isUseLocalsDirective, (boolean)isUseSequentialLabels, (boolean)isOutputDebugInfo, (boolean)isAddCodeOffsets, (boolean)isNoAccessorComments, (int)registerInfo, (boolean)isVerify, (boolean)isIgnoreErrors, inlineTable, (boolean)isCheckPackagePrivateAccess);
        this.getFileListing(tempOutputDirectory, this.root, monitor);
    }

    private void getFileListing(File startingDirectory, GFileImpl currentRoot, TaskMonitor monitor) {
        Iterator iterator = FileUtils.iterateFiles((File)startingDirectory, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
        while (iterator.hasNext()) {
            File f = (File)iterator.next();
            if (monitor.isCancelled()) break;
            monitor.setMessage(f.getName());
            GFileImpl gfile = GFileImpl.fromFilename((GFileSystem)this, (GFile)currentRoot, (String)f.getName(), (boolean)f.isDirectory(), (long)f.length(), null);
            this.storeFile((GFile)gfile, f);
        }
    }

    private void storeFile(GFile file, File entry) {
        if (file == null) {
            return;
        }
        if (file.equals(this.root)) {
            return;
        }
        if (!this.map.containsKey(file) || this.map.get(file) == null) {
            this.map.put(file, entry);
        }
        GFile parentFile = file.getParentFile();
        this.storeFile(parentFile, null);
    }

    public void close() throws IOException {
        this.map.clear();
        super.close();
    }
}

