/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.dex.util.Leb128;
import java.io.IOException;

class DebugInfoStateMachineReader {
    DebugInfoStateMachineReader() {
    }

    static int computeLength(BinaryReader reader) throws IOException {
        int length = 0;
        while (length <= 65536) {
            byte opcode = reader.readNextByte();
            ++length;
            switch (opcode) {
                case 0: {
                    return length;
                }
                case 1: {
                    int advance = Leb128.readUnsignedLeb128(reader.readByteArray(reader.getPointerIndex(), 5));
                    int advanceLength = Leb128.unsignedLeb128Size(advance);
                    reader.setPointerIndex(reader.getPointerIndex() + (long)advanceLength);
                    length += advanceLength;
                    break;
                }
                case 2: {
                    int advance = Leb128.readSignedLeb128(reader.readByteArray(reader.getPointerIndex(), 5));
                    int advanceLength = Leb128.signedLeb128Size(advance);
                    reader.setPointerIndex(reader.getPointerIndex() + (long)advanceLength);
                    length += advanceLength;
                    break;
                }
                case 3: {
                    int register = Leb128.readUnsignedLeb128(reader.readByteArray(reader.getPointerIndex(), 5));
                    int registerLength = Leb128.unsignedLeb128Size(register);
                    reader.setPointerIndex(reader.getPointerIndex() + (long)registerLength);
                    length += registerLength;
                    int name = Leb128.readUnsignedLeb128(reader.readByteArray(reader.getPointerIndex(), 5));
                    int nameLength = Leb128.unsignedLeb128Size(name);
                    reader.setPointerIndex(reader.getPointerIndex() + (long)nameLength);
                    length += nameLength;
                    int type = Leb128.readUnsignedLeb128(reader.readByteArray(reader.getPointerIndex(), 5));
                    int typeLength = Leb128.unsignedLeb128Size(type);
                    reader.setPointerIndex(reader.getPointerIndex() + (long)typeLength);
                    length += typeLength;
                    break;
                }
                case 4: {
                    int register = Leb128.readUnsignedLeb128(reader.readByteArray(reader.getPointerIndex(), 5));
                    int registerLength = Leb128.unsignedLeb128Size(register);
                    reader.setPointerIndex(reader.getPointerIndex() + (long)registerLength);
                    length += registerLength;
                    int name = Leb128.readUnsignedLeb128(reader.readByteArray(reader.getPointerIndex(), 5));
                    int nameLength = Leb128.unsignedLeb128Size(name);
                    reader.setPointerIndex(reader.getPointerIndex() + (long)nameLength);
                    length += nameLength;
                    int type = Leb128.readUnsignedLeb128(reader.readByteArray(reader.getPointerIndex(), 5));
                    int typeLength = Leb128.unsignedLeb128Size(type);
                    reader.setPointerIndex(reader.getPointerIndex() + (long)typeLength);
                    length += typeLength;
                    int signature = Leb128.readUnsignedLeb128(reader.readByteArray(reader.getPointerIndex(), 5));
                    int signatureLength = Leb128.unsignedLeb128Size(signature);
                    reader.setPointerIndex(reader.getPointerIndex() + (long)signatureLength);
                    length += signatureLength;
                    break;
                }
                case 5: {
                    int register = Leb128.readUnsignedLeb128(reader.readByteArray(reader.getPointerIndex(), 5));
                    int registerLength = Leb128.unsignedLeb128Size(register);
                    reader.setPointerIndex(reader.getPointerIndex() + (long)registerLength);
                    length += registerLength;
                    break;
                }
                case 6: {
                    int register = Leb128.readUnsignedLeb128(reader.readByteArray(reader.getPointerIndex(), 5));
                    int registerLength = Leb128.unsignedLeb128Size(register);
                    reader.setPointerIndex(reader.getPointerIndex() + (long)registerLength);
                    length += registerLength;
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    int name = Leb128.readUnsignedLeb128(reader.readByteArray(reader.getPointerIndex(), 5));
                    int nameLength = Leb128.unsignedLeb128Size(name);
                    reader.setPointerIndex(reader.getPointerIndex() + (long)nameLength);
                    length += nameLength;
                    break;
                }
            }
        }
        return 0;
    }
}

