/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ext4;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.io.Serializable;

public class Ext4DirEntry2
implements StructConverter {
    private int inode;
    private short rec_len;
    private byte name_len;
    private byte file_type;
    private String name;
    private byte[] extra;

    public Ext4DirEntry2(ByteProvider provider) throws IOException {
        this(new BinaryReader(provider, true));
    }

    public Ext4DirEntry2(BinaryReader reader) throws IOException {
        this.inode = reader.readNextInt();
        this.rec_len = reader.readNextShort();
        this.name_len = reader.readNextByte();
        this.file_type = reader.readNextByte();
        this.name = reader.readNextAsciiString(this.name_len & 0xFF);
        int extraSize = (this.rec_len & 0xFFFF) - (8 + (this.name_len & 0xFF));
        if (extraSize > 0) {
            this.extra = reader.readNextByteArray(extraSize);
        }
    }

    public int getInode() {
        return this.inode;
    }

    public short getRec_len() {
        return this.rec_len;
    }

    public byte getName_len() {
        return this.name_len;
    }

    public byte getFile_type() {
        return this.file_type;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getExtra() {
        return this.extra;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        String nameEnd = this.rec_len + "_" + (Serializable)(this.extra == null ? "0" : Integer.valueOf(this.extra.length));
        StructureDataType structure = new StructureDataType("ext4_dir_entry2_" + nameEnd, 0);
        structure.add(DWORD, "inode", null);
        structure.add(WORD, "rec_len", null);
        structure.add(BYTE, "name_len", null);
        structure.add(BYTE, "file_type", null);
        if ((this.name_len & 0xFF) > 0) {
            structure.add(STRING, this.name_len & 0xFF, "name", null);
        }
        if (this.extra != null) {
            structure.add((DataType)new ArrayDataType(BYTE, this.extra.length, BYTE.getLength()), "extra", null);
        }
        return structure;
    }
}

