/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.dialogs;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.label.GDLabel;
import docking.widgets.textfield.IntegerTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.math.BigInteger;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class NumberInputDialog
extends DialogComponentProvider {
    private boolean wasCancelled = false;
    private IntegerTextField numberInputField;
    private int min;
    private int max;
    private JLabel label;
    private String defaultMessage;

    public NumberInputDialog(String entryType, int initial, int min) {
        this("Enter Number", NumberInputDialog.buildDefaultPrompt(entryType, min, min - 1), initial, min, Integer.MAX_VALUE, false);
    }

    public NumberInputDialog(String entryType, int initial, int min, int max) {
        this("Enter Number", NumberInputDialog.buildDefaultPrompt(entryType, min, max), initial, min, max, false);
    }

    public NumberInputDialog(String title, String prompt, Integer initialValue) {
        this(title, prompt, initialValue, 0, Integer.MAX_VALUE, false);
    }

    public NumberInputDialog(String title, String prompt, Integer initialValue, int min, int max, boolean showAsHex) {
        super(title, true, true, true, false);
        this.min = min;
        if (max < min) {
            throw new IllegalArgumentException("'min' cannot be less than 'max'. 'min' = " + min + ", 'max' = " + max);
        }
        this.max = max;
        this.addWorkPanel(this.buildMainPanel(prompt, showAsHex));
        this.addOKButton();
        this.addCancelButton();
        this.setRememberLocation(false);
        this.setRememberSize(false);
        this.initializeDefaultValue(initialValue);
        this.selectAndFocusText();
    }

    private static String nonNull(String s) {
        if (s == null) {
            return "items";
        }
        return s;
    }

    protected JPanel buildMainPanel(String prompt, boolean showAsHex) {
        JPanel panel = this.createPanel(prompt);
        this.numberInputField.addActionListener(e -> this.okCallback());
        if (showAsHex) {
            this.numberInputField.setHexMode();
        }
        if (this.min >= 0) {
            this.numberInputField.setAllowNegativeValues(false);
        }
        return panel;
    }

    @Override
    protected void okCallback() {
        if (this.checkInput()) {
            this.close();
        }
    }

    @Override
    protected void cancelCallback() {
        this.wasCancelled = true;
        this.close();
    }

    public boolean wasCancelled() {
        return this.wasCancelled;
    }

    private void initializeDefaultValue(Integer initial) {
        if (initial == null) {
            return;
        }
        int value = initial;
        if (value < this.min) {
            value = this.min;
        } else if (value > this.max) {
            value = this.max;
        }
        this.numberInputField.setValue(value);
    }

    private void selectAndFocusText() {
        SwingUtilities.invokeLater(() -> {
            this.numberInputField.requestFocus();
            this.numberInputField.selectAll();
        });
    }

    public boolean show() {
        Component parent = DockingWindowManager.getActiveInstance().getActiveComponent();
        DockingWindowManager.showDialog(parent, this);
        return !this.wasCancelled;
    }

    public int getValue() {
        if (this.wasCancelled()) {
            throw new IllegalStateException();
        }
        return this.numberInputField.getIntValue();
    }

    public void setInput(int value) {
        this.numberInputField.setValue(value);
    }

    public void setDefaultMessage(String defaultMessage) {
        this.defaultMessage = defaultMessage;
        this.setStatusText(defaultMessage);
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    IntegerTextField getNumberInputField() {
        return this.numberInputField;
    }

    private JPanel createPanel(String prompt) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.label = new GDLabel(prompt);
        this.numberInputField = new IntegerTextField(12);
        this.numberInputField.addChangeListener(e -> this.updateOKButtonEnablement());
        panel.add((Component)this.label, "West");
        panel.add((Component)this.numberInputField.getComponent(), "Center");
        return panel;
    }

    protected void updateOKButtonEnablement() {
        this.clearStatusText();
        BigInteger value = this.numberInputField.getValue();
        if (value == null) {
            this.setOkEnabled(false);
            if (this.defaultMessage != null) {
                this.setStatusText(this.defaultMessage);
            } else {
                this.setStatusText("Enter a value between " + this.min + " and " + this.max);
            }
            return;
        }
        this.setOkEnabled(this.checkInput());
    }

    private boolean checkInput() {
        int value = this.numberInputField.getIntValue();
        return this.checkDecimalRange(value);
    }

    private boolean checkDecimalRange(int decimalValue) {
        if (decimalValue >= this.min && decimalValue <= this.max) {
            if (this.defaultMessage != null) {
                this.setStatusText(this.defaultMessage);
            }
            return true;
        }
        this.setStatusText("Value must be between " + this.min + " and " + this.max);
        return false;
    }

    private static String buildDefaultPrompt(String entryType, int min, int max) {
        String type = NumberInputDialog.nonNull(entryType);
        if (min == 0 && max == Integer.MAX_VALUE) {
            return "Enter number of " + type + ": ";
        }
        if (max == Integer.MAX_VALUE) {
            return "Enter number of " + type + " (minimum is " + min + ") : ";
        }
        return "Enter number of " + type + " (" + min + ", " + max + ") : ";
    }
}

