/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.AnyObjectTableModel;
import docking.widgets.table.GFilterTable;
import docking.widgets.table.GTable;
import docking.widgets.table.ObjectSelectedListener;
import docking.widgets.table.TableItemPickedListener;
import docking.widgets.table.TableSortState;
import java.awt.BorderLayout;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class GTableWidget<T>
extends JPanel {
    private AnyObjectTableModel<T> myModel;
    private GFilterTable<T> gFilterTable;
    private GTable table;
    private TableItemPickedListener<T> listener;

    public GTableWidget(String modelName, Class<T> tClass, String ... methodNames) {
        this(modelName, tClass, Arrays.asList(methodNames));
    }

    public GTableWidget(String modelName, Method ... methods) {
        this(modelName, Arrays.asList(methods));
    }

    public GTableWidget(String modelName, Class<T> tClass, List<String> methodNames) {
        super(new BorderLayout());
        AnyObjectTableModel<T> model = new AnyObjectTableModel<T>(modelName, tClass, methodNames);
        this.init(model);
    }

    public GTableWidget(String modelName, List<Method> methodNames) {
        super(new BorderLayout());
        AnyObjectTableModel model = new AnyObjectTableModel(modelName, methodNames);
        this.init(model);
    }

    private void init(AnyObjectTableModel<T> model) {
        this.myModel = model;
        this.gFilterTable = new GFilterTable<T>(model);
        this.table = this.gFilterTable.getTable();
        this.table.setAutoResizeMode(3);
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!e.isShiftDown()) {
                    GTableWidget.this.processMouseClicked(e);
                }
            }
        });
        this.add(this.gFilterTable);
    }

    public void setColumnPreferredWidths(int ... widths) {
        int columnCount = this.table.getColumnCount();
        int n = Math.min(widths.length, columnCount);
        TableColumnModel model = this.table.getColumnModel();
        for (int i = 0; i < n; ++i) {
            TableColumn column = model.getColumn(i);
            int width = widths[i];
            if (width == 75) {
                width = 76;
            }
            column.setWidth(width);
            column.setPreferredWidth(widths[i]);
        }
    }

    public void setSortColumn(int column) {
        this.myModel.setTableSortState(TableSortState.createDefaultSortState(column));
    }

    protected void processMouseClicked(MouseEvent e) {
        if (this.listener == null) {
            return;
        }
        if (e.getClickCount() != 2) {
            return;
        }
        int rowAtPoint = this.table.rowAtPoint(e.getPoint());
        if (rowAtPoint < 0) {
            return;
        }
        this.listener.itemPicked(this.gFilterTable.getSelectedRowObject());
    }

    public void setItemPickListener(TableItemPickedListener<T> listener) {
        this.listener = listener;
    }

    public List<T> getData() {
        return this.myModel.getModelData();
    }

    public void setData(List<T> data) {
        this.myModel.setModelData(data);
    }

    public void setData(Collection<T> data) {
        ArrayList<T> list = null;
        list = data instanceof List ? (ArrayList<T>)data : new ArrayList<T>(data);
        this.setData((List<T>)list);
    }

    public List<T> getSelectedRowObjects() {
        return this.gFilterTable.getSelectedRowObjects();
    }

    public void addSelectionListener(ObjectSelectedListener<T> l) {
        this.gFilterTable.addSelectionListener(l);
    }

    public void removeSelectionListener(ObjectSelectedListener<T> l) {
        this.gFilterTable.removeSelectionListener(l);
    }

    public T getItemAt(Point point) {
        return this.gFilterTable.getItemAt(point);
    }

    public AnyObjectTableModel<T> getModel() {
        return this.myModel;
    }

    public void addColumn(AbstractDynamicTableColumn<T, ?, Object> column) {
        this.myModel.addTableColumn(column);
    }

    public void addColumn(AbstractDynamicTableColumn<T, ?, Object> column, int index) {
        this.myModel.addTableColumn(column, index, true);
    }

    public int getRowCount() {
        return this.table.getRowCount();
    }

    public T getRowObject(int row) {
        return this.gFilterTable.getRowObject(row);
    }

    public void selectRow(int row) {
        this.table.selectRow(row);
    }

    public void selectRowObject(T rowObject) {
        this.gFilterTable.setSelectedRowObject(rowObject);
    }

    public int getSelectedRow() {
        return this.table.getSelectedRow();
    }

    public int rowAtPoint(Point point) {
        return this.table.rowAtPoint(point);
    }

    public boolean isRowSelected(int row) {
        return this.table.isRowSelected(row);
    }

    public GTable getTable() {
        return this.table;
    }

    public void focusFilter() {
        this.gFilterTable.focusFilter();
    }
}

