/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.io.File;
import java.io.PrintStream;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.NamespaceException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import javax.jcr.version.VersionException;
import javax.security.auth.Subject;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.jsr283.retention.RetentionManager;
import org.apache.jackrabbit.api.jsr283.security.AccessControlManager;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.AbstractSession;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SessionListener;
import org.apache.jackrabbit.core.SystemSession;
import org.apache.jackrabbit.core.WorkspaceImpl;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.data.GarbageCollector;
import org.apache.jackrabbit.core.lock.LockManager;
import org.apache.jackrabbit.core.nodetype.NodeDefinitionImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.core.persistence.IterablePersistenceManager;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.retention.RetentionManagerImpl;
import org.apache.jackrabbit.core.security.AMContext;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.security.authentication.AuthContext;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.LocalItemStateManager;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.SessionItemStateManager;
import org.apache.jackrabbit.core.state.SharedItemStateManager;
import org.apache.jackrabbit.core.util.Dumpable;
import org.apache.jackrabbit.core.version.VersionManager;
import org.apache.jackrabbit.core.version.VersionManagerImpl;
import org.apache.jackrabbit.core.xml.ImportHandler;
import org.apache.jackrabbit.core.xml.SessionImporter;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.uuid.UUID;
import org.apache.jackrabbit.value.ValueFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class SessionImpl
extends AbstractSession
implements JackrabbitSession,
NamespaceResolver,
NamePathResolver,
Dumpable {
    private static Logger log = LoggerFactory.getLogger((Class)SessionImpl.class);
    public static final String READ_ACTION = "read";
    public static final String REMOVE_ACTION = "remove";
    public static final String ADD_NODE_ACTION = "add_node";
    public static final String SET_PROPERTY_ACTION = "set_property";
    protected boolean alive = true;
    protected final RepositoryImpl rep;
    protected AuthContext loginContext;
    protected final Subject subject;
    protected final String userId;
    protected final HashMap attributes = new HashMap();
    protected final NodeTypeManagerImpl ntMgr;
    protected AccessManager accessMgr;
    protected final SessionItemStateManager itemStateMgr;
    protected final HierarchyManager hierMgr;
    protected final ItemManager itemMgr;
    protected final WorkspaceImpl wsp;
    protected NamePathResolver namePathResolver;
    protected final VersionManager versionMgr;
    protected final Map listeners = new ReferenceMap(2, 2);
    protected final Set lockTokens = new HashSet();
    protected ValueFactory valueFactory;
    private PrincipalManager principalManager;
    private UserManager userManager;
    private RetentionManager retentionManager;
    private Exception openStackTrace = new Exception("Stack Trace");

    protected SessionImpl(RepositoryImpl rep, AuthContext loginContext, WorkspaceConfig wspConfig) throws AccessDeniedException, RepositoryException {
        this(rep, loginContext.getSubject(), wspConfig);
        this.loginContext = loginContext;
    }

    protected SessionImpl(RepositoryImpl rep, Subject subject, WorkspaceConfig wspConfig) throws AccessDeniedException, RepositoryException {
        this.rep = rep;
        this.subject = subject;
        this.userId = this.retrieveUserId(subject);
        this.namePathResolver = new DefaultNamePathResolver(this, true);
        this.ntMgr = new NodeTypeManagerImpl(rep.getNodeTypeRegistry(), this, rep.getDataStore());
        String wspName = wspConfig.getName();
        this.wsp = this.createWorkspaceInstance(wspConfig, rep.getWorkspaceStateManager(wspName), rep, this);
        this.itemStateMgr = this.createSessionItemStateManager(this.wsp.getItemStateManager());
        this.hierMgr = this.itemStateMgr.getHierarchyMgr();
        this.itemMgr = this.createItemManager(this.itemStateMgr, this.hierMgr);
        this.accessMgr = this.createAccessManager(subject, this.itemStateMgr.getHierarchyMgr());
        this.versionMgr = this.createVersionManager(rep);
    }

    protected String retrieveUserId(Subject subject) throws RepositoryException {
        return this.rep.getSecurityManager().getUserID(subject);
    }

    protected SessionItemStateManager createSessionItemStateManager(LocalItemStateManager manager) {
        return new SessionItemStateManager(this.rep.getRootNodeId(), manager, this.rep.getNodeTypeRegistry());
    }

    protected WorkspaceImpl createWorkspaceInstance(WorkspaceConfig wspConfig, SharedItemStateManager stateMgr, RepositoryImpl rep, SessionImpl session) {
        return new WorkspaceImpl(wspConfig, stateMgr, rep, session);
    }

    protected ItemManager createItemManager(SessionItemStateManager itemStateMgr, HierarchyManager hierMgr) {
        return new ItemManager(itemStateMgr, hierMgr, this, this.ntMgr.getRootNodeDefinition(), this.rep.getRootNodeId());
    }

    protected VersionManager createVersionManager(RepositoryImpl rep) throws RepositoryException {
        return rep.getVersionManager();
    }

    protected AccessManager createAccessManager(Subject subject, HierarchyManager hierarchyManager) throws AccessDeniedException, RepositoryException {
        String wspName = this.getWorkspace().getName();
        AMContext ctx = new AMContext(new File(this.rep.getConfig().getHomeDir()), this.rep.getFileSystem(), this, this.getSubject(), hierarchyManager, this, wspName);
        return this.rep.getSecurityManager().getAccessManager(this, ctx);
    }

    protected void sanityCheck() throws RepositoryException {
        if (!this.alive) {
            throw new RepositoryException("this session has been closed");
        }
    }

    public Subject getSubject() {
        return this.subject;
    }

    public Session createSession(String workspaceName) throws AccessDeniedException, NoSuchWorkspaceException, RepositoryException {
        if (workspaceName == null) {
            workspaceName = this.rep.getConfig().getDefaultWorkspaceName();
        }
        if (this.loginContext != null) {
            return this.rep.createSession(this.loginContext, workspaceName);
        }
        return this.rep.createSession(this.getSubject(), workspaceName);
    }

    public AccessManager getAccessManager() {
        return this.accessMgr;
    }

    public NodeTypeManagerImpl getNodeTypeManager() {
        return this.ntMgr;
    }

    public ItemManager getItemManager() {
        return this.itemMgr;
    }

    protected SessionItemStateManager getItemStateManager() {
        return this.itemStateMgr;
    }

    public HierarchyManager getHierarchyManager() {
        return this.hierMgr;
    }

    public VersionManager getVersionManager() {
        return this.versionMgr;
    }

    public Node getNodeByUUID(UUID uuid) throws ItemNotFoundException, RepositoryException {
        NodeImpl node = this.getNodeById(new NodeId(uuid));
        return node;
    }

    public NodeImpl getNodeById(NodeId id) throws ItemNotFoundException, RepositoryException {
        this.sanityCheck();
        try {
            return (NodeImpl)this.getItemManager().getItem(id);
        }
        catch (AccessDeniedException ade) {
            throw new ItemNotFoundException(id.toString());
        }
    }

    protected String[] getWorkspaceNames() throws RepositoryException {
        ArrayList<String> list = new ArrayList<String>();
        String[] names = this.rep.getWorkspaceNames();
        for (int i = 0; i < names.length; ++i) {
            try {
                if (!this.getAccessManager().canAccess(names[i])) continue;
                list.add(names[i]);
                continue;
            }
            catch (NoSuchWorkspaceException nswe) {
                // empty catch block
            }
        }
        return list.toArray(new String[list.size()]);
    }

    protected void createWorkspace(String workspaceName) throws AccessDeniedException, RepositoryException {
        this.rep.createWorkspace(workspaceName);
    }

    protected void createWorkspace(String workspaceName, InputSource configTemplate) throws AccessDeniedException, RepositoryException {
        this.rep.createWorkspace(workspaceName, configTemplate);
    }

    protected void notifyLoggingOut() {
        SessionListener[] la = this.listeners.values().toArray(new SessionListener[this.listeners.size()]);
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].loggingOut(this);
        }
    }

    protected void notifyLoggedOut() {
        SessionListener[] la = this.listeners.values().toArray(new SessionListener[this.listeners.size()]);
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].loggedOut(this);
        }
    }

    public void addListener(SessionListener listener) {
        if (!this.listeners.containsKey(listener)) {
            this.listeners.put(listener, listener);
        }
    }

    public void removeListener(SessionListener listener) {
        this.listeners.remove(listener);
    }

    public GarbageCollector createDataStoreGarbageCollector() throws RepositoryException, ItemStateException {
        ArrayList<PersistenceManager> pmList = new ArrayList<PersistenceManager>();
        VersionManagerImpl vm = (VersionManagerImpl)this.rep.getVersionManager();
        PersistenceManager pm = vm.getPersistenceManager();
        pmList.add(pm);
        String[] wspNames = this.rep.getWorkspaceNames();
        Session[] sessions = new Session[wspNames.length];
        for (int i = 0; i < wspNames.length; ++i) {
            String wspName = wspNames[i];
            RepositoryImpl.WorkspaceInfo wspInfo = this.rep.getWorkspaceInfo(wspName);
            wspInfo.getSystemSession();
            SystemSession session = SystemSession.create(this.rep, wspInfo.getConfig());
            this.rep.onSessionCreated(session);
            sessions[i] = session;
            pm = wspInfo.getPersistenceManager();
            pmList.add(pm);
        }
        IterablePersistenceManager[] ipmList = new IterablePersistenceManager[pmList.size()];
        for (int i = 0; i < pmList.size(); ++i) {
            pm = (PersistenceManager)pmList.get(i);
            if (!(pm instanceof IterablePersistenceManager)) {
                ipmList = null;
                break;
            }
            ipmList[i] = (IterablePersistenceManager)pm;
        }
        GarbageCollector gc = new GarbageCollector(this, ipmList, sessions);
        return gc;
    }

    public String getPrefix(String uri) throws NamespaceException {
        try {
            return this.getNamespacePrefix(uri);
        }
        catch (NamespaceException e) {
            throw e;
        }
        catch (RepositoryException e) {
            throw new NamespaceException("Namespace not found: " + uri, (Throwable)e);
        }
    }

    public String getURI(String prefix) throws NamespaceException {
        try {
            return this.getNamespaceURI(prefix);
        }
        catch (NamespaceException e) {
            throw e;
        }
        catch (RepositoryException e) {
            throw new NamespaceException("Namespace not found: " + prefix, (Throwable)e);
        }
    }

    public String getJCRName(Name name) throws NamespaceException {
        return this.namePathResolver.getJCRName(name);
    }

    public Name getQName(String name) throws IllegalNameException, NamespaceException {
        return this.namePathResolver.getQName(name);
    }

    public String getJCRPath(Path path) throws NamespaceException {
        return this.namePathResolver.getJCRPath(path);
    }

    public Path getQPath(String path) throws MalformedPathException, IllegalNameException, NamespaceException {
        return this.namePathResolver.getQPath(path);
    }

    public PrincipalManager getPrincipalManager() throws RepositoryException, AccessDeniedException {
        if (this.principalManager == null) {
            this.principalManager = this.rep.getSecurityManager().getPrincipalManager(this);
        }
        return this.principalManager;
    }

    public UserManager getUserManager() throws AccessDeniedException, RepositoryException {
        if (this.userManager == null) {
            this.userManager = this.rep.getSecurityManager().getUserManager(this);
        }
        return this.userManager;
    }

    public void checkPermission(String absPath, String actions) throws AccessControlException, RepositoryException {
        if (!this.hasPermission(absPath, actions)) {
            throw new AccessControlException(actions);
        }
    }

    public Workspace getWorkspace() {
        return this.wsp;
    }

    public Session impersonate(Credentials otherCredentials) throws LoginException, RepositoryException {
        this.sanityCheck();
        if (!(otherCredentials instanceof SimpleCredentials)) {
            String msg = "impersonate failed: incompatible credentials, SimpleCredentials expected";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        SimpleCredentials creds = (SimpleCredentials)otherCredentials;
        creds.setAttribute("org.apache.jackrabbit.core.security.impersonator", (Object)this.subject);
        try {
            Session session = this.rep.login(otherCredentials, this.getWorkspace().getName());
            return session;
        }
        catch (NoSuchWorkspaceException nswe) {
            String msg = "impersonate failed";
            log.error(msg, (Throwable)nswe);
            throw new RepositoryException(msg, (Throwable)nswe);
        }
        finally {
            creds.removeAttribute("org.apache.jackrabbit.core.security.impersonator");
        }
    }

    public Node getRootNode() throws RepositoryException {
        this.sanityCheck();
        return this.getItemManager().getRootNode();
    }

    public Node getNodeByUUID(String uuid) throws ItemNotFoundException, RepositoryException {
        try {
            return this.getNodeByUUID(UUID.fromString(uuid));
        }
        catch (IllegalArgumentException e) {
            throw new RepositoryException("Invalid UUID: " + uuid, (Throwable)e);
        }
    }

    public Item getItem(String absPath) throws PathNotFoundException, RepositoryException {
        this.sanityCheck();
        try {
            Path p = this.getQPath(absPath).getNormalizedPath();
            if (!p.isAbsolute()) {
                throw new RepositoryException("not an absolute path: " + absPath);
            }
            return this.getItemManager().getItem(p);
        }
        catch (AccessDeniedException ade) {
            throw new PathNotFoundException(absPath);
        }
        catch (NameException e) {
            String msg = "invalid path:" + absPath;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)((Object)e));
        }
    }

    public boolean itemExists(String absPath) throws RepositoryException {
        this.sanityCheck();
        try {
            Path p = this.getQPath(absPath).getNormalizedPath();
            if (!p.isAbsolute()) {
                throw new RepositoryException("not an absolute path: " + absPath);
            }
            return this.getItemManager().itemExists(p);
        }
        catch (NameException e) {
            String msg = "invalid path:" + absPath;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)((Object)e));
        }
    }

    public void save() throws AccessDeniedException, ItemExistsException, ConstraintViolationException, InvalidItemStateException, VersionException, LockException, NoSuchNodeTypeException, RepositoryException {
        this.sanityCheck();
        this.getItemManager().getRootNode().save();
    }

    public void refresh(boolean keepChanges) throws RepositoryException {
        this.sanityCheck();
        if (!keepChanges) {
            this.itemStateMgr.disposeAllTransientItemStates();
            return;
        }
        this.getItemManager().getRootNode().refresh(keepChanges);
    }

    public boolean hasPendingChanges() throws RepositoryException {
        this.sanityCheck();
        return this.itemStateMgr.hasAnyTransientItemStates();
    }

    public void move(String srcAbsPath, String destAbsPath) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        NodeDefinitionImpl newTargetDef;
        NodeImpl destParentNode;
        Path.Element destName;
        Path destPath;
        NodeImpl srcParentNode;
        NodeImpl targetNode;
        Path.Element srcName;
        Path srcPath;
        this.sanityCheck();
        try {
            srcPath = this.getQPath(srcAbsPath).getNormalizedPath();
            if (!srcPath.isAbsolute()) {
                throw new RepositoryException("not an absolute path: " + srcAbsPath);
            }
            srcName = srcPath.getNameElement();
            Path srcParentPath = srcPath.getAncestor(1);
            targetNode = this.getItemManager().getNode(srcPath);
            srcParentNode = this.getItemManager().getNode(srcParentPath);
        }
        catch (AccessDeniedException ade) {
            throw new PathNotFoundException(srcAbsPath);
        }
        catch (NameException e) {
            String msg = srcAbsPath + ": invalid path";
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)((Object)e));
        }
        try {
            destPath = this.getQPath(destAbsPath).getNormalizedPath();
            if (!destPath.isAbsolute()) {
                throw new RepositoryException("not an absolute path: " + destAbsPath);
            }
            if (srcPath.isAncestorOf(destPath)) {
                String msg = destAbsPath + ": invalid destination path (cannot be descendant of source path)";
                log.debug(msg);
                throw new RepositoryException(msg);
            }
            destName = destPath.getNameElement();
            Path destParentPath = destPath.getAncestor(1);
            destParentNode = this.getItemManager().getNode(destParentPath);
        }
        catch (AccessDeniedException ade) {
            throw new PathNotFoundException(destAbsPath);
        }
        catch (NameException e) {
            String msg = destAbsPath + ": invalid path";
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)((Object)e));
        }
        if (this.hierMgr.isShareAncestor(targetNode.getNodeId(), destParentNode.getNodeId())) {
            String msg = destAbsPath + ": invalid destination path (share cycle detected)";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        int ind = destName.getIndex();
        if (ind > 0) {
            String msg = destAbsPath + ": invalid destination path (subscript in name element is not allowed)";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        if (!srcParentNode.internalIsCheckedOut()) {
            String msg = srcAbsPath + ": cannot move a child of a checked-in node";
            log.debug(msg);
            throw new VersionException(msg);
        }
        if (!destParentNode.internalIsCheckedOut()) {
            String msg = destAbsPath + ": cannot move a target to a checked-in node";
            log.debug(msg);
            throw new VersionException(msg);
        }
        NodeImpl existing = null;
        try {
            existing = this.getItemManager().getNode(destPath);
            if (!existing.getDefinition().allowsSameNameSiblings()) {
                throw new ItemExistsException("Same name siblings are not allowed: " + existing);
            }
        }
        catch (AccessDeniedException ade) {
            throw new ItemExistsException(destAbsPath);
        }
        catch (PathNotFoundException pnfe) {
            // empty catch block
        }
        NodeTypeImpl nt = (NodeTypeImpl)targetNode.getPrimaryNodeType();
        try {
            newTargetDef = destParentNode.getApplicableChildNodeDefinition(destName.getName(), nt.getQName());
        }
        catch (RepositoryException re) {
            String msg = destAbsPath + ": no definition found in parent node's node type for new node";
            log.debug(msg);
            throw new ConstraintViolationException(msg, (Throwable)re);
        }
        if (existing != null && !newTargetDef.allowsSameNameSiblings()) {
            throw new ItemExistsException("Same name siblings not allowed: " + existing);
        }
        if (destParentNode.getDefinition().isProtected()) {
            String msg = destAbsPath + ": cannot add a child node to a protected node";
            log.debug(msg);
            throw new ConstraintViolationException(msg);
        }
        if (srcParentNode.getDefinition().isProtected()) {
            String msg = srcAbsPath + ": cannot remove a child node from a protected node";
            log.debug(msg);
            throw new ConstraintViolationException(msg);
        }
        srcParentNode.checkLock();
        destParentNode.checkLock();
        NodeId targetId = targetNode.getNodeId();
        int index = srcName.getIndex();
        if (index == 0) {
            index = 1;
        }
        if (srcParentNode.isSame(destParentNode)) {
            destParentNode.renameChildNode(srcName.getName(), index, targetId, destName.getName());
        } else {
            if (((NodeState)targetNode.getItemState()).isShareable()) {
                String msg = "Moving a shareable node is not supported.";
                log.debug(msg);
                throw new UnsupportedRepositoryOperationException(msg);
            }
            NodeState srcParentState = (NodeState)srcParentNode.getOrCreateTransientItemState();
            srcParentState.removeChildNodeEntry(srcName.getName(), index);
            NodeState targetState = (NodeState)targetNode.getOrCreateTransientItemState();
            targetState.setParentId(destParentNode.getNodeId());
            NodeState destParentState = (NodeState)destParentNode.getOrCreateTransientItemState();
            destParentState.addChildNodeEntry(destName.getName(), targetId);
        }
        targetNode.onRedefine(newTargetDef.unwrap().getId());
    }

    public ContentHandler getImportContentHandler(String parentAbsPath, int uuidBehavior) throws PathNotFoundException, ConstraintViolationException, VersionException, LockException, RepositoryException {
        String msg;
        NodeImpl parent;
        this.sanityCheck();
        try {
            Path p = this.getQPath(parentAbsPath).getNormalizedPath();
            if (!p.isAbsolute()) {
                throw new RepositoryException("not an absolute path: " + parentAbsPath);
            }
            parent = this.getItemManager().getNode(p);
        }
        catch (NameException e) {
            String msg2 = parentAbsPath + ": invalid path";
            log.debug(msg2);
            throw new RepositoryException(msg2, (Throwable)((Object)e));
        }
        catch (AccessDeniedException ade) {
            throw new PathNotFoundException(parentAbsPath);
        }
        if (!parent.internalIsCheckedOut()) {
            msg = parentAbsPath + ": cannot add a child to a checked-in node";
            log.debug(msg);
            throw new VersionException(msg);
        }
        if (parent.getDefinition().isProtected()) {
            msg = parentAbsPath + ": cannot add a child to a protected node";
            log.debug(msg);
            throw new ConstraintViolationException(msg);
        }
        parent.checkLock();
        SessionImporter importer = new SessionImporter(parent, this, uuidBehavior);
        return new ImportHandler(importer, this);
    }

    public boolean isLive() {
        return this.alive;
    }

    private void removeRegisteredEventListeners() {
        try {
            ObservationManager manager = this.getWorkspace().getObservationManager();
            List listeners = IteratorUtils.toList((Iterator)manager.getRegisteredEventListeners());
            Iterator iterator = listeners.iterator();
            while (iterator.hasNext()) {
                EventListener listener = (EventListener)iterator.next();
                try {
                    manager.removeEventListener(listener);
                }
                catch (RepositoryException e) {
                    log.warn("Error removing event listener: " + listener, (Throwable)e);
                }
            }
        }
        catch (RepositoryException e) {
            log.warn("Error removing event listeners", (Throwable)e);
        }
    }

    public synchronized void logout() {
        if (!this.alive) {
            return;
        }
        this.removeRegisteredEventListeners();
        this.itemStateMgr.disposeAllTransientItemStates();
        this.notifyLoggingOut();
        this.itemStateMgr.dispose();
        this.itemMgr.dispose();
        this.wsp.dispose();
        this.alive = false;
        if (this.loginContext != null) {
            try {
                this.loginContext.logout();
            }
            catch (javax.security.auth.login.LoginException le) {
                log.warn("failed to logout current subject: " + le.getMessage());
            }
            this.loginContext = null;
        }
        try {
            this.accessMgr.close();
        }
        catch (Exception e) {
            log.warn("error while closing AccessManager", (Throwable)e);
        }
        this.notifyLoggedOut();
    }

    public Repository getRepository() {
        return this.rep;
    }

    public ValueFactory getValueFactory() throws UnsupportedRepositoryOperationException, RepositoryException {
        if (this.valueFactory == null) {
            this.valueFactory = ValueFactoryImpl.getInstance();
        }
        return this.valueFactory;
    }

    public String getUserID() {
        return this.userId;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public String[] getAttributeNames() {
        return this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }

    public void setNamespacePrefix(String prefix, String uri) throws NamespaceException, RepositoryException {
        super.setNamespacePrefix(prefix, uri);
        this.namePathResolver = new DefaultNamePathResolver(this, true);
    }

    public void addLockToken(String lt) {
        this.addLockToken(lt, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLockToken(String lt, boolean notify) {
        Set set = this.lockTokens;
        synchronized (set) {
            if (this.lockTokens.add(lt) && notify) {
                try {
                    this.getLockManager().lockTokenAdded(this, lt);
                }
                catch (RepositoryException e) {
                    log.error("Lock manager not available.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getLockTokens() {
        Set set = this.lockTokens;
        synchronized (set) {
            String[] result = new String[this.lockTokens.size()];
            this.lockTokens.toArray(result);
            return result;
        }
    }

    public void removeLockToken(String lt) {
        this.removeLockToken(lt, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLockToken(String lt, boolean notify) {
        Set set = this.lockTokens;
        synchronized (set) {
            if (this.lockTokens.remove(lt) && notify) {
                try {
                    this.getLockManager().lockTokenRemoved(this, lt);
                }
                catch (RepositoryException e) {
                    log.error("Lock manager not available.", (Throwable)e);
                }
            }
        }
    }

    public LockManager getLockManager() throws RepositoryException {
        return this.wsp.getLockManager();
    }

    public Lock[] getLocks() {
        if (!this.alive) {
            log.error("failed to retrieve locks: session has been closed");
            return new Lock[0];
        }
        try {
            return this.getLockManager().getLocks(this);
        }
        catch (RepositoryException e) {
            log.error("Lock manager not available.", (Throwable)e);
            return new Lock[0];
        }
    }

    public Node getNodeByIdentifier(String id) throws ItemNotFoundException, RepositoryException {
        NodeId nodeId;
        try {
            nodeId = NodeId.valueOf(id);
        }
        catch (IllegalArgumentException iae) {
            throw new RepositoryException("invalid identifier: " + id);
        }
        return this.getNodeById(nodeId);
    }

    public Node getNode(String absPath) throws PathNotFoundException, RepositoryException {
        this.sanityCheck();
        try {
            Path p = this.getQPath(absPath).getNormalizedPath();
            if (!p.isAbsolute()) {
                throw new RepositoryException("not an absolute path: " + absPath);
            }
            return this.getItemManager().getNode(p);
        }
        catch (AccessDeniedException ade) {
            throw new PathNotFoundException(absPath);
        }
        catch (NameException e) {
            String msg = "invalid path:" + absPath;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)((Object)e));
        }
    }

    public Property getProperty(String absPath) throws PathNotFoundException, RepositoryException {
        this.sanityCheck();
        try {
            Path p = this.getQPath(absPath).getNormalizedPath();
            if (!p.isAbsolute()) {
                throw new RepositoryException("not an absolute path: " + absPath);
            }
            return this.getItemManager().getProperty(p);
        }
        catch (AccessDeniedException ade) {
            throw new PathNotFoundException(absPath);
        }
        catch (NameException e) {
            String msg = "invalid path:" + absPath;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)((Object)e));
        }
    }

    public boolean nodeExists(String absPath) throws RepositoryException {
        this.sanityCheck();
        try {
            Path p = this.getQPath(absPath).getNormalizedPath();
            if (!p.isAbsolute()) {
                throw new RepositoryException("not an absolute path: " + absPath);
            }
            return this.getItemManager().nodeExists(p);
        }
        catch (NameException e) {
            String msg = "invalid path:" + absPath;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)((Object)e));
        }
    }

    public boolean propertyExists(String absPath) throws RepositoryException {
        this.sanityCheck();
        try {
            Path p = this.getQPath(absPath).getNormalizedPath();
            if (!p.isAbsolute()) {
                throw new RepositoryException("not an absolute path: " + absPath);
            }
            return this.getItemManager().propertyExists(p);
        }
        catch (NameException e) {
            String msg = "invalid path:" + absPath;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)((Object)e));
        }
    }

    public boolean hasPermission(String absPath, String actions) throws RepositoryException {
        this.sanityCheck();
        Path path = this.getQPath(absPath).getNormalizedPath();
        if (!path.isAbsolute()) {
            throw new RepositoryException("Absolute path expected. Was:" + absPath);
        }
        HashSet<String> s = new HashSet<String>(Arrays.asList(actions.split(",")));
        int permissions = 0;
        if (s.remove(READ_ACTION)) {
            permissions |= 1;
        }
        if (s.remove(ADD_NODE_ACTION)) {
            permissions |= 4;
        }
        if (s.remove(SET_PROPERTY_ACTION)) {
            permissions |= 2;
        }
        if (s.remove(REMOVE_ACTION)) {
            permissions = this.nodeExists(absPath) ? (permissions |= this.propertyExists(absPath) ? 24 : 8) : (this.propertyExists(absPath) ? (permissions |= 0x10) : 24);
        }
        if (!s.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            Iterator it = s.iterator();
            while (it.hasNext()) {
                sb.append(it.next());
            }
            throw new IllegalArgumentException("Unknown actions: " + sb.toString());
        }
        try {
            return this.getAccessManager().isGranted(path, permissions);
        }
        catch (AccessDeniedException e) {
            return false;
        }
    }

    public AccessControlManager getAccessControlManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        if (this.accessMgr instanceof AccessControlManager) {
            return (AccessControlManager)((Object)this.accessMgr);
        }
        throw new UnsupportedRepositoryOperationException("Access control discovery is not supported.");
    }

    public synchronized RetentionManager getRetentionManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        if (this.retentionManager == null) {
            this.retentionManager = new RetentionManagerImpl(this);
        }
        return this.retentionManager;
    }

    public void dump(PrintStream ps) {
        ps.print("Session: ");
        if (this.userId == null) {
            ps.print("unknown");
        } else {
            ps.print(this.userId);
        }
        ps.println(" (" + this + ")");
        ps.println();
        this.itemMgr.dump(ps);
        ps.println();
        this.itemStateMgr.dump(ps);
    }

    public void finalize() {
        if (this.alive) {
            log.warn("Unclosed session detected. The session was opened here: ", (Throwable)this.openStackTrace);
            this.logout();
        }
    }
}

