/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.db;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.persistence.PMContext;
import org.apache.jackrabbit.core.persistence.db.DatabasePersistenceManager;
import org.apache.jackrabbit.core.persistence.db.SimpleDbPersistenceManager;
import org.apache.jackrabbit.core.persistence.util.Serializer;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OraclePersistenceManager
extends SimpleDbPersistenceManager {
    private static Logger log = LoggerFactory.getLogger((Class)OraclePersistenceManager.class);
    private Class blobClass;
    private Integer durationSessionConstant;
    private Integer modeReadWriteConstant;
    public static final String TABLE_SPACE_VARIABLE = "${tableSpace}";
    protected String tableSpace;

    public OraclePersistenceManager() {
        this.schema = "oracle";
        this.driver = "oracle.jdbc.OracleDriver";
        this.schemaObjectPrefix = "";
        this.user = "";
        this.password = "";
        this.initialized = false;
    }

    public String getTableSpace() {
        return this.tableSpace;
    }

    public void setTableSpace(String tableSpace) {
        this.tableSpace = tableSpace != null ? tableSpace.trim() : null;
    }

    public void init(PMContext context) throws Exception {
        super.init(context);
        if (!this.externalBLOBs) {
            this.blobStore = new OracleBLOBStore();
        }
        this.blobClass = this.con.getClass().getClassLoader().loadClass("oracle.sql.BLOB");
        this.durationSessionConstant = new Integer(this.blobClass.getField("DURATION_SESSION").getInt(null));
        this.modeReadWriteConstant = new Integer(this.blobClass.getField("MODE_READWRITE").getInt(null));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void store(NodeState state) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        boolean update = state.getStatus() != 4;
        String sql = update ? this.nodeStateUpdateSQL : this.nodeStateInsertSQL;
        Blob blob = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            Serializer.serialize(state, (OutputStream)out);
            blob = this.createTemporaryBlob(new ByteArrayInputStream(out.toByteArray()));
            this.executeStmt(sql, new Object[]{blob, state.getNodeId().toString()});
            if (blob == null) return;
        }
        catch (Exception e) {
            try {
                String msg = "failed to write node state: " + state.getId();
                log.error(msg, (Throwable)e);
                throw new ItemStateException(msg, e);
            }
            catch (Throwable throwable) {
                if (blob == null) throw throwable;
                try {
                    this.freeTemporaryBlob(blob);
                    throw throwable;
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            this.freeTemporaryBlob(blob);
            return;
        }
        catch (Exception ignore) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void store(PropertyState state) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        boolean update = state.getStatus() != 4;
        String sql = update ? this.propertyStateUpdateSQL : this.propertyStateInsertSQL;
        Blob blob = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            Serializer.serialize(state, out, this.blobStore);
            blob = this.createTemporaryBlob(new ByteArrayInputStream(out.toByteArray()));
            this.executeStmt(sql, new Object[]{blob, state.getPropertyId().toString()});
            if (blob == null) return;
        }
        catch (Exception e) {
            try {
                String msg = "failed to write property state: " + state.getId();
                log.error(msg, (Throwable)e);
                throw new ItemStateException(msg, e);
            }
            catch (Throwable throwable) {
                if (blob == null) throw throwable;
                try {
                    this.freeTemporaryBlob(blob);
                    throw throwable;
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            this.freeTemporaryBlob(blob);
            return;
        }
        catch (Exception ignore) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void store(NodeReferences refs) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        boolean update = this.exists(refs.getId());
        String sql = update ? this.nodeReferenceUpdateSQL : this.nodeReferenceInsertSQL;
        Blob blob = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            Serializer.serialize(refs, (OutputStream)out);
            blob = this.createTemporaryBlob(new ByteArrayInputStream(out.toByteArray()));
            this.executeStmt(sql, new Object[]{blob, refs.getId().toString()});
            if (blob == null) return;
        }
        catch (Exception e) {
            try {
                String msg = "failed to write node references: " + refs.getId();
                log.error(msg, (Throwable)e);
                throw new ItemStateException(msg, e);
            }
            catch (Throwable throwable) {
                if (blob == null) throw throwable;
                try {
                    this.freeTemporaryBlob(blob);
                    throw throwable;
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            this.freeTemporaryBlob(blob);
            return;
        }
        catch (Exception ignore) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkSchema() throws Exception {
        boolean schemaExists;
        DatabaseMetaData metaData = this.con.getMetaData();
        String tableName = this.schemaObjectPrefix + "NODE";
        if (metaData.storesLowerCaseIdentifiers()) {
            tableName = tableName.toLowerCase();
        } else if (metaData.storesUpperCaseIdentifiers()) {
            tableName = tableName.toUpperCase();
        }
        String userName = metaData.getUserName();
        ResultSet rs = metaData.getTables(null, userName, tableName, null);
        try {
            schemaExists = rs.next();
        }
        finally {
            rs.close();
        }
        if (!schemaExists) {
            InputStream in = this.getSchemaDDL();
            if (in == null) {
                String msg = "Configuration error: unknown schema '" + this.schema + "'";
                log.debug(msg);
                throw new RepositoryException(msg);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            Statement stmt = this.con.createStatement();
            try {
                String sql = reader.readLine();
                while (sql != null) {
                    if (!sql.startsWith("#") && sql.length() > 0) {
                        sql = Text.replace(sql, "${schemaObjectPrefix}", this.schemaObjectPrefix);
                        String tspace = this.tableSpace == null || "".equals(this.tableSpace) ? "" : "tablespace " + this.tableSpace;
                        sql = Text.replace(sql, TABLE_SPACE_VARIABLE, tspace).trim();
                        stmt.executeUpdate(sql);
                    }
                    sql = reader.readLine();
                }
                this.con.commit();
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
                this.closeStatement(stmt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Blob createTemporaryBlob(InputStream in) throws Exception {
        Method createTemporary = this.blobClass.getMethod("createTemporary", Connection.class, Boolean.TYPE, Integer.TYPE);
        Object blob = createTemporary.invoke(null, this.con, Boolean.FALSE, this.durationSessionConstant);
        Method open = this.blobClass.getMethod("open", Integer.TYPE);
        open.invoke(blob, this.modeReadWriteConstant);
        Method getBinaryOutputStream = this.blobClass.getMethod("getBinaryOutputStream", new Class[0]);
        OutputStream out = (OutputStream)getBinaryOutputStream.invoke(blob, null);
        try {
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            try {
                out.flush();
            }
            catch (IOException ioe) {}
            out.close();
        }
        Method close = this.blobClass.getMethod("close", new Class[0]);
        close.invoke(blob, null);
        return (Blob)blob;
    }

    protected void freeTemporaryBlob(Object blob) throws Exception {
        Method freeTemporary = this.blobClass.getMethod("freeTemporary", new Class[0]);
        freeTemporary.invoke(blob, null);
    }

    class OracleBLOBStore
    extends DatabasePersistenceManager.DbBLOBStore {
        OracleBLOBStore() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public synchronized void put(String blobId, InputStream in, long size) throws Exception {
            Statement stmt = OraclePersistenceManager.this.executeStmt(OraclePersistenceManager.this.blobSelectExistSQL, new Object[]{blobId});
            ResultSet rs = stmt.getResultSet();
            boolean exists = rs.next();
            OraclePersistenceManager.this.closeResultSet(rs);
            Blob blob = null;
            try {
                String sql = exists ? OraclePersistenceManager.this.blobUpdateSQL : OraclePersistenceManager.this.blobInsertSQL;
                blob = OraclePersistenceManager.this.createTemporaryBlob(in);
                OraclePersistenceManager.this.executeStmt(sql, new Object[]{blob, blobId});
                if (blob == null) return;
            }
            catch (Throwable throwable) {
                if (blob == null) throw throwable;
                try {
                    OraclePersistenceManager.this.freeTemporaryBlob(blob);
                    throw throwable;
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                OraclePersistenceManager.this.freeTemporaryBlob(blob);
                return;
            }
            catch (Exception ignore) {}
        }
    }
}

