/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties;

import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import com.jeta.forms.store.properties.JETAProperty;
import com.jeta.forms.store.properties.TransformProperty;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class TransformOptionsProperty
extends JETAProperty
implements TransformProperty {
    static final long serialVersionUID = -1652327155513571580L;
    public static final int VERSION = 3;
    private transient HashMap m_options = new HashMap();
    private int m_default_value;
    private Method m_getter;
    private String m_getter_name;
    private Method m_setter;
    private String m_setter_name;
    private transient JETABean m_bean;

    public TransformOptionsProperty() {
    }

    public TransformOptionsProperty(String string, String string2, String string3, Object[][] objectArray) {
        super(string);
        this.m_getter_name = string2;
        this.m_setter_name = string3;
        for (int i = 0; i < objectArray.length; ++i) {
            String string4 = (String)objectArray[i][0];
            Integer n = (Integer)objectArray[i][1];
            if (i == 0) {
                this.m_default_value = n;
            }
            this.m_options.put(string4, n);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Integer) {
            return ((Integer)object).intValue() == this.getPropertyValue();
        }
        if (object instanceof TransformOptionsProperty) {
            TransformOptionsProperty transformOptionsProperty = (TransformOptionsProperty)object;
            return transformOptionsProperty.getPropertyValue() == this.getPropertyValue();
        }
        return false;
    }

    public JETABean getBean() {
        return this.m_bean;
    }

    public Object getCurrentItem() {
        int n = this.getPropertyValue();
        Iterator iterator = this.m_options.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Integer n2 = (Integer)this.m_options.get(string);
            if (n2 != n) continue;
            return string;
        }
        return null;
    }

    public Collection getOptions() {
        return this.m_options.keySet();
    }

    public int getPropertyValue() {
        try {
            Integer n = (Integer)this.m_getter.invoke((Object)this.getBean().getDelegate(), new Object[0]);
            return n;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.m_default_value;
        }
    }

    public Method getWriteMethod() {
        return this.m_setter;
    }

    public boolean isTransient() {
        return true;
    }

    public void setBean(JETABean jETABean) {
        try {
            this.m_bean = jETABean;
            if (jETABean != null) {
                Class<?> clazz = jETABean.getDelegate().getClass();
                this.m_getter = clazz.getMethod(this.m_getter_name, new Class[0]);
                this.m_setter = clazz.getMethod(this.m_setter_name, Integer.TYPE);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setValue(Object object) {
        try {
            Integer n = null;
            if (object instanceof String) {
                String string = (String)object;
                n = (Integer)this.m_options.get(string);
                if (n == null) {
                    try {
                        n = Integer.valueOf((String)object);
                    }
                    catch (Exception exception) {}
                }
            } else if (object instanceof Integer) {
                n = (Integer)object;
            } else if (object instanceof TransformOptionsProperty) {
                n = new Integer(((TransformOptionsProperty)object).getPropertyValue());
            }
            if (n != null) {
                this.m_setter.invoke((Object)this.getBean().getDelegate(), n);
            }
        }
        catch (Exception exception) {
            if (object != null) {
                System.out.println("TransformOptionsProperty.setValue failed: " + object.getClass());
            }
            exception.printStackTrace();
        }
    }

    public int size() {
        return this.m_options.size();
    }

    public void updateBean(JETABean jETABean) {
        this.setBean(jETABean);
    }

    public void read(JETAObjectInput jETAObjectInput) throws ClassNotFoundException, IOException {
        int n = jETAObjectInput.readVersion();
    }

    public void write(JETAObjectOutput jETAObjectOutput) throws IOException {
        jETAObjectOutput.writeVersion(3);
    }

    public String toString() {
        return "transform value: " + this.getPropertyValue();
    }
}

