/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.generic;

import ghidra.app.plugin.processors.generic.ConstructorInfo;
import ghidra.app.plugin.processors.generic.ExpressionTerm;
import ghidra.app.plugin.processors.generic.ExpressionValue;
import ghidra.app.plugin.processors.generic.Handle;
import ghidra.app.plugin.processors.generic.Operand;
import ghidra.app.plugin.processors.generic.OperandValue;
import ghidra.app.plugin.processors.generic.Position;
import ghidra.app.plugin.processors.generic.SledException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import java.util.ArrayList;
import java.util.Hashtable;

public class BinaryExpression
implements OperandValue,
ExpressionValue {
    public static final int INVALID_OP = -1;
    public static final int ADD = 0;
    public static final int SUB = 1;
    public static final int MUL = 2;
    public static final int DIV = 3;
    public static final int EQ = 4;
    public static final int AND = 5;
    private int spaceID;
    private int wordSize;
    private AddressSpace constantSpace;
    private int opType;
    private ExpressionTerm left;
    private ExpressionTerm right;

    public BinaryExpression(int op, ExpressionTerm l, ExpressionTerm r, AddressSpace c) throws SledException {
        this.opType = op;
        this.left = l;
        this.right = r;
        this.wordSize = c.getSize() / 8;
        this.spaceID = c.getBaseSpaceID();
        this.constantSpace = c;
        switch (this.opType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            default: {
                throw new SledException("Unrecognized opType (" + this.opType + ") in Binary Expression");
            }
        }
    }

    public void setSpace(AddressSpace space) {
        this.spaceID = space.getBaseSpaceID();
        this.wordSize = space.getSize() / 8;
    }

    @Override
    public int length(MemBuffer buf, int off) throws Exception {
        int rightLen;
        int leftLen = this.left.length(buf, off);
        return leftLen > (rightLen = this.right.length(buf, off)) ? leftLen : rightLen;
    }

    @Override
    public ConstructorInfo getInfo(MemBuffer buf, int off) throws Exception {
        return new ConstructorInfo(this.length(buf, off), 0);
    }

    @Override
    public long longValue(MemBuffer buf, int off) throws Exception {
        long l = this.left.longValue(buf, off);
        long r = this.right.longValue(buf, off);
        switch (this.opType) {
            case 0: {
                return l + r;
            }
            case 1: {
                return l - r;
            }
            case 2: {
                return l * r;
            }
            case 3: {
                return l / r;
            }
            case 5: {
                return l & r;
            }
        }
        return 0L;
    }

    @Override
    public String toString(MemBuffer buf, int off) throws Exception {
        long val = this.longValue(buf, off);
        if (val >= 0L) {
            return "0x" + Long.toString(val, 16);
        }
        return "-0x" + Long.toString(-val, 16);
    }

    public void linkRelativeOffsets(Hashtable<String, Operand> opHash) {
        this.left.linkRelativeOffsets(opHash);
        this.right.linkRelativeOffsets(opHash);
    }

    @Override
    public Handle getHandle(Position position, int off) throws Exception {
        long val = this.longValue(position.buffer(), off);
        Address a = this.constantSpace.getAddress(val);
        Varnode v = new Varnode(a, this.wordSize);
        return new Handle(v, this.spaceID, this.wordSize);
    }

    @Override
    public Handle getHandle(ArrayList<PcodeOp> pcode, Position position, int off) throws Exception {
        return this.getHandle(position, off);
    }

    @Override
    public void getAllHandles(ArrayList<Handle> handles, Position position, int off) throws Exception {
        handles.add(this.getHandle(position, off));
    }

    @Override
    public void toList(ArrayList<Handle> list, Position position, int off) throws Exception {
        list.add(this.getHandle(position, off));
    }

    @Override
    public int getSize() {
        return this.wordSize * 8;
    }
}

