/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.sleighbase;

import generic.stl.IteratorSTL;
import generic.stl.Pair;
import generic.stl.VectorSTL;
import ghidra.pcodeCPort.context.SleighError;
import ghidra.pcodeCPort.pcoderaw.VarnodeData;
import ghidra.pcodeCPort.sleighbase.NamedSymbolProvider;
import ghidra.pcodeCPort.sleighbase.address_set;
import ghidra.pcodeCPort.slghpatexpress.ContextField;
import ghidra.pcodeCPort.slghsymbol.ContextSymbol;
import ghidra.pcodeCPort.slghsymbol.SleighSymbol;
import ghidra.pcodeCPort.slghsymbol.SubtableSymbol;
import ghidra.pcodeCPort.slghsymbol.SymbolScope;
import ghidra.pcodeCPort.slghsymbol.SymbolTable;
import ghidra.pcodeCPort.slghsymbol.UserOpSymbol;
import ghidra.pcodeCPort.slghsymbol.VarnodeSymbol;
import ghidra.pcodeCPort.slghsymbol.symbol_type;
import ghidra.pcodeCPort.space.AddrSpace;
import ghidra.pcodeCPort.space.spacetype;
import ghidra.pcodeCPort.translate.Translate;
import ghidra.pcodeCPort.utils.XmlUtils;
import java.io.PrintStream;

public abstract class SleighBase
extends Translate
implements NamedSymbolProvider {
    public static final int SLA_FORMAT_VERSION = 2;
    private VectorSTL<String> userop = new VectorSTL();
    private address_set varnode_xref = new address_set();
    protected SubtableSymbol root = null;
    protected SymbolTable symtab = new SymbolTable();
    protected int maxdelayslotbytes = 0;
    protected int unique_allocatemask = 0;
    protected int numSections = 0;

    @Override
    public SleighSymbol findSymbol(String nm) {
        return this.symtab.findSymbol(nm);
    }

    public SleighSymbol findSymbol(int id) {
        return this.symtab.findSymbol(id);
    }

    SleighSymbol findGlobalSymbol(String nm) {
        return this.symtab.findGlobalSymbol(nm);
    }

    public boolean isInitialized() {
        return this.root != null;
    }

    protected void buildXrefs() {
        SymbolScope glb = this.symtab.getGlobalScope();
        int errors = 0;
        glb.begin();
        StringBuffer buffer = new StringBuffer();
        IteratorSTL<SleighSymbol> iter = glb.begin();
        while (!iter.isEnd()) {
            SleighSymbol sym = (SleighSymbol)iter.get();
            if (sym.getType() == symbol_type.varnode_symbol) {
                Pair res = this.varnode_xref.insert((VarnodeSymbol)sym);
                if (!((Boolean)res.second).booleanValue()) {
                    buffer.append("Duplicate (offset,size) pair for registers: ");
                    buffer.append(sym.getName());
                    buffer.append(" (");
                    buffer.append(sym.getLocation());
                    buffer.append(") and ");
                    buffer.append(((VarnodeSymbol)((IteratorSTL)res.first).get()).getName());
                    buffer.append(" (");
                    buffer.append(((VarnodeSymbol)((IteratorSTL)res.first).get()).getLocation());
                    buffer.append(")\n");
                    ++errors;
                }
            } else if (sym.getType() == symbol_type.userop_symbol) {
                int index = ((UserOpSymbol)sym).getIndex();
                while (this.userop.size() <= index) {
                    this.userop.push_back((Object)"");
                }
                this.userop.set(index, (Object)sym.getName());
            } else if (sym.getType() == symbol_type.context_symbol) {
                ContextSymbol csym = (ContextSymbol)sym;
                ContextField field = (ContextField)csym.getPatternValue();
                int startbit = field.getStartBit();
                int endbit = field.getEndBit();
                this.registerContext(csym.getName(), startbit, endbit);
            }
            iter.increment();
        }
        if (errors > 0) {
            throw new SleighError(buffer.toString(), null);
        }
    }

    protected void reregisterContext() {
        SymbolScope glb = this.symtab.getGlobalScope();
        IteratorSTL<SleighSymbol> iter = glb.begin();
        while (!iter.isEnd()) {
            SleighSymbol sym = (SleighSymbol)iter.get();
            if (sym.getType() == symbol_type.context_symbol) {
                ContextSymbol csym = (ContextSymbol)sym;
                ContextField field = (ContextField)csym.getPatternValue();
                int startbit = field.getStartBit();
                int endbit = field.getEndBit();
                this.registerContext(csym.getName(), startbit, endbit);
            }
            iter.increment();
        }
    }

    @Override
    public void addRegister(String nm, AddrSpace base, long offset, int size) {
        VarnodeSymbol sym = new VarnodeSymbol(null, nm, base, offset, size);
        this.symtab.addSymbol(sym);
    }

    @Override
    public VarnodeData getRegister(String nm) {
        VarnodeSymbol sym = (VarnodeSymbol)this.findSymbol(nm);
        if (sym == null) {
            throw new SleighError("Unknown register name: " + nm, null);
        }
        if (sym.getType() != symbol_type.varnode_symbol) {
            throw new SleighError("Symbol is not a register: " + nm, null);
        }
        return sym.getFixedVarnode();
    }

    @Override
    public String getRegisterName(AddrSpace base, long off, int size) {
        VarnodeSymbol sym = new VarnodeSymbol(null, "", base, off, size);
        IteratorSTL iter = this.varnode_xref.upper_bound(sym);
        if (iter.isBegin()) {
            return "";
        }
        iter.decrement();
        VarnodeData point = ((VarnodeSymbol)iter.get()).getFixedVarnode();
        if (!point.space.equals(base)) {
            return "";
        }
        long offbase = point.offset;
        if (point.offset + (long)point.size >= off + (long)size) {
            return ((VarnodeSymbol)iter.get()).getName();
        }
        while (!iter.isBegin()) {
            iter.decrement();
            VarnodeData point2 = ((VarnodeSymbol)iter.get()).getFixedVarnode();
            if (point2.space != base || point2.offset != offbase) {
                return "";
            }
            if (point.offset + (long)point2.size < off + (long)size) continue;
            return ((VarnodeSymbol)iter.get()).getName();
        }
        return "";
    }

    @Override
    public void getUserOpNames(VectorSTL<String> res) {
        res.clear();
        IteratorSTL iter = this.userop.begin();
        while (!iter.isEnd()) {
            res.push_back((Object)((String)iter.get()));
            iter.increment();
        }
    }

    public void saveXml(PrintStream s) {
        s.append("<sleigh");
        XmlUtils.a_v_i(s, "version", 2L);
        XmlUtils.a_v_b(s, "bigendian", this.isBigEndian());
        XmlUtils.a_v_i(s, "align", this.alignment);
        XmlUtils.a_v_u(s, "uniqbase", this.getUniqueBase());
        if (this.maxdelayslotbytes > 0) {
            XmlUtils.a_v_u(s, "maxdelay", this.maxdelayslotbytes);
        }
        if (this.unique_allocatemask != 0) {
            XmlUtils.a_v_u(s, "uniqmask", this.unique_allocatemask);
        }
        if (this.numSections != 0) {
            XmlUtils.a_v_u(s, "numsections", this.numSections);
        }
        s.append(">\n");
        s.append("<spaces");
        XmlUtils.a_v(s, "defaultspace", this.getDefaultSpace().getName());
        s.append(">\n");
        for (int i = 0; i < this.numSpaces(); ++i) {
            AddrSpace spc = this.getSpace(i);
            if (spc.getType() == spacetype.IPTR_CONSTANT || spc.getType() == spacetype.IPTR_FSPEC || spc.getType() == spacetype.IPTR_IOP) continue;
            spc.saveXml(s);
        }
        s.append("</spaces>\n");
        this.symtab.saveXml(s);
        s.append("</sleigh>\n");
    }
}

