/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.block;

import ghidra.program.model.block.SimpleBlockModel;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;

public class BasicBlockModel
extends SimpleBlockModel {
    public static final String NAME = "Basic Block";

    public BasicBlockModel(Program program) {
        super(program);
    }

    public BasicBlockModel(Program program, boolean includeExternals) {
        super(program, includeExternals);
    }

    @Override
    protected boolean hasEndOfBlockFlow(Instruction instr) {
        FlowType flowType = instr.getFlowType();
        if (flowType.isJump() || flowType.isTerminal()) {
            return true;
        }
        for (Reference ref : instr.getReferencesFrom()) {
            RefType refType = ref.getReferenceType();
            if (!refType.isJump() && !refType.isTerminal()) continue;
            return true;
        }
        return false;
    }
}

