/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.app.plugin.core.datamgr.archive.SourceArchive;
import ghidra.docking.settings.Settings;
import ghidra.program.model.data.AlignedStructureInspector;
import ghidra.program.model.data.AlignedStructurePacker;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.CompositeDataTypeImpl;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeComponentImpl;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.Structure;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.Msg;
import ghidra.util.UniversalID;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class StructureDataType
extends CompositeDataTypeImpl
implements Structure {
    private static final long serialVersionUID = 1L;
    private static Comparator<Object> ordinalComparator = new Structure.OrdinalComparator();
    protected static Comparator<Object> offsetComparator = new Structure.OffsetComparator();
    protected static Comparator<Object> bitOffsetComparatorLE = new Structure.BitOffsetComparator(false);
    protected static Comparator<Object> bitOffsetComparatorBE = new Structure.BitOffsetComparator(true);
    protected int structLength;
    protected int numComponents;
    protected List<DataTypeComponentImpl> components;
    private DataTypeComponentImpl flexibleArrayComponent;
    private int alignment = -1;

    public StructureDataType(String name, int length) {
        this(CategoryPath.ROOT, name, length);
    }

    public StructureDataType(String name, int length, DataTypeManager dtm) {
        this(CategoryPath.ROOT, name, length, dtm);
    }

    public StructureDataType(CategoryPath path, String name, int length) {
        this(path, name, length, null);
    }

    public StructureDataType(CategoryPath path, String name, int length, DataTypeManager dtm) {
        super(path, name, dtm);
        if (length < 0) {
            throw new IllegalArgumentException("Length can't be negative");
        }
        this.components = new ArrayList<DataTypeComponentImpl>();
        this.structLength = length;
        this.numComponents = length;
    }

    public StructureDataType(CategoryPath path, String name, int length, UniversalID universalID, SourceArchive sourceArchive, long lastChangeTime, long lastChangeTimeInSourceArchive, DataTypeManager dtm) {
        super(path, name, universalID, sourceArchive, lastChangeTime, lastChangeTimeInSourceArchive, dtm);
        this.components = new ArrayList<DataTypeComponentImpl>();
        this.structLength = length;
        this.numComponents = length;
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        if (this.isNotYetDefined()) {
            return "<Empty-Structure>";
        }
        return "";
    }

    @Override
    public boolean isNotYetDefined() {
        return this.structLength == 0 && this.flexibleArrayComponent == null;
    }

    @Override
    public int getAlignment() {
        if (!this.isInternallyAligned()) {
            return 1;
        }
        if (this.alignment <= 0) {
            AlignedStructurePacker.StructurePackResult packResult = AlignedStructureInspector.packComponents(this);
            this.alignment = packResult.alignment;
        }
        return this.alignment;
    }

    @Override
    public DataTypeComponent getComponentAt(int offset) {
        if (offset >= this.structLength || offset < 0) {
            return null;
        }
        int index = Collections.binarySearch(this.components, offset, offsetComparator);
        if (index >= 0) {
            DataTypeComponent dtc = this.components.get(index);
            if (dtc.isBitFieldComponent()) {
                index = this.backupToFirstComponentContainingOffset(index, offset);
                dtc = this.components.get(index);
            }
            return dtc;
        }
        if (this.isInternallyAligned()) {
            return null;
        }
        index = -index - 1;
        int ordinal = offset;
        if (index > 0) {
            DataTypeComponent dtc = this.components.get(index - 1);
            ordinal = dtc.getOrdinal() + offset - dtc.getEndOffset();
        }
        return new DataTypeComponentImpl(DataType.DEFAULT, this, 1, ordinal, offset);
    }

    @Override
    public DataTypeComponent getDataTypeAt(int offset) {
        DataType dt;
        DataTypeComponent dtc = this.getComponentAt(offset);
        if (dtc != null && (dt = dtc.getDataType()) instanceof Structure) {
            return ((Structure)dt).getDataTypeAt(offset - dtc.getOffset());
        }
        return dtc;
    }

    @Override
    public int getLength() {
        if (this.structLength == 0) {
            return 1;
        }
        return this.structLength;
    }

    @Override
    public void delete(int ordinal) {
        if (ordinal < 0 || ordinal >= this.numComponents) {
            throw new ArrayIndexOutOfBoundsException(ordinal);
        }
        int idx = this.isInternallyAligned() ? ordinal : Collections.binarySearch(this.components, ordinal, ordinalComparator);
        if (idx >= 0) {
            this.doDelete(idx);
            this.adjustInternalAlignment();
        } else {
            idx = -idx - 1;
            this.shiftOffsets(idx, -1, -1);
        }
        this.notifySizeChanged();
    }

    private void doDelete(int index) {
        DataTypeComponentImpl dtc = this.components.remove(index);
        dtc.getDataType().removeParent(this);
        if (this.isInternallyAligned()) {
            return;
        }
        int shiftAmount = dtc.isBitFieldComponent() ? 0 : dtc.getLength();
        this.shiftOffsets(index, -1, -shiftAmount);
    }

    @Override
    public void delete(int[] ordinals) {
        for (int ordinal : ordinals) {
            if (ordinal >= 0 && ordinal < this.numComponents) continue;
            throw new ArrayIndexOutOfBoundsException(ordinal);
        }
        int[] sortedOrdinals = (int[])ordinals.clone();
        Arrays.sort(sortedOrdinals);
        for (int i = sortedOrdinals.length - 1; i >= 0; --i) {
            int ordinal = sortedOrdinals[i];
            int idx = this.isInternallyAligned() ? ordinal : Collections.binarySearch(this.components, ordinal, ordinalComparator);
            if (idx >= 0) {
                this.doDelete(idx);
                continue;
            }
            idx = -idx - 1;
            this.shiftOffsets(idx, -1, -1);
        }
        this.adjustInternalAlignment();
        this.notifySizeChanged();
    }

    private void shiftOffsets(int index, int deltaOrdinal, int deltaOffset) {
        for (int i = index; i < this.components.size(); ++i) {
            DataTypeComponentImpl dtc = this.components.get(i);
            this.shiftOffset(dtc, deltaOrdinal, deltaOffset);
        }
        this.structLength += deltaOffset;
        this.numComponents += deltaOrdinal;
    }

    protected void shiftOffset(DataTypeComponentImpl dtc, int deltaOrdinal, int deltaOffset) {
        dtc.setOffset(dtc.getOffset() + deltaOffset);
        dtc.setOrdinal(dtc.getOrdinal() + deltaOrdinal);
    }

    @Override
    public DataTypeComponent getComponent(int index) {
        if (index == this.numComponents && this.flexibleArrayComponent != null) {
            return this.flexibleArrayComponent;
        }
        if (index < 0 || index >= this.numComponents) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int idx = Collections.binarySearch(this.components, index, ordinalComparator);
        if (idx >= 0) {
            return this.components.get(idx);
        }
        int offset = 0;
        if ((idx = -idx - 1) == 0) {
            offset = index;
        } else {
            DataTypeComponent dtc = this.components.get(idx - 1);
            offset = dtc.getEndOffset() + index - dtc.getOrdinal();
        }
        return new DataTypeComponentImpl(DataType.DEFAULT, this, 1, index, offset);
    }

    @Override
    public int getNumComponents() {
        return this.numComponents;
    }

    @Override
    public int getNumDefinedComponents() {
        return this.components.size();
    }

    @Override
    public final DataTypeComponentImpl insertAtOffset(int offset, DataType dataType, int length) {
        return this.insertAtOffset(offset, dataType, length, null, null);
    }

    @Override
    public DataTypeComponentImpl insertAtOffset(int offset, DataType dataType, int length, String componentName, String comment) {
        DataTypeComponent dtc;
        if (offset < 0) {
            throw new IllegalArgumentException("Offset cannot be negative.");
        }
        if (dataType instanceof BitFieldDataType) {
            BitFieldDataType bfDt = (BitFieldDataType)dataType;
            if (length <= 0) {
                length = dataType.getLength();
            }
            try {
                return this.insertBitFieldAt(offset, length, bfDt.getBitOffset(), bfDt.getBaseDataType(), bfDt.getDeclaredBitSize(), componentName, comment);
            }
            catch (InvalidDataTypeException e) {
                throw new AssertException((Throwable)((Object)e));
            }
        }
        this.validateDataType(dataType);
        dataType = dataType.clone(this.dataMgr);
        this.checkAncestry(dataType);
        if (offset > this.structLength && !this.isInternallyAligned()) {
            this.numComponents += offset - this.structLength;
            this.structLength = offset;
        }
        int index = Collections.binarySearch(this.components, offset, offsetComparator);
        int additionalShift = 0;
        if (index >= 0) {
            index = this.backupToFirstComponentContainingOffset(index, offset);
            DataTypeComponent dtc2 = this.components.get(index);
            additionalShift = offset - dtc2.getOffset();
        } else {
            index = -index - 1;
        }
        int ordinal = offset;
        if (index > 0) {
            dtc = this.components.get(index - 1);
            ordinal = dtc.getOrdinal() + offset - dtc.getEndOffset();
        }
        if (dataType == DataType.DEFAULT) {
            this.shiftOffsets(index, 1 + additionalShift, 1 + additionalShift);
            return new DataTypeComponentImpl(DataType.DEFAULT, this, 1, ordinal, offset);
        }
        length = this.getPreferredComponentLength(dataType, length);
        dtc = new DataTypeComponentImpl(dataType, this, length, ordinal, offset, componentName, comment);
        dataType.addParent(this);
        this.shiftOffsets(index, 1 + additionalShift, ((DataTypeComponentImpl)dtc).getLength() + additionalShift);
        this.components.add(index, (DataTypeComponentImpl)dtc);
        this.adjustInternalAlignment();
        this.notifySizeChanged();
        return dtc;
    }

    @Override
    public DataTypeComponent add(DataType dataType, int length, String componentName, String comment) {
        return this.doAdd(dataType, length, false, componentName, comment);
    }

    private DataTypeComponent doAdd(DataType dataType, int length, boolean isFlexibleArray, String componentName, String comment) {
        DataTypeComponentImpl dtc;
        this.validateDataType(dataType);
        dataType = dataType.clone(this.dataMgr);
        this.checkAncestry(dataType);
        if (dataType == DataType.DEFAULT) {
            dtc = new DataTypeComponentImpl(DataType.DEFAULT, this, 1, this.numComponents, this.structLength);
        } else {
            int componentLength;
            int offset = this.structLength;
            int ordinal = this.numComponents;
            if (isFlexibleArray) {
                offset = -1;
                ordinal = -1;
                this.clearFlexibleArrayComponent();
                componentLength = 0;
            } else {
                componentLength = this.getPreferredComponentLength(dataType, length);
            }
            dtc = new DataTypeComponentImpl(dataType, this, componentLength, ordinal, offset, componentName, comment);
            dataType.addParent(this);
            if (isFlexibleArray) {
                this.flexibleArrayComponent = dtc;
            } else {
                this.components.add(dtc);
            }
        }
        if (!isFlexibleArray) {
            int structureGrowth = dtc.getLength();
            if (!this.isInternallyAligned() && length > 0) {
                structureGrowth = length;
            }
            ++this.numComponents;
            this.structLength += structureGrowth;
        }
        this.adjustInternalAlignment();
        this.notifySizeChanged();
        return dtc;
    }

    @Override
    public void growStructure(int amount) {
        this.numComponents += amount;
        this.structLength += amount;
        this.adjustInternalAlignment();
        this.notifySizeChanged();
    }

    @Override
    public DataTypeComponent insert(int index, DataType dataType, int length, String componentName, String comment) {
        int idx;
        if (index < 0 || index > this.numComponents) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (index == this.numComponents) {
            return this.add(dataType, length, componentName, comment);
        }
        this.validateDataType(dataType);
        dataType = dataType.clone(this.dataMgr);
        this.checkAncestry(dataType);
        if (this.isInternallyAligned()) {
            idx = index;
        } else {
            DataTypeComponentImpl previousDtc;
            DataTypeComponentImpl existingDtc;
            idx = Collections.binarySearch(this.components, index, ordinalComparator);
            if (idx > 0 && (existingDtc = this.components.get(idx)).isBitFieldComponent() && (previousDtc = this.components.get(idx - 1)).getEndOffset() == existingDtc.getOffset()) {
                this.shiftOffsets(idx, 0, 1);
            }
        }
        if (idx < 0) {
            idx = -idx - 1;
        }
        if (dataType == DataType.DEFAULT) {
            this.shiftOffsets(idx, 1, 1);
            return this.getComponent(index);
        }
        length = this.getPreferredComponentLength(dataType, length);
        int offset = this.getComponent(index).getOffset();
        DataTypeComponentImpl dtc = new DataTypeComponentImpl(dataType, this, length, index, offset, componentName, comment);
        dataType.addParent(this);
        this.shiftOffsets(idx, 1, dtc.getLength());
        this.components.add(idx, dtc);
        this.adjustInternalAlignment();
        this.notifySizeChanged();
        return dtc;
    }

    @Override
    public DataTypeComponent addBitField(DataType baseDataType, int bitSize, String componentName, String comment) throws InvalidDataTypeException {
        BitFieldDataType.checkBaseDataType(baseDataType);
        baseDataType = baseDataType.clone(this.dataMgr);
        BitFieldDataType bitFieldDt = new BitFieldDataType(baseDataType, bitSize);
        return this.add(bitFieldDt, bitFieldDt.getStorageSize(), componentName, comment);
    }

    @Override
    public DataTypeComponent insertBitField(int ordinal, int byteWidth, int bitOffset, DataType baseDataType, int bitSize, String componentName, String comment) throws InvalidDataTypeException, ArrayIndexOutOfBoundsException {
        if (ordinal < 0 || ordinal > this.numComponents) {
            throw new ArrayIndexOutOfBoundsException(ordinal);
        }
        BitFieldDataType.checkBaseDataType(baseDataType);
        baseDataType = baseDataType.clone(this.dataMgr);
        if (!this.isInternallyAligned()) {
            int offset = this.structLength;
            if (ordinal < this.numComponents) {
                offset = this.getComponent(ordinal).getOffset();
            }
            return this.insertBitFieldAt(offset, byteWidth, bitOffset, baseDataType, bitSize, componentName, comment);
        }
        BitFieldDataType bitFieldDt = new BitFieldDataType(baseDataType, bitSize);
        return this.insert(ordinal, bitFieldDt, bitFieldDt.getStorageSize(), componentName, comment);
    }

    @Override
    public DataTypeComponentImpl insertBitFieldAt(int byteOffset, int byteWidth, int bitOffset, DataType baseDataType, int bitSize, String componentName, String comment) throws InvalidDataTypeException {
        int requiredLength;
        int ordinal;
        if (byteOffset < 0 || bitSize < 0) {
            throw new IllegalArgumentException("Negative values not permitted when defining bitfield");
        }
        if (byteWidth <= 0) {
            throw new IllegalArgumentException("Invalid byteWidth");
        }
        BitFieldDataType.checkBaseDataType(baseDataType);
        baseDataType = baseDataType.clone(this.dataMgr);
        int effectiveBitSize = BitFieldDataType.getEffectiveBitSize(bitSize, baseDataType.getLength());
        int minByteWidth = BitFieldDataType.getMinimumStorageSize(effectiveBitSize + bitOffset);
        if (byteWidth < minByteWidth) {
            throw new IllegalArgumentException("Bitfield does not fit within specified constraints");
        }
        boolean bigEndian = this.getDataOrganization().isBigEndian();
        boolean hasConflict = false;
        int additionalShift = 0;
        int startBitOffset = Structure.BitOffsetComparator.getNormalizedBitfieldOffset(byteOffset, byteWidth, effectiveBitSize, bitOffset, bigEndian);
        Comparator<Object> bitOffsetComparator = bigEndian ? bitOffsetComparatorBE : bitOffsetComparatorLE;
        int startIndex = Collections.binarySearch(this.components, startBitOffset, bitOffsetComparator);
        if (startIndex < 0) {
            startIndex = -startIndex - 1;
        } else {
            hasConflict = true;
            DataTypeComponentImpl dtc = this.components.get(startIndex);
            if (bitSize == 0 || dtc.isZeroBitFieldComponent()) {
                boolean bl = hasConflict = dtc.getOffset() != startBitOffset / 8;
            }
            if (hasConflict) {
                additionalShift = byteOffset - dtc.getOffset();
            }
        }
        if (startIndex < this.components.size()) {
            DataTypeComponentImpl dtc = this.components.get(startIndex);
            ordinal = dtc.getOrdinal();
        } else {
            ordinal = startIndex;
        }
        if (this.isInternallyAligned()) {
            this.insertBitField(ordinal, 0, 0, baseDataType, effectiveBitSize, componentName, comment);
        }
        int endIndex = startIndex;
        if (startIndex < this.components.size()) {
            int endBitOffset = startBitOffset;
            if (effectiveBitSize != 0) {
                endBitOffset += effectiveBitSize - 1;
            }
            if ((endIndex = Collections.binarySearch(this.components, endBitOffset, bitOffsetComparator)) < 0) {
                endIndex = -endIndex - 1;
            } else if (effectiveBitSize != 0) {
                hasConflict = true;
            }
        }
        if (startIndex != endIndex) {
            hasConflict = true;
        }
        if (hasConflict) {
            this.shiftOffsets(startIndex, 1, byteWidth + additionalShift);
        }
        if ((requiredLength = byteOffset + byteWidth) > this.structLength) {
            this.structLength = requiredLength;
        }
        int storageBitOffset = bitOffset % 8;
        int revisedOffset = bigEndian ? byteOffset + byteWidth - (effectiveBitSize + bitOffset + 7) / 8 : byteOffset + bitOffset / 8;
        BitFieldDataType bitfieldDt = new BitFieldDataType(baseDataType, bitSize, storageBitOffset);
        DataTypeComponentImpl dtc = new DataTypeComponentImpl(bitfieldDt, this, bitfieldDt.getStorageSize(), ordinal, revisedOffset, componentName, comment);
        bitfieldDt.addParent(this);
        this.components.add(startIndex, dtc);
        this.adjustUnalignedComponents();
        this.notifySizeChanged();
        return dtc;
    }

    private int backupToFirstComponentContainingOffset(int index, int offset) {
        DataTypeComponentImpl previous;
        if (index == 0) {
            return 0;
        }
        DataTypeComponentImpl dtc = this.components.get(index);
        while (index != 0 && dtc.isBitFieldComponent() && (previous = this.components.get(index - 1)).containsOffset(offset)) {
            dtc = previous;
            --index;
        }
        return index;
    }

    private int advanceToLastComponentContainingOffset(int index, int offset) {
        DataTypeComponentImpl next;
        DataTypeComponentImpl dtc = this.components.get(index);
        while (index < this.components.size() - 1 && dtc.isBitFieldComponent() && (next = this.components.get(index + 1)).containsOffset(offset)) {
            dtc = next;
            ++index;
        }
        return index;
    }

    @Override
    public void deleteAtOffset(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException("Offset cannot be negative.");
        }
        if (offset >= this.structLength) {
            return;
        }
        int index = Collections.binarySearch(this.components, offset, offsetComparator);
        int offsetDelta = 0;
        int ordinalDelta = 0;
        if (index < 0) {
            index = -index - 1;
            offsetDelta = -1;
            this.shiftOffsets(index, --ordinalDelta, offsetDelta);
        } else {
            index = this.advanceToLastComponentContainingOffset(index, offset);
            DataTypeComponentImpl dtc = this.components.get(index);
            while (dtc.containsOffset(offset)) {
                this.doDelete(index);
                if (--index < 0) break;
                dtc = this.components.get(index);
            }
        }
        this.adjustInternalAlignment();
        this.notifySizeChanged();
    }

    @Override
    public boolean isEquivalent(DataType dataType) {
        if (dataType == this) {
            return true;
        }
        if (dataType == null) {
            return false;
        }
        if (dataType instanceof Structure) {
            int otherNumComps;
            Structure struct = (Structure)dataType;
            if (this.isInternallyAligned() != struct.isInternallyAligned() || this.isDefaultAligned() != struct.isDefaultAligned() || this.isMachineAligned() != struct.isMachineAligned() || this.getMinimumAlignment() != struct.getMinimumAlignment() || this.getPackingValue() != struct.getPackingValue() || !this.isInternallyAligned() && this.getLength() != struct.getLength()) {
                return false;
            }
            DataTypeComponent myFlexComp = this.getFlexibleArrayComponent();
            DataTypeComponent otherFlexComp = struct.getFlexibleArrayComponent();
            if (myFlexComp != null ? otherFlexComp == null || !myFlexComp.isEquivalent(otherFlexComp) : otherFlexComp != null) {
                return false;
            }
            int myNumComps = this.getNumComponents();
            if (myNumComps != (otherNumComps = struct.getNumComponents())) {
                return false;
            }
            for (int i = 0; i < myNumComps; ++i) {
                DataTypeComponent otherDtc;
                DataTypeComponent myDtc = this.getComponent(i);
                if (myDtc.isEquivalent(otherDtc = struct.getComponent(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void dataTypeSizeChanged(DataType dt) {
        if (this.isInternallyAligned()) {
            this.adjustInternalAlignment();
            return;
        }
        boolean didChange = false;
        int n = this.components.size();
        for (int i = 0; i < n; ++i) {
            int consumed;
            int dtcLen;
            DataTypeComponentImpl dtc = this.components.get(i);
            int nextIndex = i + 1;
            if (dtc.getDataType() != dt) continue;
            int dtLen = dt.getLength();
            if (dtLen < (dtcLen = dtc.getLength())) {
                dtc.setLength(dtLen);
                this.shiftOffsets(nextIndex, dtcLen - dtLen, 0);
                didChange = true;
                continue;
            }
            if (dtLen <= dtcLen || (consumed = this.consumeBytesAfter(i, dtLen - dtcLen)) <= 0) continue;
            this.shiftOffsets(nextIndex, 0 - consumed, 0);
            didChange = true;
        }
        if (didChange) {
            this.adjustInternalAlignment();
            this.notifySizeChanged();
        }
    }

    @Override
    public void dataTypeAlignmentChanged(DataType dt) {
        if (this.isInternallyAligned()) {
            this.adjustInternalAlignment();
        }
    }

    private int consumeBytesAfter(int definedComponentIndex, int numBytes) {
        int available;
        DataTypeComponentImpl thisDtc = this.components.get(definedComponentIndex);
        int thisLen = thisDtc.getLength();
        int nextOffset = thisDtc.getOffset() + thisLen;
        if (definedComponentIndex == this.components.size() - 1) {
            available = this.structLength - nextOffset;
            if (numBytes > available) {
                this.doGrowStructure(numBytes - available);
                available = numBytes;
            }
        } else {
            DataTypeComponent nextDtc = this.components.get(definedComponentIndex + 1);
            available = nextDtc.getOffset() - nextOffset;
        }
        if (numBytes <= available) {
            thisDtc.setLength(thisLen + numBytes);
            return numBytes;
        }
        thisDtc.setLength(thisLen + available);
        return available;
    }

    @Override
    public DataType copy(DataTypeManager dtm) {
        StructureDataType struct = new StructureDataType(this.categoryPath, this.getName(), this.getLength(), dtm);
        struct.setDescription(this.getDescription());
        struct.replaceWith(this);
        return struct;
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (this.dataMgr == dtm) {
            return this;
        }
        StructureDataType struct = new StructureDataType(this.categoryPath, this.getName(), this.getLength(), this.getUniversalID(), this.getSourceArchive(), this.getLastChangeTime(), this.getLastChangeTimeInSourceArchive(), dtm);
        struct.setDescription(this.getDescription());
        struct.replaceWith(this);
        return struct;
    }

    @Override
    public void clearComponent(int index) {
        if (index < 0 || index >= this.numComponents) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int idx = Collections.binarySearch(this.components, index, ordinalComparator);
        if (idx >= 0) {
            DataTypeComponent dtc = this.components.remove(idx);
            dtc.getDataType().removeParent(this);
            int len = dtc.getLength();
            if (len > 1) {
                this.shiftOffsets(idx, len - 1, 0);
            }
        }
        this.adjustInternalAlignment();
    }

    @Override
    public void replaceWith(DataType dataType) {
        if (!(dataType instanceof Structure)) {
            throw new IllegalArgumentException();
        }
        Structure struct = (Structure)dataType;
        int oldLength = this.structLength;
        this.components.clear();
        this.structLength = 0;
        this.numComponents = 0;
        this.flexibleArrayComponent = null;
        this.setAlignment(struct);
        if (struct.isInternallyAligned()) {
            this.doReplaceWithAligned(struct);
        } else {
            this.doReplaceWithUnaligned(struct);
        }
        DataTypeComponent flexComponent = struct.getFlexibleArrayComponent();
        if (flexComponent != null) {
            this.setFlexibleArrayComponent(flexComponent.getDataType(), flexComponent.getFieldName(), flexComponent.getComment());
        }
        if (oldLength != this.structLength) {
            this.notifySizeChanged();
        }
    }

    private void doReplaceWithAligned(Structure struct) {
        DataTypeComponent[] otherComponents = struct.getDefinedComponents();
        for (int i = 0; i < otherComponents.length; ++i) {
            DataTypeComponent dtc = otherComponents[i];
            DataType dt = dtc.getDataType();
            int length = dt instanceof Dynamic ? dtc.getLength() : -1;
            this.add(dt, length, dtc.getFieldName(), dtc.getComment());
        }
    }

    private void doReplaceWithUnaligned(Structure struct) {
        if (struct.isNotYetDefined()) {
            return;
        }
        this.numComponents = this.structLength = struct.getLength();
        DataTypeComponent[] otherComponents = struct.getDefinedComponents();
        for (int i = 0; i < otherComponents.length; ++i) {
            DataTypeComponent dtc = otherComponents[i];
            DataType dt = dtc.getDataType().clone(this.dataMgr);
            this.checkAncestry(dt);
            int length = this.getPreferredComponentLength(dt, dtc.getLength());
            this.components.add(new DataTypeComponentImpl(dt, this, length, dtc.getOrdinal(), dtc.getOffset(), dtc.getFieldName(), dtc.getComment()));
        }
        this.adjustComponents();
    }

    @Override
    public void dataTypeDeleted(DataType dt) {
        boolean didChange = false;
        if (this.flexibleArrayComponent != null && this.flexibleArrayComponent.getDataType() == dt) {
            this.flexibleArrayComponent.getDataType().removeParent(this);
            this.flexibleArrayComponent = null;
            didChange = true;
        }
        int n = this.components.size();
        for (int i = n - 1; i >= 0; --i) {
            DataTypeComponentImpl dtc = this.components.get(i);
            boolean removeBitFieldComponent = false;
            if (dtc.isBitFieldComponent()) {
                BitFieldDataType bitfieldDt = (BitFieldDataType)dtc.getDataType();
                boolean bl = removeBitFieldComponent = bitfieldDt.getBaseDataType() == dt;
            }
            if (!removeBitFieldComponent && dtc.getDataType() != dt) continue;
            dt.removeParent(this);
            this.components.remove(i);
            this.shiftOffsets(i, dtc.getLength() - 1, 0);
            didChange = true;
        }
        if (didChange) {
            this.adjustInternalAlignment();
            this.notifySizeChanged();
        }
    }

    @Override
    public void dataTypeReplaced(DataType oldDt, DataType replacementDt) {
        DataType newDt = replacementDt;
        try {
            this.validateDataType(replacementDt);
            if (replacementDt.getDataTypeManager() != this.dataMgr) {
                replacementDt = replacementDt.clone(this.dataMgr);
            }
            this.checkAncestry(replacementDt);
        }
        catch (Exception e) {
            replacementDt = DataType.DEFAULT;
        }
        boolean changed = false;
        if (this.flexibleArrayComponent != null && this.flexibleArrayComponent.getDataType() == oldDt) {
            this.flexibleArrayComponent.getDataType().removeParent(this);
            if (this.isInvalidFlexArrayDataType(replacementDt)) {
                this.flexibleArrayComponent = null;
                Msg.error((Object)this, (Object)("Invalid flex array replacement type " + newDt.getName() + ", removing flex array: " + this.getPathName()));
            } else {
                this.flexibleArrayComponent.setDataType(replacementDt);
                replacementDt.addParent(this);
            }
            changed = true;
        }
        for (int i = this.components.size() - 1; i >= 0; --i) {
            DataTypeComponentImpl comp = this.components.get(i);
            int nextIndex = i + 1;
            boolean remove = false;
            if (comp.isBitFieldComponent()) {
                try {
                    changed |= this.updateBitFieldDataType(comp, oldDt, replacementDt);
                }
                catch (InvalidDataTypeException e) {
                    Msg.error((Object)this, (Object)("Invalid bitfield replacement type " + newDt.getName() + ", removing bitfield " + comp.getDataType().getName() + ": " + this.getPathName()));
                    remove = true;
                }
            } else if (comp.getDataType() == oldDt) {
                if (replacementDt == DEFAULT && this.isInternallyAligned()) {
                    Msg.error((Object)this, (Object)("Invalid replacement type " + newDt.getName() + ", removing component " + comp.getDataType().getName() + ": " + this.getPathName()));
                    remove = true;
                } else {
                    this.setComponentDataType(comp, replacementDt, nextIndex);
                    changed = true;
                }
            }
            if (!remove) continue;
            oldDt.removeParent(this);
            this.components.remove(i);
            this.shiftOffsets(i, comp.getLength() - 1, 0);
            changed = true;
        }
        if (changed) {
            this.adjustInternalAlignment();
            this.notifySizeChanged();
        }
    }

    private void setComponentDataType(DataTypeComponentImpl comp, DataType newDt, int nextIndex) {
        comp.getDataType().removeParent(this);
        comp.setDataType(newDt);
        newDt.addParent(this);
        int len = newDt.getLength();
        int oldLen = comp.getLength();
        if (len > 0) {
            if (len < oldLen) {
                comp.setLength(len);
                this.shiftOffsets(nextIndex, oldLen - len, 0);
            } else if (len > oldLen) {
                int bytesNeeded = len - oldLen;
                int bytesAvailable = this.getNumUndefinedBytes(comp.getOrdinal() + 1);
                if (bytesNeeded <= bytesAvailable) {
                    comp.setLength(len);
                    this.shiftOffsets(nextIndex, -bytesNeeded, 0);
                } else if (comp.getOrdinal() == this.getLastDefinedComponentIndex()) {
                    this.doGrowStructure(bytesNeeded - bytesAvailable);
                    comp.setLength(len);
                    this.shiftOffsets(nextIndex, -bytesNeeded, 0);
                } else {
                    comp.setLength(oldLen + bytesAvailable);
                    this.shiftOffsets(nextIndex, -bytesAvailable, 0);
                }
            }
        }
    }

    @Override
    public DataTypeComponent[] getDefinedComponents() {
        return this.components.toArray(new DataTypeComponent[this.components.size()]);
    }

    @Override
    public DataTypeComponent[] getComponents() {
        DataTypeComponent[] comps = new DataTypeComponent[this.numComponents];
        for (int i = 0; i < comps.length; ++i) {
            comps[i] = this.getComponent(i);
        }
        return comps;
    }

    @Override
    public DataTypeComponent replace(int index, DataType dataType, int length, String componentName, String comment) {
        if (index < 0 || index >= this.numComponents) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.validateDataType(dataType);
        DataTypeComponentImpl origDtc = (DataTypeComponentImpl)this.getComponent(index);
        if (origDtc.isBitFieldComponent()) {
            throw new IllegalArgumentException("Bit-field component may not be directly replaced");
        }
        if (dataType == DataType.DEFAULT) {
            this.clearComponent(index);
            return this.getComponent(index);
        }
        dataType = dataType.clone(this.dataMgr);
        this.checkAncestry(dataType);
        length = this.getPreferredComponentLength(dataType, length);
        DataTypeComponent replacement = this.replaceComponent(origDtc, dataType, length, componentName, comment);
        this.adjustInternalAlignment();
        return replacement;
    }

    @Override
    public final DataTypeComponent replace(int index, DataType dataType, int length) {
        return this.replace(index, dataType, length, null, null);
    }

    @Override
    public DataTypeComponent replaceAtOffset(int offset, DataType dataType, int length, String componentName, String comment) {
        if (offset < 0) {
            throw new IllegalArgumentException("Offset cannot be negative.");
        }
        if (offset >= this.structLength) {
            throw new IllegalArgumentException("Offset " + offset + " is beyond end of structure (" + this.structLength + ").");
        }
        this.validateDataType(dataType);
        DataTypeComponentImpl origDtc = (DataTypeComponentImpl)this.getComponentAt(offset);
        if (origDtc.isBitFieldComponent()) {
            throw new IllegalArgumentException("Bit-field component may not be directly replaced");
        }
        if (dataType == DataType.DEFAULT) {
            int ordinal = origDtc.getOrdinal();
            this.clearComponent(ordinal);
            return this.getComponent(ordinal);
        }
        dataType = dataType.clone(this.dataMgr);
        this.checkAncestry(dataType);
        length = this.getPreferredComponentLength(dataType, length);
        DataTypeComponent replacement = this.replaceComponent(origDtc, dataType, length, componentName, comment);
        this.adjustInternalAlignment();
        return replacement;
    }

    private DataTypeComponent replaceComponent(DataTypeComponentImpl origDtc, DataType dataType, int length, String componentName, String comment) {
        int index;
        int bytesAvailable;
        int ordinal = origDtc.getOrdinal();
        int newOffset = origDtc.getOffset();
        int dtcLength = origDtc.getLength();
        DataTypeComponentImpl newDtc = new DataTypeComponentImpl(dataType, this, length, ordinal, newOffset, componentName, comment);
        int bytesNeeded = length - dtcLength;
        int deltaOrdinal = -bytesNeeded;
        if (bytesNeeded > 0 && (bytesAvailable = this.getNumUndefinedBytes(ordinal + 1)) < bytesNeeded) {
            if (ordinal == this.getLastDefinedComponentIndex()) {
                this.growStructure(bytesNeeded - bytesAvailable);
            } else {
                throw new IllegalArgumentException("Not enough undefined bytes to fit " + dataType.getPathName() + " in structure " + this.getPathName() + " at offset 0x" + Integer.toHexString(newOffset) + ". It needs " + (bytesNeeded - bytesAvailable) + " more byte(s) to be able to fit.");
            }
        }
        if ((index = Collections.binarySearch(this.components, ordinal, ordinalComparator)) < 0) {
            index = -index - 1;
        } else {
            this.components.remove(index);
            origDtc.getDataType().removeParent(this);
        }
        this.components.add(index, newDtc);
        dataType.addParent(this);
        if (deltaOrdinal != 0) {
            this.shiftOffsets(index + 1, deltaOrdinal, 0);
        }
        return newDtc;
    }

    private int getLastDefinedComponentIndex() {
        if (this.components.size() == 0) {
            return 0;
        }
        DataTypeComponent dataTypeComponent = this.components.get(this.components.size() - 1);
        return dataTypeComponent.getOrdinal();
    }

    protected int getNumUndefinedBytes(int index) {
        if (index >= this.numComponents) {
            return 0;
        }
        int idx = Collections.binarySearch(this.components, index, ordinalComparator);
        DataTypeComponent dtc = null;
        if (idx < 0) {
            if ((idx = -idx - 1) >= this.components.size()) {
                return this.numComponents - index;
            }
            dtc = this.components.get(idx);
            return dtc.getOrdinal() - index;
        }
        return 0;
    }

    @Override
    public void dataTypeNameChanged(DataType dt, String oldName) {
    }

    @Override
    public boolean dependsOn(DataType dt) {
        return false;
    }

    @Override
    public void deleteAll() {
        for (int i = 0; i < this.components.size(); ++i) {
            DataTypeComponent dtc = this.components.get(i);
            dtc.getDataType().removeParent(this);
        }
        this.components.clear();
        this.structLength = 0;
        this.numComponents = 0;
        this.flexibleArrayComponent = null;
        this.adjustInternalAlignment();
        this.notifySizeChanged();
    }

    @Override
    public String getDefaultLabelPrefix() {
        return this.getName();
    }

    @Override
    public void realign() {
        this.adjustInternalAlignment();
    }

    @Override
    public void pack(int packingSize) throws InvalidInputException {
        this.setPackingValue(packingSize);
    }

    protected boolean adjustComponents() {
        int oldLength = this.structLength;
        boolean changed = false;
        this.alignment = -1;
        if (!this.isInternallyAligned()) {
            if ((changed |= this.adjustUnalignedComponents()) && oldLength != this.structLength) {
                this.notifySizeChanged();
            }
            return changed;
        }
        AlignedStructurePacker.StructurePackResult packResult = AlignedStructurePacker.packComponents(this, this.components);
        changed = packResult.componentsChanged;
        if (changed |= this.updateComposite(packResult.numComponents, packResult.structureLength, packResult.alignment)) {
            if (oldLength != this.structLength) {
                this.notifySizeChanged();
            }
            return true;
        }
        return false;
    }

    private boolean adjustUnalignedComponents() {
        boolean changed = false;
        int componentCount = 0;
        int currentOffset = 0;
        for (DataTypeComponentImpl dataTypeComponent : this.components) {
            int componentLength = dataTypeComponent.getLength();
            int componentOffset = dataTypeComponent.getOffset();
            int numUndefinedsBefore = componentOffset - currentOffset;
            if (numUndefinedsBefore > 0) {
                componentCount += numUndefinedsBefore;
            }
            currentOffset = componentOffset + componentLength;
            if (dataTypeComponent.getOrdinal() != componentCount) {
                dataTypeComponent.setOrdinal(componentCount);
                changed = true;
            }
            ++componentCount;
        }
        int numUndefinedsAfter = this.structLength - currentOffset;
        if (this.updateComposite(componentCount += numUndefinedsAfter, this.structLength, 1)) {
            changed = true;
        }
        return changed;
    }

    private boolean updateComposite(int currentNumComponents, int currentLength, int currentAlignment) {
        boolean compositeChanged = false;
        if (this.numComponents != currentNumComponents) {
            this.numComponents = currentNumComponents;
            compositeChanged = true;
        }
        if (this.structLength != currentLength) {
            this.structLength = currentLength;
            compositeChanged = true;
        }
        if (this.alignment != currentAlignment) {
            this.alignment = currentAlignment;
            compositeChanged = true;
        }
        return compositeChanged;
    }

    private void doGrowStructure(int amount) {
        if (!this.isInternallyAligned()) {
            this.numComponents += amount;
        }
        this.structLength += amount;
    }

    @Override
    public void adjustInternalAlignment() {
        this.adjustComponents();
    }

    @Override
    public boolean hasFlexibleArrayComponent() {
        return this.flexibleArrayComponent != null;
    }

    @Override
    public DataTypeComponent getFlexibleArrayComponent() {
        return this.flexibleArrayComponent;
    }

    private boolean isInvalidFlexArrayDataType(DataType dataType) {
        return dataType == null || dataType == DataType.DEFAULT || dataType instanceof BitFieldDataType || dataType instanceof Dynamic || dataType instanceof FactoryDataType;
    }

    @Override
    public DataTypeComponent setFlexibleArrayComponent(DataType flexType, String name, String comment) {
        if (this.isInvalidFlexArrayDataType(flexType)) {
            throw new IllegalArgumentException("Unsupported flexType: " + flexType.getDisplayName());
        }
        return this.doAdd(flexType, 0, true, name, comment);
    }

    @Override
    public void clearFlexibleArrayComponent() {
        if (this.flexibleArrayComponent == null) {
            return;
        }
        this.flexibleArrayComponent = null;
        this.adjustInternalAlignment();
        this.notifySizeChanged();
    }

    @Override
    protected void dumpComponents(StringBuilder buffer, String pad) {
        super.dumpComponents(buffer, pad);
        DataTypeComponent dtc = this.getFlexibleArrayComponent();
        if (dtc != null) {
            DataType dataType = dtc.getDataType();
            buffer.append(pad + dataType.getDisplayName() + "[0]");
            buffer.append(pad + dtc.getLength());
            buffer.append(pad + dtc.getFieldName());
            String comment = dtc.getComment();
            if (comment == null) {
                comment = "";
            }
            buffer.append(pad + "\"" + comment + "\"");
            buffer.append("\n");
        }
    }
}

