/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.program.model.lang.IncompatibleMaskException;
import ghidra.program.model.lang.Mask;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import java.io.Serializable;

public class MaskImpl
implements Mask,
Serializable {
    private static final long serialVersionUID = 1L;
    private byte[] mask;

    public MaskImpl(byte[] msk) {
        if (msk == null) {
            throw new IllegalArgumentException();
        }
        this.mask = new byte[msk.length];
        System.arraycopy(msk, 0, this.mask, 0, msk.length);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Mask) {
            return this.equals(((Mask)obj).getBytes());
        }
        return false;
    }

    @Override
    public boolean equals(byte[] otherMask) {
        if (otherMask == null || otherMask.length != this.mask.length) {
            return false;
        }
        for (int i = 0; i < this.mask.length; ++i) {
            if (this.mask[i] == otherMask[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public byte[] applyMask(byte[] cde, byte[] result) throws IncompatibleMaskException {
        int i;
        if (cde == null || result == null) {
            throw new IncompatibleMaskException();
        }
        if (cde.length < this.mask.length || result.length < cde.length) {
            throw new IncompatibleMaskException();
        }
        for (i = 0; i < this.mask.length; ++i) {
            result[i] = (byte)(this.mask[i] & cde[i]);
        }
        for (i = this.mask.length; i < cde.length; ++i) {
            result[i] = cde[i];
        }
        return result;
    }

    @Override
    public void applyMask(byte[] cde, int cdeOffset, byte[] results, int resultsOffset) throws IncompatibleMaskException {
        if (cde == null || results == null) {
            throw new IncompatibleMaskException();
        }
        if (cde.length - cdeOffset < this.mask.length || results.length - resultsOffset < this.mask.length) {
            throw new IncompatibleMaskException();
        }
        for (int i = 0; i < this.mask.length; ++i) {
            results[resultsOffset++] = (byte)(this.mask[i] & cde[cdeOffset++]);
        }
    }

    @Override
    public byte[] applyMask(MemBuffer buffer) throws MemoryAccessException {
        byte[] bytes = new byte[this.mask.length];
        buffer.getBytes(bytes, 0);
        for (int i = 0; i < this.mask.length; ++i) {
            int n = i;
            bytes[n] = (byte)(bytes[n] & this.mask[i]);
        }
        return bytes;
    }

    @Override
    public boolean equalMaskedValue(byte[] cde, byte[] target) throws IncompatibleMaskException {
        if (cde == null || target == null) {
            throw new IncompatibleMaskException();
        }
        if (cde.length < this.mask.length || target.length < this.mask.length) {
            throw new IncompatibleMaskException();
        }
        for (int i = 0; i < this.mask.length; ++i) {
            if (target[i] == (byte)(this.mask[i] & cde[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean subMask(byte[] msk) throws IncompatibleMaskException {
        if (msk == null) {
            throw new IncompatibleMaskException();
        }
        if (this.mask.length < msk.length) {
            return false;
        }
        for (int i = 0; i < msk.length; ++i) {
            byte b = this.mask[i];
            b = (byte)(b ^ 0xFF);
            if (0 == (b = (byte)(b & msk[i]))) continue;
            return false;
        }
        return true;
    }

    @Override
    public byte[] complementMask(byte[] msk, byte[] results) throws IncompatibleMaskException {
        if (msk == null || results == null) {
            throw new IncompatibleMaskException();
        }
        if (results.length < this.mask.length || results.length < msk.length) {
            throw new IncompatibleMaskException();
        }
        int k = this.mask.length;
        if (k < msk.length) {
            k = msk.length;
        }
        for (int i = 0; i < k; ++i) {
            int b = i < this.mask.length ? (int)((byte)(this.mask[i] ^ 0xFF)) : -1;
            b = i < msk.length ? (int)((byte)(b & msk[i])) : 0;
            results[i] = b;
        }
        return results;
    }

    public String toString() {
        Object s = "";
        for (int i = 0; i < this.mask.length; ++i) {
            int b = 0xFF & this.mask[i];
            Object t = Integer.toString(b, 16);
            if (1 == ((String)t).length()) {
                t = "0" + (String)t;
            }
            s = (String)s + (String)t;
        }
        return ((String)s).toUpperCase();
    }

    @Override
    public byte[] getBytes() {
        return this.mask;
    }
}

