/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.DefaultProgramContext;
import ghidra.program.model.listing.ProgramContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractProgramContext
implements ProgramContext,
DefaultProgramContext {
    protected Map<String, Register> registerNameMap;
    protected Register[] registers;
    protected Register baseContextRegister;
    private boolean hasNonFlowingContext = false;
    private byte[] nonFlowingContextRegisterMask;
    private byte[] flowingContextRegisterMask;
    protected RegisterValue defaultDisassemblyContext;

    protected AbstractProgramContext(Register[] registers) {
        this.registers = registers;
        this.registerNameMap = new HashMap<String, Register>();
        this.initNameMap();
        if (this.baseContextRegister != null) {
            this.nonFlowingContextRegisterMask = (byte[])this.baseContextRegister.getBaseMask().clone();
            Arrays.fill(this.nonFlowingContextRegisterMask, (byte)0);
            this.flowingContextRegisterMask = (byte[])this.nonFlowingContextRegisterMask.clone();
            this.initContextBitMasks(this.baseContextRegister);
        }
    }

    private void initContextBitMasks(Register contextReg) {
        block4: {
            byte[] subMask;
            block3: {
                subMask = contextReg.getBaseMask();
                if (contextReg.followsFlow()) break block3;
                this.hasNonFlowingContext = true;
                for (int i = 0; i < this.nonFlowingContextRegisterMask.length; ++i) {
                    int n = i;
                    this.nonFlowingContextRegisterMask[n] = (byte)(this.nonFlowingContextRegisterMask[n] | subMask[i]);
                    int n2 = i;
                    this.flowingContextRegisterMask[n2] = (byte)(this.flowingContextRegisterMask[n2] & ~subMask[i]);
                }
                break block4;
            }
            for (int i = 0; i < this.flowingContextRegisterMask.length; ++i) {
                int n = i;
                this.flowingContextRegisterMask[n] = (byte)(this.flowingContextRegisterMask[n] | subMask[i]);
            }
            if (!contextReg.hasChildren()) break block4;
            for (Register childReg : contextReg.getChildRegisters()) {
                this.initContextBitMasks(childReg);
            }
        }
    }

    @Override
    public final boolean hasNonFlowingContext() {
        return this.hasNonFlowingContext;
    }

    @Override
    public final RegisterValue getFlowValue(RegisterValue value) {
        if (value == null || !this.hasNonFlowingContext || !value.getRegister().isProcessorContext()) {
            return value;
        }
        return value.clearBitValues(this.nonFlowingContextRegisterMask);
    }

    @Override
    public final RegisterValue getNonFlowValue(RegisterValue value) {
        if (value == null || !this.hasNonFlowingContext || !value.getRegister().isProcessorContext()) {
            return null;
        }
        return value.clearBitValues(this.flowingContextRegisterMask);
    }

    protected void initNameMap() {
        this.baseContextRegister = null;
        for (Register register : this.registers) {
            this.registerNameMap.put(register.getName().toUpperCase(), register);
            if (register.isProcessorContext()) {
                this.baseContextRegister = register.getBaseRegister();
            }
            for (String alias : register.getAliases()) {
                this.registerNameMap.put(alias.toUpperCase(), register);
            }
        }
        if (this.baseContextRegister == null) {
            this.baseContextRegister = new Register("DEFAULT_CONTEXT", "DEFAULT_CONTEXT", Address.NO_ADDRESS, 4, true, 0);
        }
        this.defaultDisassemblyContext = new RegisterValue(this.baseContextRegister);
    }

    @Override
    public final Register[] getProcessorStateRegisters() {
        ArrayList<Register> list = new ArrayList<Register>();
        for (Register register : this.registers) {
            if (!register.isProcessorContext()) continue;
            list.add(register);
        }
        return list.toArray(new Register[list.size()]);
    }

    @Override
    public final Register getRegister(String name) {
        return this.registerNameMap.get(name.toUpperCase());
    }

    @Override
    public final String[] getRegisterNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (Register register : this.registers) {
            list.add(register.getName());
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public final Register[] getRegisters() {
        return this.registers;
    }

    @Override
    public final Register getBaseContextRegister() {
        return this.baseContextRegister;
    }

    @Override
    public final RegisterValue getDefaultDisassemblyContext() {
        return this.defaultDisassemblyContext;
    }

    @Override
    public final void setDefaultDisassemblyContext(RegisterValue value) {
        this.defaultDisassemblyContext = value;
    }
}

