/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.util.FunctionParameterFieldLocation;

public class FunctionParameterNameFieldLocation
extends FunctionParameterFieldLocation {
    private String parameterName;

    public FunctionParameterNameFieldLocation(Program program, Address locationAddr, Address functionAddr, int charOffset, String signature, Parameter parameter) {
        super(program, locationAddr, functionAddr, charOffset, signature, parameter);
        this.parameterName = parameter.getName();
    }

    public FunctionParameterNameFieldLocation() {
    }

    public String getParameterName() {
        return this.parameterName;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.parameterName == null ? 0 : this.parameterName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionParameterNameFieldLocation other = (FunctionParameterNameFieldLocation)obj;
        return !(this.parameterName == null ? other.parameterName != null : !this.parameterName.equals(other.parameterName));
    }

    @Override
    public void saveState(SaveState obj) {
        super.saveState(obj);
        obj.putString("_FUNCTION_PARAMETER_NAME", this.parameterName);
    }

    @Override
    public void restoreState(Program p, SaveState obj) {
        super.restoreState(p, obj);
        this.parameterName = obj.getString("_FUNCTION_PARAMETER_NAME", null);
    }
}

