/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.carbon;

import java.io.PrintStream;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfsexplorer.Util;

public class Point
implements StructElements {
    public static final int STRUCTSIZE = 4;
    private final byte[] v = new byte[2];
    private final byte[] h = new byte[2];

    public Point(byte[] data, int offset) {
        System.arraycopy(data, offset + 0, this.v, 0, 2);
        System.arraycopy(data, offset + 2, this.h, 0, 2);
    }

    public static int length() {
        return 4;
    }

    public short getV() {
        return Util.readShortBE((byte[])this.v);
    }

    public short getH() {
        return Util.readShortBE((byte[])this.h);
    }

    public String toString() {
        return "(" + this.getV() + "," + this.getH() + ")";
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " v: " + this.getV());
        ps.println(prefix + " h: " + this.getH());
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "Point:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[4];
        int offset = 0;
        System.arraycopy(this.v, 0, result, offset, this.v.length);
        System.arraycopy(this.h, 0, result, offset += this.v.length, this.h.length);
        offset += this.h.length;
        return result;
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(Point.class.getSimpleName());
        db.addUIntBE("v", this.v);
        db.addUIntBE("h", this.h);
        return db.getResult();
    }
}

