/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.disassembler;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DiscoverableTableUtils;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.app.plugin.core.disassembler.AddressTable;
import ghidra.app.plugin.core.disassembler.AutoTableDisassemblerPlugin;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.table.field.AddressTableColumn;
import ghidra.util.table.field.AddressTableDataTableColumn;
import ghidra.util.table.field.AddressTableLengthTableColumn;
import ghidra.util.table.field.LabelTableColumn;
import ghidra.util.task.TaskMonitor;
import java.util.HashMap;

class AutoTableDisassemblerModel
extends AddressBasedTableModel<AddressTable> {
    static final String MODEL_NAME = "Auto-table Disassembler";
    private AddressSetView addresses;
    private int minimumTableSize;
    private int alignment;
    private int skipAmount;
    private boolean shiftedAddresses;
    private HashMap<Address, AddressTable> map;
    private AutoTableDisassemblerPlugin plugin;

    AutoTableDisassemblerModel(ServiceProvider sp, AutoTableDisassemblerPlugin plugin) {
        super(MODEL_NAME, sp, null, TaskMonitor.DUMMY, true);
        this.plugin = plugin;
    }

    @Override
    protected TableColumnDescriptor<AddressTable> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new AddressTableColumn()), 1, true);
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new LabelTableColumn()));
        descriptor.addVisibleColumn((DynamicTableColumn)new AddressTableDataTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AddressTableLengthTableColumn());
        return descriptor;
    }

    boolean containsKey(Address addr) {
        if (this.map == null) {
            return this.get(addr) != null;
        }
        return this.map.containsKey(addr);
    }

    AddressTable get(Address addr) {
        if (this.map == null) {
            return this.get(addr, TaskMonitor.DUMMY);
        }
        return this.map.get(addr);
    }

    private AddressTable get(Address addr, TaskMonitor monitor) {
        AddressTable entry = AddressTable.getEntry(this.getProgram(), addr, monitor, false, this.minimumTableSize, this.alignment, this.skipAmount, 0L, this.shiftedAddresses, true, false);
        if (this.map != null) {
            this.map.put(addr, entry);
        }
        return entry;
    }

    protected void doLoad(Accumulator<AddressTable> accumulator, TaskMonitor monitor) throws CancelledException {
        this.loadSettings();
        monitor.initialize(this.addresses.getNumAddresses());
        monitor.setMessage("Finding Tables...");
        int addrCount = 0;
        AddressIterator addrIter = this.addresses.getAddresses(true);
        this.map = new HashMap();
        while (addrIter.hasNext()) {
            monitor.checkCanceled();
            monitor.setProgress((long)(++addrCount));
            Address start = addrIter.next();
            AddressTable tableEntry = this.get(start, monitor);
            if (tableEntry == null) continue;
            accumulator.add((Object)tableEntry);
            int tableByteLen = tableEntry.getByteLength();
            addrCount += tableByteLen;
            start = start.add((long)tableByteLen);
            addrIter = this.addresses.getAddresses(start, true);
        }
    }

    private void loadSettings() {
        this.setProgram(this.plugin.getProgram());
        this.addresses = this.plugin.getSelection();
        this.minimumTableSize = this.plugin.getMinimumTableSize();
        this.alignment = this.plugin.getAlignment();
        this.skipAmount = this.plugin.getSkipLength();
        this.shiftedAddresses = this.plugin.isShiftAddresses();
    }

    @Override
    public Address getAddress(int row) {
        return ((AddressTable)this.getRowObject(row)).getTopAddress();
    }

    public int getTableLength(int row) {
        AddressTable table = (AddressTable)this.getRowObject(row);
        if (table == null) {
            return 0;
        }
        return table.getNumberAddressEntries();
    }
}

