/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.disassembler;

import java.awt.Color;
import javax.swing.JTextField;

public class HintTextField
extends JTextField {
    private String hint;
    private Color cForeground;
    private Color cHint;

    public HintTextField(int cols) {
        super(cols);
    }

    public void setHintText(String s) {
        this.hint = s;
    }

    public void showHint() {
        this.setText("");
    }

    @Override
    public void setText(String text) {
        if (text != null && text.isEmpty()) {
            this.setHintAttributes();
            super.setText("<" + this.hint + ">");
        } else {
            this.setPlainAttributes();
            super.setText(text);
        }
    }

    private void setPlainAttributes() {
        this.setFont(this.getFont().deriveFont(0));
        this.setForeground(Color.BLACK);
    }

    private void setHintAttributes() {
        this.cForeground = this.getForeground();
        if (this.cHint == null) {
            this.cHint = new Color(this.cForeground.getRed(), this.cForeground.getGreen(), this.cForeground.getBlue(), this.cForeground.getAlpha() / 2);
        }
        this.setForeground(this.cHint);
        this.setFont(this.getFont().deriveFont(2));
    }
}

