/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objectiveC;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Category;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Class;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Constants;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_State;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ObjectiveC1_SymbolTable
implements StructConverter {
    public static final String NAME = "objc_symtab";
    private ObjectiveC1_State _state;
    private long _index;
    private int sel_ref_cnt;
    private int refs;
    private short cls_def_cnt;
    private short cat_def_cnt;
    private List<ObjectiveC1_Class> classes = new ArrayList<ObjectiveC1_Class>();
    private List<ObjectiveC1_Category> categories = new ArrayList<ObjectiveC1_Category>();

    ObjectiveC1_SymbolTable(ObjectiveC1_State state, BinaryReader reader) throws IOException {
        int i;
        this._state = state;
        this._index = reader.getPointerIndex();
        this.sel_ref_cnt = reader.readNextInt();
        this.refs = reader.readNextInt();
        this.cls_def_cnt = reader.readNextShort();
        this.cat_def_cnt = reader.readNextShort();
        for (i = 0; i < this.cls_def_cnt; ++i) {
            long classIndex = reader.readNextInt();
            long oldClassIndex = reader.getPointerIndex();
            reader.setPointerIndex(classIndex);
            this.classes.add(new ObjectiveC1_Class(state, reader));
            reader.setPointerIndex(oldClassIndex);
        }
        for (i = 0; i < this.cat_def_cnt; ++i) {
            long categoryIndex = reader.readNextInt();
            long oldCategoryIndex = reader.getPointerIndex();
            reader.setPointerIndex(categoryIndex);
            this.categories.add(new ObjectiveC1_Category(state, reader));
            reader.setPointerIndex(oldCategoryIndex);
        }
    }

    public int getSelectorReferenceCount() {
        return this.sel_ref_cnt;
    }

    public int getRefs() {
        return this.refs;
    }

    public short getClassDefinitionCount() {
        return this.cls_def_cnt;
    }

    public short getCategoryDefinitionCount() {
        return this.cat_def_cnt;
    }

    public List<ObjectiveC1_Class> getClasses() {
        return this.classes;
    }

    public List<ObjectiveC1_Category> getCategories() {
        return this.categories;
    }

    public static DataType toGenericDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.setCategoryPath(ObjectiveC1_Constants.CATEGORY_PATH);
        struct.add(DWORD, "sel_ref_cnt", null);
        struct.add(DWORD, "refs", null);
        struct.add(WORD, "cls_def_cnt", null);
        struct.add(WORD, "cat_def_cnt", null);
        return struct;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        int i;
        StructureDataType struct = new StructureDataType("objc_symtab_" + this.cls_def_cnt + "_" + this.cat_def_cnt + "_", 0);
        struct.setCategoryPath(ObjectiveC1_Constants.CATEGORY_PATH);
        struct.add(DWORD, "sel_ref_cnt", null);
        struct.add(DWORD, "refs", null);
        struct.add(WORD, "cls_def_cnt", null);
        struct.add(WORD, "cat_def_cnt", null);
        for (i = 0; i < this.cls_def_cnt; ++i) {
            struct.add((DataType)PointerDataType.getPointer((DataType)this.classes.get(i).toDataType(), (int)this._state.pointerSize), "class" + i, null);
        }
        for (i = 0; i < this.cat_def_cnt; ++i) {
            struct.add((DataType)PointerDataType.getPointer((DataType)this.categories.get(i).toDataType(), (int)this._state.pointerSize), "category" + i, null);
        }
        return struct;
    }

    public void applyTo() throws Exception {
        if (this._state.beenApplied.contains(this._index)) {
            return;
        }
        this._state.beenApplied.add(this._index);
        Address address = this._state.program.getAddressFactory().getDefaultAddressSpace().getAddress(this._index);
        try {
            this._state.program.getListing().createData(address, this.toDataType());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._state.program.getListing().getDefinedDataAt(address);
        for (ObjectiveC1_Class clazz : this.classes) {
            clazz.applyTo();
        }
        for (ObjectiveC1_Category category : this.categories) {
            category.applyTo();
        }
    }
}

