/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.OmfRecord;
import java.io.IOException;
import java.util.ArrayList;

public class OmfLineNumberRecord
extends OmfRecord {
    private int baseGroup;
    private int baseSegment;
    private LineSubrecord[] linenumber;

    public OmfLineNumberRecord(BinaryReader reader) throws IOException {
        this.readRecordHeader(reader);
        boolean hasBigFields = this.hasBigFields();
        this.baseGroup = OmfRecord.readIndex(reader);
        this.baseSegment = OmfRecord.readIndex(reader);
        long max = reader.getPointerIndex() + (long)this.getRecordLength() - 1L;
        ArrayList<LineSubrecord> linelist = new ArrayList<LineSubrecord>();
        while (reader.getPointerIndex() < max) {
            LineSubrecord subrec = LineSubrecord.read(reader, hasBigFields);
            linelist.add(subrec);
        }
        this.readCheckSumByte(reader);
        this.linenumber = new LineSubrecord[linelist.size()];
        linelist.toArray(this.linenumber);
    }

    public static class LineSubrecord {
        private int lineNumber;
        private int lineNumberOffset;

        public static LineSubrecord read(BinaryReader reader, boolean hasBigFields) throws IOException {
            LineSubrecord subrec = new LineSubrecord();
            subrec.lineNumber = reader.readNextShort() & 0xFFFF;
            subrec.lineNumberOffset = OmfRecord.readInt2Or4(reader, hasBigFields);
            return subrec;
        }
    }
}

