/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.vertex;

import java.awt.geom.Point2D;
import org.jdom.Content;
import org.jdom.Element;

class PointInfo {
    static final String POINT_INFO_ELEMENT_NAME = "POINT_INFO";
    private static final String X = "X";
    private static final String Y = "Y";
    String x;
    String y;

    PointInfo(Point2D point) {
        this.x = Double.toString(point.getX());
        this.y = Double.toString(point.getY());
    }

    PointInfo(Element element) {
        this.x = element.getAttributeValue(X);
        this.y = element.getAttributeValue(Y);
        if (this.x == null) {
            throw new NullPointerException("Error reading XML for " + this.getClass().getName());
        }
        if (this.y == null) {
            throw new NullPointerException("Error reading XML for " + this.getClass().getName());
        }
    }

    Point2D getPoint() {
        return new Point2D.Double(Double.valueOf(this.x), Double.valueOf(this.y));
    }

    void write(Element parent) {
        Element element = new Element(POINT_INFO_ELEMENT_NAME);
        element.setAttribute(X, this.x);
        element.setAttribute(Y, this.y);
        parent.addContent((Content)element);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[x=" + this.x + "y=" + this.y + "]";
    }
}

