/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.mvc;

import ghidra.app.plugin.core.functiongraph.graph.FunctionGraphFactory;
import ghidra.app.plugin.core.functiongraph.mvc.EmptyFunctionGraphData;
import ghidra.app.plugin.core.functiongraph.mvc.FGController;
import ghidra.app.plugin.core.functiongraph.mvc.FGData;
import ghidra.app.plugin.core.functiongraph.mvc.FGModel;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.IsolatedEntrySubModel;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.UndefinedFunction;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.SwingRunnable;
import ghidra.util.task.TaskMonitor;

public class FunctionGraphRunnable
implements SwingRunnable {
    private final FGController controller;
    private final FGModel model;
    private final ProgramLocation location;
    private final Program program;
    private final Function function;
    private FGData graphData;
    private TaskMonitor taskMonitor;

    public FunctionGraphRunnable(FGController controller, Program program, ProgramLocation location) {
        if (location == null) {
            throw new NullPointerException("Location cannot be null");
        }
        if (program == null) {
            throw new NullPointerException("Program cannot be null");
        }
        this.controller = controller;
        this.model = controller.getModel();
        this.program = program;
        this.location = location;
        FunctionManager functionManager = program.getFunctionManager();
        this.function = functionManager.getFunctionContaining(location.getAddress());
    }

    boolean containsLocation(ProgramLocation programLocation) {
        if (this.function == null) {
            return false;
        }
        return this.function.getBody().contains(programLocation.getAddress());
    }

    ProgramLocation getLocation() {
        return this.location;
    }

    public void swingRun(boolean isCancelled) {
        if (isCancelled) {
            this.graphData = new EmptyFunctionGraphData("Graph cancelled for location: " + this.location.getAddress());
        } else if (this.program.isClosed()) {
            this.graphData = new EmptyFunctionGraphData("Program closed: " + this.location.getAddress());
        } else if (this.graphData == null) {
            this.graphData = new EmptyFunctionGraphData("No Function at " + this.location.getAddress());
        }
        this.model.setFunctionGraphData(this, this.graphData);
    }

    public void monitoredRun(TaskMonitor monitor) {
        this.taskMonitor = monitor;
        monitor.setProgress(0L);
        Function validatedFunction = this.validateFunction(this.function, this.location.getAddress());
        if (validatedFunction == null) {
            String message = "Location is not in a defined or undefined function \"" + this.location.getAddress() + "\"";
            this.graphData = new EmptyFunctionGraphData(message);
            monitor.setMessage(message);
            return;
        }
        monitor.setMessage("Creating graph for \"" + validatedFunction.getName() + "\"");
        monitor.setProgress(0L);
        try {
            this.graphData = FunctionGraphFactory.createNewGraph(validatedFunction, this.controller, this.program, monitor);
            monitor.setMessage("Finished creating graph for \"" + validatedFunction.getName() + "\"");
        }
        catch (CancelledException e) {
            String message = "Cancelled graph for \"" + validatedFunction.getName() + "\"";
            this.graphData = new EmptyFunctionGraphData(message);
            monitor.setMessage(message);
        }
    }

    private Function validateFunction(Function currentFunction, Address address) {
        if (currentFunction != null) {
            return currentFunction;
        }
        return this.findFunctionUsingIsolatedBlockModel(address);
    }

    private Function findFunctionUsingIsolatedBlockModel(Address address) {
        this.taskMonitor.setMessage("Locating undefined function entry using Isolated Entry model...");
        try {
            IsolatedEntrySubModel blockModel = new IsolatedEntrySubModel(this.program);
            CodeBlock codeBlock = blockModel.getFirstCodeBlockContaining(address, this.taskMonitor);
            if (codeBlock == null) {
                return null;
            }
            Address entry = codeBlock.getFirstStartAddress();
            Function newFunction = this.program.getFunctionManager().getFunctionAt(entry);
            if (newFunction != null) {
                return newFunction;
            }
            UndefinedFunction undefinedFunction = new UndefinedFunction(this.program, entry);
            undefinedFunction.setBody((AddressSetView)codeBlock);
            return undefinedFunction;
        }
        catch (CancelledException e) {
            return null;
        }
    }
}

