/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.util.job;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.util.Caching;
import ghidra.app.plugin.core.functiongraph.graph.FGEdge;
import ghidra.app.plugin.core.functiongraph.graph.FunctionGraph;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.app.plugin.core.functiongraph.mvc.FGController;
import ghidra.app.plugin.core.functiongraph.mvc.FGData;
import ghidra.graph.job.AbstractAnimatorJob;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.collections4.IterableUtils;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.interpolation.PropertySetter;

public class SplitVertexFunctionGraphJob
extends AbstractAnimatorJob {
    private static final int DURATION = 1500;
    private final VisualizationServer<FGVertex, FGEdge> viewer;
    private Layout<FGVertex, FGEdge> graphLayout;
    private final FGVertex toSplitVertex;
    private final FGVertex parentVertex;
    private final FGVertex childVertex;
    private Point2D parentStart;
    private Point2D childStart;
    private Point2D parentDestination;
    private Point2D childDestination;
    private final boolean useAnimation;
    private final FGController controller;

    public SplitVertexFunctionGraphJob(FGController controller, VisualizationServer<FGVertex, FGEdge> viewer, FGVertex toSplitVertex, FGVertex newParentVertex, FGVertex newChildVertex, boolean useAnimation) {
        this.controller = controller;
        this.viewer = viewer;
        this.toSplitVertex = toSplitVertex;
        this.parentVertex = newParentVertex;
        this.childVertex = newChildVertex;
        this.useAnimation = useAnimation;
        this.graphLayout = viewer.getGraphLayout();
        this.updateOpacity(0.0);
    }

    public boolean canShortcut() {
        return false;
    }

    public void shortcut() {
        throw new UnsupportedOperationException("Cannot cancel this job: " + this);
    }

    protected Animator createAnimator() {
        this.parentVertex.setAlpha(0.0);
        this.childVertex.setAlpha(0.0);
        this.initializeVertexLocations();
        if (!this.useAnimation) {
            return null;
        }
        this.updateOpacity(0.0);
        Animator newAnimator = PropertySetter.createAnimator((int)1500, (Object)((Object)this), (String)"percentComplete", (Object[])new Double[]{0.0, 1.0});
        newAnimator.setAcceleration(0.0f);
        newAnimator.setDeceleration(0.8f);
        return newAnimator;
    }

    protected void finished() {
        if (this.isShortcut) {
            this.initializeVertexLocations();
        }
        this.clearLocationCache();
        this.graphLayout.setLocation((Object)this.parentVertex, this.parentDestination);
        this.graphLayout.setLocation((Object)this.childVertex, this.childDestination);
        this.removeOldVertexAndEdges();
        this.updateOpacity(1.0);
        this.controller.synchronizeProgramLocationAfterEdit();
        this.restoreEdgeDisplayAttributes();
        this.viewer.repaint();
    }

    private void restoreEdgeDisplayAttributes() {
        Iterable edges = IterableUtils.chainedIterable(this.getEdges(this.parentVertex), this.getEdges(this.childVertex));
        for (FGEdge edge : edges) {
            double alpha = edge.getDefaultAlpha();
            edge.setAlpha(alpha);
        }
    }

    public void setPercentComplete(double percentComplete) {
        this.trace("setPercentComplete() callback: " + percentComplete);
        this.updateNewVertexPositions(percentComplete);
        this.updateOpacity(percentComplete);
        this.viewer.repaint();
    }

    protected void clearLocationCache() {
        Layout jungLayout = this.viewer.getGraphLayout();
        ((Caching)jungLayout).clear();
    }

    private void updateNewVertexPositions(double percentComplete) {
        double parentDestinationX = this.parentDestination.getX();
        double parentDeltaX = (parentDestinationX - this.parentStart.getX()) * percentComplete;
        double childDestinationY = this.childDestination.getY();
        double childDeltaY = (childDestinationY - this.childStart.getY()) * percentComplete;
        double childDestinationX = this.childDestination.getX();
        double childDeltaX = (childDestinationX - this.childStart.getX()) * percentComplete;
        double parentDestinationY = this.parentDestination.getY();
        double parentDeltaY = (parentDestinationY - this.parentStart.getY()) * percentComplete;
        double newParentX = this.parentStart.getX() + parentDeltaX;
        double newParentY = this.parentStart.getY() + parentDeltaY;
        double newChildX = this.childStart.getX() + childDeltaX;
        double newChildY = this.childStart.getY() + childDeltaY;
        Point2D.Double newParentLocation = new Point2D.Double(newParentX, newParentY);
        Point2D.Double newChildLocation = new Point2D.Double(newChildX, newChildY);
        this.parentVertex.setLocation(newParentLocation);
        this.childVertex.setLocation(newChildLocation);
        this.clearLocationCache();
        this.graphLayout.setLocation((Object)this.parentVertex, (Point2D)newParentLocation);
        this.graphLayout.setLocation((Object)this.childVertex, (Point2D)newChildLocation);
    }

    private void initializeVertexLocations() {
        Point2D oldLocation = (Point2D)this.graphLayout.apply((Object)this.toSplitVertex);
        Point2D oldLocationProperty = this.toSplitVertex.getLocation();
        Point2D parentLocation = (Point2D)oldLocation.clone();
        Point2D parentLocationProperty = (Point2D)oldLocationProperty.clone();
        Rectangle originalBounds = this.toSplitVertex.getBounds();
        Rectangle newBounds = this.parentVertex.getBounds();
        int dy = newBounds.height - originalBounds.height >> 1;
        parentLocation.setLocation(parentLocation.getX(), parentLocation.getY() + (double)dy);
        this.parentDestination = this.parentStart = parentLocation;
        this.childStart = this.parentStart;
        this.parentVertex.setLocation(parentLocationProperty);
        this.graphLayout.setLocation((Object)this.parentVertex, parentLocation);
        Point2D childStartLocation = (Point2D)parentLocation.clone();
        this.childVertex.setLocation(oldLocationProperty);
        this.graphLayout.setLocation((Object)this.childVertex, childStartLocation);
        Rectangle parentBounds = this.parentVertex.getBounds();
        double childY = childStartLocation.getY() + (double)parentBounds.height + 50.0;
        this.childDestination = new Point2D.Double(childStartLocation.getX(), childY);
        this.clearLocationCache();
    }

    private void updateOpacity(double percentComplete) {
        double alpha;
        double defaultAlpha;
        double oldComponentsAlpha = 1.0 - percentComplete;
        this.toSplitVertex.setAlpha(oldComponentsAlpha);
        Collection<FGEdge> edges = this.getEdges(this.toSplitVertex);
        for (FGEdge edge : edges) {
            double defaultAlpha2 = edge.getDefaultAlpha();
            double alpha2 = Math.min(oldComponentsAlpha, defaultAlpha2);
            edge.setAlpha(alpha2);
        }
        double newComponentsAlpha = percentComplete;
        this.parentVertex.setAlpha(newComponentsAlpha);
        this.childVertex.setAlpha(newComponentsAlpha);
        edges = this.getEdges(this.parentVertex);
        for (FGEdge edge : edges) {
            defaultAlpha = edge.getDefaultAlpha();
            alpha = Math.min(newComponentsAlpha, defaultAlpha);
            edge.setAlpha(alpha);
        }
        edges = this.getEdges(this.childVertex);
        for (FGEdge edge : edges) {
            defaultAlpha = edge.getDefaultAlpha();
            alpha = Math.min(newComponentsAlpha, defaultAlpha);
            edge.setAlpha(alpha);
        }
    }

    private Collection<FGEdge> getEdges(FGVertex vertex) {
        Collection outEdges;
        Graph graph = this.graphLayout.getGraph();
        LinkedList<FGEdge> edges = new LinkedList<FGEdge>();
        Collection inEdges = graph.getInEdges((Object)vertex);
        if (inEdges != null) {
            edges.addAll(inEdges);
        }
        if ((outEdges = graph.getOutEdges((Object)vertex)) != null) {
            edges.addAll(outEdges);
        }
        return edges;
    }

    private void removeOldVertexAndEdges() {
        FGData functionGraphData = this.controller.getFunctionGraphData();
        FunctionGraph graph = functionGraphData.getFunctionGraph();
        graph.removeVertex(this.toSplitVertex);
    }
}

