/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.WeakSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.WeakHashMap;
import org.apache.commons.collections4.IteratorUtils;

class CopyOnWriteWeakSet<T>
extends WeakSet<T> {
    CopyOnWriteWeakSet() {
    }

    @Override
    public synchronized Iterator<T> iterator() {
        return IteratorUtils.unmodifiableIterator(this.weakHashStorage.keySet().iterator());
    }

    @Override
    public synchronized void add(T t) {
        this.maybeWarnAboutAnonymousValue(t);
        this.weakHashStorage = new WeakHashMap(this.weakHashStorage);
        this.weakHashStorage.put(t, null);
    }

    @Override
    public synchronized void remove(T t) {
        this.weakHashStorage = new WeakHashMap(this.weakHashStorage);
        this.weakHashStorage.remove(t);
    }

    @Override
    public synchronized void clear() {
        this.weakHashStorage = new WeakHashMap();
    }

    @Override
    public synchronized Collection<T> values() {
        return this.weakHashStorage.keySet();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.weakHashStorage.isEmpty();
    }

    @Override
    public synchronized int size() {
        return this.weakHashStorage.size();
    }

    @Override
    public synchronized boolean contains(T t) {
        return this.weakHashStorage.containsKey(t);
    }
}

