/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.worker;

import ghidra.util.task.TaskMonitor;
import ghidra.util.worker.AbstractWorker;
import ghidra.util.worker.PriorityJob;
import java.util.Comparator;
import java.util.concurrent.PriorityBlockingQueue;

public class PriorityWorker
extends AbstractWorker<PriorityJob> {
    public PriorityWorker(String name, TaskMonitor monitor) {
        super(new PriorityBlockingQueue<PriorityJob>(11, new PriorityJobComparator()), false, name, true, monitor);
    }

    public PriorityWorker(String name, boolean isPersistentThread, boolean useSharedThreadPool, TaskMonitor monitor) {
        super(new PriorityBlockingQueue<PriorityJob>(11, new PriorityJobComparator()), isPersistentThread, name, useSharedThreadPool, monitor);
    }

    @Override
    public synchronized void schedule(PriorityJob job) {
        super.schedule(job);
    }

    private static class PriorityJobComparator
    implements Comparator<PriorityJob> {
        private PriorityJobComparator() {
        }

        @Override
        public int compare(PriorityJob o1, PriorityJob o2) {
            long priority2;
            long priority1 = o1.getPriority();
            if (priority1 > (priority2 = o2.getPriority())) {
                return 1;
            }
            if (priority1 < priority2) {
                return -1;
            }
            return 0;
        }
    }
}

