/*
 * Decompiled with CFR 0.152.
 */
package ghidra.xml;

import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.util.Iterator;
import java.util.LinkedList;
import org.xml.sax.SAXParseException;

public class XmlTreeNode {
    private final XmlElement startElement;
    private final XmlElement endElement;
    private final LinkedList<XmlTreeNode> children = new LinkedList();

    public XmlTreeNode(XmlPullParser parser) throws SAXParseException {
        this.startElement = parser.start(new String[0]);
        XmlElement child = parser.peek();
        while (child != null && child.isStart()) {
            this.children.add(new XmlTreeNode(parser));
            child = parser.peek();
        }
        this.endElement = parser.end(this.startElement);
    }

    public XmlElement getStartElement() {
        return this.startElement;
    }

    public XmlElement getEndElement() {
        return this.endElement;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public Iterator<XmlTreeNode> getChildren() {
        return this.children.iterator();
    }

    public Iterator<XmlTreeNode> getChildren(String name) {
        return new TagIterator(name);
    }

    public XmlTreeNode getChild(String name) {
        Iterator<XmlTreeNode> it = this.getChildren(name);
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    public XmlTreeNode getChildAt(int index) {
        return this.children.get(index);
    }

    public void deleteChildNode(XmlTreeNode node) {
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            if (it.next() != node) continue;
            it.remove();
            return;
        }
    }

    class TagIterator
    implements Iterator<XmlTreeNode> {
        private Iterator<XmlTreeNode> it;
        private XmlTreeNode nextNode;
        private String tag;

        TagIterator(String tag) {
            this.tag = tag;
            this.it = XmlTreeNode.this.children.iterator();
        }

        private void findNext() {
            while (this.it.hasNext()) {
                this.nextNode = this.it.next();
                if (!this.nextNode.getStartElement().getName().equals(this.tag)) continue;
                return;
            }
            this.nextNode = null;
        }

        @Override
        public void remove() {
            this.it.remove();
        }

        @Override
        public boolean hasNext() {
            if (this.nextNode == null) {
                this.findNext();
            }
            return this.nextNode != null;
        }

        @Override
        public XmlTreeNode next() {
            if (this.hasNext()) {
                XmlTreeNode node = this.nextNode;
                this.nextNode = null;
                return node;
            }
            return null;
        }
    }
}

