/*
 * Decompiled with CFR 0.152.
 */
package io.nettyx.util.internal.logging;

import io.nettyx.util.internal.logging.InternalLogger;
import io.nettyx.util.internal.logging.SimpleLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InternalLoggerFactory {
    private static volatile InternalLoggerFactory defaultFactory = InternalLoggerFactory.newDefaultFactory(InternalLoggerFactory.class.getName());

    static {
        try {
            Class.forName(InternalLoggerFactory.class.getName(), true, InternalLoggerFactory.class.getClassLoader());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static InternalLoggerFactory newDefaultFactory(String name) {
        SimpleLoggerFactory f = new SimpleLoggerFactory();
        ((InternalLoggerFactory)f).newInstance(name).debug("Using System.out as the default logging framework");
        return f;
    }

    public static InternalLoggerFactory getDefaultFactory() {
        return defaultFactory;
    }

    public static void setDefaultFactory(InternalLoggerFactory defaultFactory) {
        if (defaultFactory == null) {
            throw new NullPointerException("defaultFactory");
        }
        InternalLoggerFactory.defaultFactory = defaultFactory;
    }

    public static InternalLogger getInstance(Class<?> clazz) {
        return InternalLoggerFactory.getInstance(clazz.getName());
    }

    public static InternalLogger getInstance(String name) {
        return InternalLoggerFactory.getDefaultFactory().newInstance(name);
    }

    protected abstract InternalLogger newInstance(String var1);
}

