/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph;

import ghidra.graph.GEdge;
import java.util.Collection;
import java.util.LinkedHashSet;

public interface GDirectedGraph<V, E extends GEdge<V>> {
    public boolean addVertex(V var1);

    public boolean removeVertex(V var1);

    public void removeVertices(Iterable<V> var1);

    public void addEdge(E var1);

    public boolean removeEdge(E var1);

    public void removeEdges(Iterable<E> var1);

    public E findEdge(V var1, V var2);

    public Collection<V> getVertices();

    public Collection<E> getEdges();

    public boolean containsVertex(V var1);

    public boolean containsEdge(E var1);

    public boolean containsEdge(V var1, V var2);

    public boolean isEmpty();

    public int getVertexCount();

    public int getEdgeCount();

    public Collection<E> getInEdges(V var1);

    public Collection<E> getOutEdges(V var1);

    default public Collection<E> getIncidentEdges(V v) {
        LinkedHashSet<E> result = new LinkedHashSet<E>();
        result.addAll(this.getInEdges(v));
        result.addAll(this.getOutEdges(v));
        return result;
    }

    default public Collection<V> getPredecessors(V v) {
        LinkedHashSet result = new LinkedHashSet();
        for (GEdge edge : this.getInEdges(v)) {
            result.add(edge.getStart());
        }
        return result;
    }

    default public Collection<V> getSuccessors(V v) {
        LinkedHashSet result = new LinkedHashSet();
        for (GEdge edge : this.getOutEdges(v)) {
            result.add(edge.getEnd());
        }
        return result;
    }

    public GDirectedGraph<V, E> copy();

    public GDirectedGraph<V, E> emptyCopy();
}

