/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.job;

import ghidra.graph.VisualGraph;
import ghidra.graph.job.AbstractAnimatorJob;
import ghidra.graph.viewer.GraphViewer;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import java.util.stream.Collectors;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.interpolation.PropertySetter;
import util.CollectionUtils;

public abstract class AbstractGraphVisibilityTransitionJob<V extends VisualVertex, E extends VisualEdge<V>>
extends AbstractAnimatorJob {
    protected static final int NORMAL_DURATION = 1500;
    protected static final int FAST_DURATION = 700;
    protected int duration = 1500;
    protected final GraphViewer<V, E> viewer;
    protected final VisualGraph<V, E> graph;
    protected boolean useAnimation;

    protected AbstractGraphVisibilityTransitionJob(GraphViewer<V, E> viewer, boolean useAnimation) {
        this.useAnimation = useAnimation;
        this.viewer = viewer;
        this.graph = viewer.getVisualGraph();
        if (this.isTooBigToAnimate()) {
            this.useAnimation = false;
        }
    }

    protected boolean isTooBigToAnimate() {
        return this.graph.getVertexCount() >= 125;
    }

    public void setPercentComplete(double percentComplete) {
        this.trace("setPercentComplete() callback: " + percentComplete);
        this.updateOpacity(percentComplete);
        this.viewer.repaint();
    }

    @Override
    protected Animator createAnimator() {
        if (!this.useAnimation) {
            return null;
        }
        this.updateOpacity(0.0);
        Animator newAnimator = PropertySetter.createAnimator((int)this.duration, (Object)this, (String)"percentComplete", (Object[])new Double[]{0.0, 1.0});
        newAnimator.setAcceleration(0.0f);
        newAnimator.setDeceleration(0.8f);
        return newAnimator;
    }

    @Override
    protected void finished() {
        this.setPercentComplete(1.0);
        this.viewer.repaint();
    }

    protected void updateOpacity(double percentComplete) {
    }

    protected Set<E> getEdges(Collection<V> vertices) {
        return vertices.stream().map(v -> CollectionUtils.nonNull(this.graph.getIncidentEdges((VisualVertex)v))).flatMap(collection -> collection.stream()).collect(Collectors.toSet());
    }

    protected Collection<E> getEdges(V vertex) {
        LinkedList edges = new LinkedList();
        Collection inEdges = CollectionUtils.nonNull(this.graph.getInEdges(vertex));
        edges.addAll(inEdges);
        Collection outEdges = CollectionUtils.nonNull(this.graph.getOutEdges(vertex));
        edges.addAll(outEdges);
        return edges;
    }
}

