/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.logging;

import io.netty.util.internal.logging.InternalLogLevel;
import io.netty.util.internal.logging.InternalLogger;
import java.util.logging.Level;
import java.util.logging.Logger;

class JdkLogger2
implements InternalLogger {
    private final Logger logger;

    JdkLogger2(Logger logger) {
        this.logger = logger;
    }

    public void debug(String msg) {
        this.logger.log(Level.FINE, msg);
    }

    public void debug(String msg, Throwable cause) {
        this.logger.log(Level.FINE, msg, cause);
    }

    public void error(String msg) {
        this.logger.log(Level.SEVERE, msg);
    }

    public void error(String msg, Throwable cause) {
        this.logger.log(Level.SEVERE, msg, cause);
    }

    public void info(String msg) {
        this.logger.log(Level.INFO, msg);
    }

    public void info(String msg, Throwable cause) {
        this.logger.log(Level.INFO, msg, cause);
    }

    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    public void warn(String msg) {
        this.logger.log(Level.WARNING, msg);
    }

    public void warn(String msg, Throwable cause) {
        this.logger.log(Level.WARNING, msg, cause);
    }

    public String toString() {
        return this.logger.toString();
    }

    public void debug(String msg, Object paramObject) {
        this.logger.log(Level.FINE, msg, paramObject);
    }

    public void debug(String msg, Object ... paramArrayOfObject) {
        this.logger.log(Level.FINE, msg, paramArrayOfObject);
    }

    public void debug(String msg, Object paramObject1, Object paramObject2) {
        this.logger.log(Level.FINE, msg, new Object[]{paramObject1, paramObject2});
    }

    public void error(String msg, Object paramObject) {
        this.logger.log(Level.SEVERE, msg, paramObject);
    }

    public void error(String msg, Object ... paramArrayOfObject) {
        this.logger.log(Level.SEVERE, msg, paramArrayOfObject);
    }

    public void error(String msg, Object paramObject1, Object paramObject2) {
        this.logger.log(Level.SEVERE, msg, new Object[]{paramObject1, paramObject2});
    }

    public void info(String msg, Object paramObject) {
        this.logger.log(Level.INFO, msg, paramObject);
    }

    public void info(String msg, Object ... paramArrayOfObject) {
        this.logger.log(Level.INFO, msg, paramArrayOfObject);
    }

    public void info(String msg, Object paramObject1, Object paramObject2) {
        this.logger.log(Level.INFO, msg, new Object[]{paramObject1, paramObject2});
    }

    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    public void trace(String msg) {
        this.info(msg);
    }

    public void trace(String msg, Object paramObject) {
        this.info(msg, paramObject);
    }

    public void trace(String msg, Object ... paramArrayOfObject) {
        this.info(msg, paramArrayOfObject);
    }

    public void trace(String msg, Throwable paramThrowable) {
        this.info(msg, paramThrowable);
    }

    public void trace(String msg, Object paramObject1, Object paramObject2) {
        this.info(msg, paramObject1, paramObject2);
    }

    public void warn(String msg, Object paramObject) {
        this.error(msg, paramObject);
    }

    public void warn(String msg, Object ... paramArrayOfObject) {
        this.error(msg, paramArrayOfObject);
    }

    public void warn(String msg, Object paramObject1, Object paramObject2) {
        this.error(msg, paramObject1, paramObject2);
    }

    public String name() {
        return this.logger.getName();
    }

    public boolean isEnabled(InternalLogLevel paramInternalLogLevel) {
        return false;
    }

    public void log(InternalLogLevel paramInternalLogLevel, String paramString) {
    }

    public void log(InternalLogLevel paramInternalLogLevel, String paramString, Object paramObject) {
    }

    public void log(InternalLogLevel paramInternalLogLevel, String paramString, Object paramObject1, Object paramObject2) {
    }

    public void log(InternalLogLevel paramInternalLogLevel, String paramString, Object ... paramArrayOfObject) {
    }

    public void log(InternalLogLevel paramInternalLogLevel, String paramString, Throwable paramThrowable) {
    }
}

