/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlets;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.PushBuilder;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="Push cache based on the HTTP 'Referer' header")
public class PushCacheFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(PushCacheFilter.class);
    private final Set<Integer> _ports = new HashSet<Integer>();
    private final Set<String> _hosts = new HashSet<String>();
    private final ConcurrentMap<String, PrimaryResource> _cache = new ConcurrentHashMap<String, PrimaryResource>();
    private long _associatePeriod = 4000L;
    private int _maxAssociations = 16;
    private long _renew = System.nanoTime();
    private boolean _useQueryInKey;

    @Override
    public void init(FilterConfig config) throws ServletException {
        String ports;
        String hosts;
        String maxAssociations;
        String associatePeriod = config.getInitParameter("associatePeriod");
        if (associatePeriod != null) {
            this._associatePeriod = Long.parseLong(associatePeriod);
        }
        if ((maxAssociations = config.getInitParameter("maxAssociations")) != null) {
            this._maxAssociations = Integer.parseInt(maxAssociations);
        }
        if ((hosts = config.getInitParameter("hosts")) != null) {
            Collections.addAll(this._hosts, StringUtil.csvSplit(hosts));
        }
        if ((ports = config.getInitParameter("ports")) != null) {
            for (String p : StringUtil.csvSplit(ports)) {
                this._ports.add(Integer.parseInt(p));
            }
        }
        this._useQueryInKey = Boolean.parseBoolean(config.getInitParameter("useQueryInKey"));
        config.getServletContext().setAttribute(config.getFilterName(), this);
        if (LOG.isDebugEnabled()) {
            LOG.debug("period={} max={} hosts={} ports={}", this._associatePeriod, this._maxAssociations, this._hosts, this._ports);
        }
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        PrimaryResource primaryResource;
        HttpServletRequest request = (HttpServletRequest)req;
        PushBuilder pushBuilder = request.newPushBuilder();
        if (HttpVersion.fromString(request.getProtocol()).getVersion() < 20 || !HttpMethod.GET.is(request.getMethod()) || pushBuilder == null) {
            chain.doFilter(req, resp);
            return;
        }
        long now = System.nanoTime();
        boolean conditional = false;
        String referrer = null;
        ArrayList<String> headerNames = Collections.list(request.getHeaderNames());
        for (String headerName : headerNames) {
            if (HttpHeader.IF_MATCH.is(headerName) || HttpHeader.IF_MODIFIED_SINCE.is(headerName) || HttpHeader.IF_NONE_MATCH.is(headerName) || HttpHeader.IF_UNMODIFIED_SINCE.is(headerName)) {
                conditional = true;
                break;
            }
            if (!HttpHeader.REFERER.is(headerName)) continue;
            referrer = request.getHeader(headerName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} {} referrer={} conditional={}", request.getMethod(), request.getRequestURI(), referrer, conditional);
        }
        Object path = request.getRequestURI();
        String query = request.getQueryString();
        if (this._useQueryInKey && query != null) {
            path = (String)path + "?" + query;
        }
        if (referrer != null) {
            boolean referredFromHere;
            HttpURI.Immutable referrerURI = HttpURI.from(referrer);
            String host = referrerURI.getHost();
            int port2 = referrerURI.getPort();
            if (port2 <= 0) {
                String scheme = referrerURI.getScheme();
                port2 = scheme != null ? (HttpScheme.HTTPS.is(scheme) ? 443 : 80) : (request.isSecure() ? 443 : 80);
            }
            boolean bl = referredFromHere = !this._hosts.isEmpty() ? this._hosts.contains(host) : host.equals(request.getServerName());
            if (referredFromHere &= !this._ports.isEmpty() ? this._ports.contains(port2) : port2 == request.getServerPort()) {
                if (HttpMethod.GET.is(request.getMethod())) {
                    String referrerPath;
                    String string = referrerPath = this._useQueryInKey ? referrerURI.getPathQuery() : referrerURI.getPath();
                    if (referrerPath == null) {
                        referrerPath = "/";
                    }
                    if (referrerPath.startsWith(request.getContextPath() + "/")) {
                        if (!referrerPath.equals(path)) {
                            long primaryTimestamp;
                            PrimaryResource primaryResource2 = (PrimaryResource)this._cache.get(referrerPath);
                            if (primaryResource2 != null && (primaryTimestamp = primaryResource2._timestamp.get()) != 0L) {
                                if (now - primaryTimestamp < TimeUnit.MILLISECONDS.toNanos(this._associatePeriod)) {
                                    Set<String> associated = primaryResource2._associated;
                                    if (associated.size() <= this._maxAssociations) {
                                        if (associated.add((String)path) && LOG.isDebugEnabled()) {
                                            LOG.debug("Associated {} to {}", path, (Object)referrerPath);
                                        }
                                    } else if (LOG.isDebugEnabled()) {
                                        LOG.debug("Not associated {} to {}, exceeded max associations of {}", path, referrerPath, this._maxAssociations);
                                    }
                                } else if (LOG.isDebugEnabled()) {
                                    LOG.debug("Not associated {} to {}, outside associate period of {}ms", path, referrerPath, this._associatePeriod);
                                }
                            }
                        } else if (LOG.isDebugEnabled()) {
                            LOG.debug("Not associated {} to {}, referring to self", path, (Object)referrerPath);
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Not associated {} to {}, different context", path, (Object)referrerPath);
                    }
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("External referrer {}", (Object)referrer);
            }
        }
        if ((primaryResource = (PrimaryResource)this._cache.get(path)) == null) {
            PrimaryResource r = new PrimaryResource();
            primaryResource = this._cache.putIfAbsent((String)path, r);
            primaryResource = primaryResource == null ? r : primaryResource;
            primaryResource._timestamp.compareAndSet(0L, now);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cached primary resource {}", path);
            }
        } else {
            long last = primaryResource._timestamp.get();
            if (last < this._renew && primaryResource._timestamp.compareAndSet(last, now)) {
                primaryResource._associated.clear();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Clear associated resources for {}", path);
                }
            }
        }
        if (!conditional && !primaryResource._associated.isEmpty()) {
            ArrayDeque<PrimaryResource> queue = new ArrayDeque<PrimaryResource>();
            queue.offer(primaryResource);
            while (!queue.isEmpty()) {
                PrimaryResource parent = (PrimaryResource)queue.poll();
                for (String childPath : parent._associated) {
                    PrimaryResource child = (PrimaryResource)this._cache.get(childPath);
                    if (child != null) {
                        queue.offer(child);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Pushing {} for {}", (Object)childPath, path);
                    }
                    pushBuilder.path(childPath).push();
                }
            }
        }
        chain.doFilter(request, resp);
    }

    @Override
    public void destroy() {
        this.clearPushCache();
    }

    @ManagedAttribute(value="The push cache contents")
    public Map<String, String> getPushCache() {
        HashMap<String, String> result2 = new HashMap<String, String>();
        for (Map.Entry entry : this._cache.entrySet()) {
            PrimaryResource resource2 = (PrimaryResource)entry.getValue();
            String value2 = String.format("size=%d: %s", resource2._associated.size(), new TreeSet<String>(resource2._associated));
            result2.put((String)entry.getKey(), value2);
        }
        return result2;
    }

    @ManagedOperation(value="Renews the push cache contents", impact="ACTION")
    public void renewPushCache() {
        this._renew = System.nanoTime();
    }

    @ManagedOperation(value="Clears the push cache contents", impact="ACTION")
    public void clearPushCache() {
        this._cache.clear();
    }

    private static class PrimaryResource {
        private final Set<String> _associated = Collections.newSetFromMap(new ConcurrentHashMap());
        private final AtomicLong _timestamp = new AtomicLong();

        private PrimaryResource() {
        }
    }
}

