/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.xmpp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.impl.protocol.xmpp.ChatRoom;
import org.jitsi.jicofo.TaskPools;
import org.jitsi.jicofo.xmpp.Features;
import org.jitsi.jicofo.xmpp.Muc;
import org.jitsi.jicofo.xmpp.XmppConnectionConfig;
import org.jitsi.jicofo.xmpp.XmppProvider;
import org.jitsi.jicofo.xmpp.XmppProviderKt;
import org.jitsi.retry.RetryStrategy;
import org.jitsi.retry.SimpleRetryTask;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.ReconnectionListener;
import org.jivesoftware.smack.ReconnectionManager;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smackx.caps.EntityCapsManager;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.parts.Resourcepart;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005*\u0002\u0014\u001d\u0018\u0000 B2\u00020\u0001:\u0004BCDEB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020\u0018J\u000e\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0002J\u0014\u00105\u001a\b\u0012\u0004\u0012\u0002060\b2\u0006\u00107\u001a\u000208J\b\u00109\u001a\u00020\u001fH\u0002J\u000e\u0010:\u001a\u00020.2\u0006\u0010/\u001a\u000200J\u0016\u0010;\u001a\u0002022\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0010\u0010<\u001a\u0002022\u0006\u0010 \u001a\u00020\u001fH\u0002J\u000e\u0010=\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020\u0018J\u0006\u0010>\u001a\u000202J\u0006\u0010?\u001a\u000202J\b\u0010@\u001a\u00020AH\u0016R0\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001eR$\u0010 \u001a\u00020\u001f2\u0006\u0010\u0007\u001a\u00020\u001f@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010'\u001a\u00020(\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*\u00a8\u0006F"}, d2={"Lorg/jitsi/jicofo/xmpp/XmppProvider;", "", "config", "Lorg/jitsi/jicofo/xmpp/XmppConnectionConfig;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "(Lorg/jitsi/jicofo/xmpp/XmppConnectionConfig;Lorg/jitsi/utils/logging2/Logger;)V", "value", "", "Lorg/jitsi/jicofo/xmpp/XmppProvider$Component;", "components", "getComponents", "()Ljava/util/Set;", "setComponents", "(Ljava/util/Set;)V", "getConfig", "()Lorg/jitsi/jicofo/xmpp/XmppConnectionConfig;", "connectRetry", "Lorg/jitsi/retry/RetryStrategy;", "connectionListener", "org/jitsi/jicofo/xmpp/XmppProvider$connectionListener$1", "Lorg/jitsi/jicofo/xmpp/XmppProvider$connectionListener$1;", "listeners", "Ljava/util/concurrent/CopyOnWriteArraySet;", "Lorg/jitsi/jicofo/xmpp/XmppProvider$Listener;", "logger", "muc", "Lorg/jitsi/jicofo/xmpp/Muc;", "reconnectionListener", "org/jitsi/jicofo/xmpp/XmppProvider$reconnectionListener$1", "Lorg/jitsi/jicofo/xmpp/XmppProvider$reconnectionListener$1;", "", "registered", "getRegistered", "()Z", "setRegistered", "(Z)V", "started", "Ljava/util/concurrent/atomic/AtomicBoolean;", "xmppConnection", "Lorg/jivesoftware/smack/AbstractXMPPConnection;", "getXmppConnection", "()Lorg/jivesoftware/smack/AbstractXMPPConnection;", "addListener", "listener", "createRoom", "Lorg/jitsi/impl/protocol/xmpp/ChatRoom;", "name", "Lorg/jxmpp/jid/EntityBareJid;", "discoverComponents", "", "domain", "Lorg/jxmpp/jid/DomainBareJid;", "discoverFeatures", "Lorg/jitsi/jicofo/xmpp/Features;", "jid", "Lorg/jxmpp/jid/EntityFullJid;", "doConnect", "findOrCreateRoom", "fireComponentsChanged", "fireRegistrationStateChanged", "removeListener", "shutdown", "start", "toString", "", "Companion", "Component", "Listener", "RoomExistsException", "jicofo-common"})
public final class XmppProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final XmppConnectionConfig config;
    @NotNull
    private final Logger logger;
    @NotNull
    private final RetryStrategy connectRetry;
    @NotNull
    private final CopyOnWriteArraySet<Listener> listeners;
    @NotNull
    private final AbstractXMPPConnection xmppConnection;
    @NotNull
    private final AtomicBoolean started;
    private boolean registered;
    @NotNull
    private Set<Component> components;
    @NotNull
    private final Muc muc;
    @NotNull
    private final reconnectionListener.1 reconnectionListener;
    @NotNull
    private final connectionListener.1 connectionListener;

    /*
     * WARNING - void declaration
     */
    public XmppProvider(@NotNull XmppConnectionConfig config, @NotNull Logger parentLogger) {
        void $this$logger_u24lambda_u2d0;
        Logger logger;
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        this.config = config;
        Logger logger2 = logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        XmppProvider xmppProvider = this;
        boolean bl = false;
        $this$logger_u24lambda_u2d0.addContext("xmpp_connection", this.config.getName());
        xmppProvider.logger = logger;
        this.connectRetry = new RetryStrategy(TaskPools.Companion.getScheduledPool());
        this.listeners = new CopyOnWriteArraySet();
        this.xmppConnection = XmppProviderKt.access$createXmppConnection(this.config, this.logger);
        this.started = new AtomicBoolean(false);
        this.components = SetsKt.emptySet();
        this.muc = new Muc(this);
        this.reconnectionListener = new ReconnectionListener(this){
            final /* synthetic */ XmppProvider this$0;
            {
                this.this$0 = $receiver;
            }

            public void reconnectingIn(int seconds) {
                XmppProvider.access$getLogger$p(this.this$0).info("XMPP reconnecting in: " + seconds + " seconds.");
            }

            public void reconnectionFailed(@NotNull Exception e) {
                Intrinsics.checkNotNullParameter(e, "e");
                XmppProvider.access$getLogger$p(this.this$0).error("XMPP reconnection failed: " + e.getMessage(), e);
            }
        };
        this.connectionListener = new ConnectionListener(this){
            final /* synthetic */ XmppProvider this$0;
            {
                this.this$0 = $receiver;
            }

            public void authenticated(@Nullable XMPPConnection connection, boolean resumed) {
                block2: {
                    Future<?> future;
                    Future<?> future2;
                    Object object;
                    XmppProvider.access$setRegistered(this.this$0, true);
                    XmppProvider.access$getLogger$p(this.this$0).info("Registered.");
                    DomainBareJid domainBareJid = this.this$0.getConfig().getXmppDomain();
                    if (domainBareJid != null) {
                        object = domainBareJid;
                        XmppProvider xmppProvider = this.this$0;
                        DomainBareJid it = object;
                        boolean bl = false;
                        XmppProvider.access$getLogger$p(xmppProvider).info("Will discover components for " + it);
                        future2 = TaskPools.Companion.getIoPool().submit(() -> connectionListener.1.authenticated$lambda-1$lambda-0(xmppProvider, it));
                    } else {
                        future2 = future = null;
                    }
                    if (future != null) break block2;
                    connectionListener.1 var4_9 = this;
                    object = this.this$0;
                    connectionListener.1 $this$authenticated_u24lambda_u2d2 = var4_9;
                    boolean bl = false;
                    XmppProvider.access$getLogger$p((XmppProvider)object).info("No xmpp-domain configured, will not discover components.");
                }
            }

            public void connectionClosed() {
                XmppProvider.access$getLogger$p(this.this$0).info("XMPP connection closed");
                XmppProvider.access$setRegistered(this.this$0, false);
            }

            public void connectionClosedOnError(@NotNull Exception e) {
                Intrinsics.checkNotNullParameter(e, "e");
                XmppProvider.access$getLogger$p(this.this$0).error("XMPP connection closed on error: " + e.getMessage(), e);
                XmppProvider.access$setRegistered(this.this$0, false);
            }

            private static final void authenticated$lambda-1$lambda-0(XmppProvider this$0, DomainBareJid $it) {
                Intrinsics.checkNotNullParameter(this$0, "this$0");
                Intrinsics.checkNotNullParameter($it, "$it");
                XmppProvider.access$discoverComponents(this$0, $it);
            }
        };
    }

    @NotNull
    public final XmppConnectionConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final AbstractXMPPConnection getXmppConnection() {
        return this.xmppConnection;
    }

    public final boolean getRegistered() {
        return this.registered;
    }

    private final void setRegistered(boolean value2) {
        if (value2 != this.registered) {
            this.registered = value2;
            this.fireRegistrationStateChanged(value2);
        }
    }

    @NotNull
    public final Set<Component> getComponents() {
        return this.components;
    }

    private final void setComponents(Set<Component> value2) {
        if (!Intrinsics.areEqual(value2, this.components)) {
            this.components = value2;
            this.logger.warn("Discovered components: " + this.components);
            this.fireComponentsChanged(value2);
        }
    }

    @NotNull
    public String toString() {
        return "XmppProvider[" + this.config + "]";
    }

    public final void start() {
        if (!this.started.compareAndSet(false, true)) {
            this.logger.info("Already started.");
        } else {
            this.connectRetry.runRetryingTask(new SimpleRetryTask(0L, 5000L, true, () -> XmppProvider.start$lambda-1(this)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdown() {
        if (!this.started.compareAndSet(true, false)) {
            this.logger.info("Already stopped or not started.");
        } else {
            XmppProvider xmppProvider = this;
            synchronized (xmppProvider) {
                boolean bl = false;
                this.connectRetry.cancel();
                this.xmppConnection.disconnect();
                this.logger.info("Disconnected.");
                this.xmppConnection.removeConnectionListener(this.connectionListener);
                Unit unit = Unit.INSTANCE;
            }
            this.setRegistered(false);
        }
    }

    public final boolean addListener(@NotNull Listener listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        return this.listeners.add(listener);
    }

    public final boolean removeListener(@NotNull Listener listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        return this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean doConnect() {
        if (!this.started.get()) {
            return false;
        }
        XmppProvider xmppProvider = this;
        synchronized (xmppProvider) {
            boolean bl;
            boolean bl2 = false;
            try {
                this.xmppConnection.connect();
                this.logger.info("Connected, JID=" + this.xmppConnection.getUser());
                this.xmppConnection.addConnectionListener(this.connectionListener);
                ReconnectionManager reconnectionManager = ReconnectionManager.getInstanceFor(this.xmppConnection);
                if (reconnectionManager != null) {
                    reconnectionManager.addReconnectionListener(this.reconnectionListener);
                }
                if (this.config.getPassword() != null) {
                    String string = this.config.getUsername().toString();
                    Intrinsics.checkNotNullExpressionValue(string, "config.username.toString()");
                    String login = string;
                    String pass = this.config.getPassword();
                    Resourcepart resource2 = this.config.getResource();
                    this.xmppConnection.login(login, pass, resource2);
                }
                bl = false;
            }
            catch (Exception e) {
                this.logger.error("Failed to connect/login: " + e.getMessage(), e);
                this.xmppConnection.removeConnectionListener(this.connectionListener);
                ReconnectionManager reconnectionManager = ReconnectionManager.getInstanceFor(this.xmppConnection);
                if (reconnectionManager != null) {
                    reconnectionManager.removeReconnectionListener(this.reconnectionListener);
                }
                if (this.xmppConnection.isConnected()) {
                    this.xmppConnection.disconnect();
                }
                bl = true;
            }
            boolean bl3 = bl;
            return bl3;
        }
    }

    private final void fireComponentsChanged(Set<Component> components) {
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Listener it = (Listener)element$iv;
            boolean bl = false;
            TaskPools.Companion.getIoPool().submit(() -> XmppProvider.fireComponentsChanged$lambda-5$lambda-4(it, components, this));
        }
    }

    private final void fireRegistrationStateChanged(boolean registered) {
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Listener it = (Listener)element$iv;
            boolean bl = false;
            TaskPools.Companion.getIoPool().submit(() -> XmppProvider.fireRegistrationStateChanged$lambda-7$lambda-6(it, registered, this));
        }
        if (registered) {
            this.xmppConnection.setReplyTimeout(this.config.getReplyTimeout().toMillis());
            this.logger.info("Set replyTimeout=" + this.config.getReplyTimeout());
        }
    }

    @NotNull
    public final ChatRoom createRoom(@NotNull EntityBareJid name) throws RoomExistsException {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.muc.createChatRoom(name);
    }

    @NotNull
    public final ChatRoom findOrCreateRoom(@NotNull EntityBareJid name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.muc.findOrCreateRoom(name);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Features> discoverFeatures(@NotNull EntityFullJid jid) {
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        List list;
        Iterable iterable;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(jid, "jid");
        if (!this.xmppConnection.isConnected()) {
            this.logger.error("Can not discover features, not connected.");
            return Features.Companion.getDefaultFeatures();
        }
        ServiceDiscoveryManager discoveryManager = ServiceDiscoveryManager.getInstanceFor(this.xmppConnection);
        if (discoveryManager == null) {
            this.logger.error("Can not discover features, no ServiceDiscoveryManager");
            return Features.Companion.getDefaultFeatures();
        }
        long start2 = System.currentTimeMillis();
        try {
            List list2;
            block12: {
                block11: {
                    void $this$mapTo$iv$iv;
                    list2 = discoveryManager.discoverInfo(jid);
                    if (list2 == null || (list2 = ((DiscoverInfo)((Object)list2)).getFeatures()) == null) break block11;
                    $this$map$iv = list2;
                    boolean $i$f$map = false;
                    Iterable iterable2 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        DiscoverInfo.Feature feature = (DiscoverInfo.Feature)item$iv$iv;
                        iterable = destination$iv$iv;
                        boolean bl = false;
                        iterable.add(it.getVar());
                    }
                    list2 = CollectionsKt.toList((List)destination$iv$iv);
                    if (list2 != null) break block12;
                }
                list2 = CollectionsKt.emptyList();
            }
            list = list2;
        }
        catch (Exception e) {
            this.logger.warn("Failed to discover features for " + jid + ": " + e.getMessage() + ", assuming default feature set.", e);
            return Features.Companion.getDefaultFeatures();
        }
        List featureStrings = list;
        this.logger.info("Discovered features for " + jid + " in " + (System.currentTimeMillis() - start2) + " ms.");
        Iterable $this$mapNotNull$iv = featureStrings;
        boolean $i$f$mapNotNull2 = false;
        $this$map$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Features it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (Features.Companion.parseString(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set<Features> features2 = CollectionsKt.toSet((List)destination$iv$iv);
        if (features2.size() != featureStrings.size()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv2;
            Iterable $i$f$mapNotNull2 = features2;
            iterable = featureStrings;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                element$iv$iv$iv = (Features)((Object)item$iv$iv);
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(it.getValue());
            }
            List unrecognizedFeatures = CollectionsKt.minus(iterable, CollectionsKt.toSet((List)destination$iv$iv2));
            this.logger.info("Unrecognized features for " + jid + ": " + unrecognizedFeatures);
        }
        return features2;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void discoverComponents(DomainBareJid domain) {
        block7: {
            block6: {
                discoveryManager = ServiceDiscoveryManager.getInstanceFor(this.xmppConnection);
                if (discoveryManager != null) break block6;
                this.logger.info("Can not discover components, no ServiceDiscoveryManager");
                v0 /* !! */  = SetsKt.emptySet();
                break block7;
            }
            try {
                var4_3 = discoveryManager.discoverInfo(domain);
                if (var4_3 == null || (var5_4 = var4_3.getIdentities()) == null) ** GOTO lbl-1000
                var6_6 = var5_4;
                $i$f$filter = false;
                var8_9 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (DiscoverInfo.Identity)element$iv$iv;
                    $i$a$-filter-XmppProvider$discoverComponents$components$1 = false;
                    if (!Intrinsics.areEqual(it.getCategory(), "component")) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $i$f$filter = (List)destination$iv$iv;
                $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    $i$a$-filter-XmppProvider$discoverComponents$components$1 = (DiscoverInfo.Identity)item$iv$iv;
                    var16_21 = destination$iv$iv;
                    $i$a$-map-XmppProvider$discoverComponents$components$2 = false;
                    v1 = it.getType();
                    Intrinsics.checkNotNullExpressionValue(v1, "it.type");
                    v2 = it.getName();
                    Intrinsics.checkNotNullExpressionValue(v2, "it.name");
                    var16_21.add(new Component(v1, v2));
                }
                var7_8 = CollectionsKt.toSet((List)destination$iv$iv);
                if (var7_8 != null) {
                    v3 = var7_8;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = SetsKt.emptySet();
                }
                var4_3 = v3;
            }
            catch (Exception e) {
                this.logger.warn("Failed to discover info", e);
                var4_3 = SetsKt.emptySet();
            }
            v0 /* !! */  = var4_3;
        }
        components = v0 /* !! */ ;
        this.setComponents(components);
    }

    private static final Boolean start$lambda-1(XmppProvider this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return this$0.doConnect();
    }

    private static final void fireComponentsChanged$lambda-5$lambda-4(Listener $it, Set $components, XmppProvider this$0) {
        Intrinsics.checkNotNullParameter($components, "$components");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        try {
            $it.componentsChanged($components);
        }
        catch (Throwable throwable) {
            this$0.logger.error("An error occurred while executing componentsChanged() on " + $it, throwable);
        }
    }

    private static final void fireRegistrationStateChanged$lambda-7$lambda-6(Listener $it, boolean $registered, XmppProvider this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        try {
            $it.registrationChanged($registered);
        }
        catch (Throwable throwable) {
            this$0.logger.error("An error occurred while executing registrationStateChanged() on " + $it, throwable);
        }
    }

    public static final /* synthetic */ Logger access$getLogger$p(XmppProvider $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$setRegistered(XmppProvider $this, boolean value2) {
        $this.setRegistered(value2);
    }

    public static final /* synthetic */ void access$discoverComponents(XmppProvider $this, DomainBareJid domain2) {
        $this.discoverComponents(domain2);
    }

    static {
        EntityCapsManager.setDefaultEntityNode("http://jitsi.org/jicofo");
        ReconnectionManager.setEnabledPerDefault(true);
        SASLAuthentication.unregisterSASLMechanism("org.jivesoftware.smack.sasl.javax.SASLGSSAPIMechanism");
        XMPPTCPConnection.setUseStreamManagementResumptionDefault(false);
        XMPPTCPConnection.setUseStreamManagementDefault(false);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jitsi/jicofo/xmpp/XmppProvider$Companion;", "", "()V", "jicofo-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jitsi/jicofo/xmpp/XmppProvider$RoomExistsException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "(Ljava/lang/String;)V", "jicofo-common"})
    public static final class RoomExistsException
    extends Exception {
        public RoomExistsException(@NotNull String message) {
            Intrinsics.checkNotNullParameter(message, "message");
            super(message);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jitsi/jicofo/xmpp/XmppProvider$Listener;", "", "componentsChanged", "", "components", "", "Lorg/jitsi/jicofo/xmpp/XmppProvider$Component;", "registrationChanged", "registered", "", "jicofo-common"})
    public static interface Listener {
        public void registrationChanged(boolean var1);

        public void componentsChanged(@NotNull Set<Component> var1);

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static void registrationChanged(@NotNull Listener this_, boolean registered) {
            }

            public static void componentsChanged(@NotNull Listener this_, @NotNull Set<Component> components) {
                Intrinsics.checkNotNullParameter(components, "components");
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jitsi/jicofo/xmpp/XmppProvider$Component;", "", "type", "", "address", "(Ljava/lang/String;Ljava/lang/String;)V", "getAddress", "()Ljava/lang/String;", "getType", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "jicofo-common"})
    public static final class Component {
        @NotNull
        private final String type;
        @NotNull
        private final String address;

        public Component(@NotNull String type2, @NotNull String address) {
            Intrinsics.checkNotNullParameter(type2, "type");
            Intrinsics.checkNotNullParameter(address, "address");
            this.type = type2;
            this.address = address;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final String getAddress() {
            return this.address;
        }

        @NotNull
        public final String component1() {
            return this.type;
        }

        @NotNull
        public final String component2() {
            return this.address;
        }

        @NotNull
        public final Component copy(@NotNull String type2, @NotNull String address) {
            Intrinsics.checkNotNullParameter(type2, "type");
            Intrinsics.checkNotNullParameter(address, "address");
            return new Component(type2, address);
        }

        public static /* synthetic */ Component copy$default(Component component, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = component.type;
            }
            if ((n & 2) != 0) {
                string2 = component.address;
            }
            return component.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Component(type=" + this.type + ", address=" + this.address + ")";
        }

        public int hashCode() {
            int result2 = this.type.hashCode();
            result2 = result2 * 31 + this.address.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Component)) {
                return false;
            }
            Component component = (Component)other;
            if (!Intrinsics.areEqual(this.type, component.type)) {
                return false;
            }
            return Intrinsics.areEqual(this.address, component.address);
        }
    }
}

