/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle;

import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smackx.jingle.element.Jingle;
import org.jivesoftware.smackx.jingle.element.JingleAction;
import org.jivesoftware.smackx.jingle.element.JingleContent;
import org.jivesoftware.smackx.jingle.element.JingleContentDescription;
import org.jivesoftware.smackx.jingle.element.JingleContentTransport;
import org.jivesoftware.smackx.jingle.element.JingleError;
import org.jivesoftware.smackx.jingle.element.JingleReason;
import org.jxmpp.jid.FullJid;

public class JingleUtil {
    private final XMPPConnection connection;

    public JingleUtil(XMPPConnection connection) {
        this.connection = connection;
    }

    public Jingle createSessionInitiate(FullJid recipient, String sessionId, JingleContent.Creator contentCreator, String contentName, JingleContent.Senders contentSenders, JingleContentDescription description2, JingleContentTransport transport) {
        Jingle.Builder jb = Jingle.builder(this.connection);
        jb.setAction(JingleAction.session_initiate).setSessionId(sessionId).setInitiator(this.connection.getUser());
        JingleContent.Builder cb = JingleContent.getBuilder();
        cb.setCreator(contentCreator).setName(contentName).setSenders(contentSenders).setDescription(description2).setTransport(transport);
        Jingle jingle = jb.addJingleContent(cb.build()).build();
        jingle.setFrom(this.connection.getUser());
        jingle.setTo(recipient);
        return jingle;
    }

    public Jingle createSessionInitiateFileOffer(FullJid recipient, String sessionId, JingleContent.Creator contentCreator, String contentName, JingleContentDescription description2, JingleContentTransport transport) {
        return this.createSessionInitiate(recipient, sessionId, contentCreator, contentName, JingleContent.Senders.initiator, description2, transport);
    }

    public IQ sendSessionInitiateFileOffer(FullJid recipient, String sessionId, JingleContent.Creator contentCreator, String contentName, JingleContentDescription description2, JingleContentTransport transport) throws SmackException.NotConnectedException, InterruptedException, XMPPException.XMPPErrorException, SmackException.NoResponseException {
        Jingle jingle = this.createSessionInitiateFileOffer(recipient, sessionId, contentCreator, contentName, description2, transport);
        return (IQ)this.connection.createStanzaCollectorAndSend(jingle).nextResultOrThrow();
    }

    public IQ sendSessionInitiate(FullJid recipient, String sessionId, JingleContent.Creator contentCreator, String contentName, JingleContent.Senders contentSenders, JingleContentDescription description2, JingleContentTransport transport) throws SmackException.NotConnectedException, InterruptedException {
        Jingle jingle = this.createSessionInitiate(recipient, sessionId, contentCreator, contentName, contentSenders, description2, transport);
        return (IQ)this.connection.createStanzaCollectorAndSend(jingle).nextResult();
    }

    public Jingle createSessionAccept(FullJid recipient, String sessionId, JingleContent.Creator contentCreator, String contentName, JingleContent.Senders contentSenders, JingleContentDescription description2, JingleContentTransport transport) {
        Jingle.Builder jb = Jingle.builder(this.connection);
        jb.setResponder(this.connection.getUser()).setAction(JingleAction.session_accept).setSessionId(sessionId);
        JingleContent.Builder cb = JingleContent.getBuilder();
        cb.setCreator(contentCreator).setName(contentName).setSenders(contentSenders).setDescription(description2).setTransport(transport);
        Jingle jingle = jb.addJingleContent(cb.build()).build();
        jingle.setTo(recipient);
        jingle.setFrom(this.connection.getUser());
        return jingle;
    }

    public IQ sendSessionAccept(FullJid recipient, String sessionId, JingleContent.Creator contentCreator, String contentName, JingleContent.Senders contentSenders, JingleContentDescription description2, JingleContentTransport transport) throws SmackException.NotConnectedException, InterruptedException {
        Jingle jingle = this.createSessionAccept(recipient, sessionId, contentCreator, contentName, contentSenders, description2, transport);
        return (IQ)this.connection.createStanzaCollectorAndSend(jingle).nextResult();
    }

    public Jingle createSessionTerminate(FullJid recipient, String sessionId, JingleReason reason) {
        Jingle.Builder jb = Jingle.builder(this.connection);
        jb.setAction(JingleAction.session_terminate).setSessionId(sessionId).setReason(reason);
        Jingle jingle = jb.build();
        jingle.setFrom(this.connection.getUser());
        jingle.setTo(recipient);
        return jingle;
    }

    public Jingle createSessionTerminate(FullJid recipient, String sessionId, JingleReason.Reason reason) {
        return this.createSessionTerminate(recipient, sessionId, new JingleReason(reason));
    }

    public Jingle createSessionTerminateDecline(FullJid recipient, String sessionId) {
        return this.createSessionTerminate(recipient, sessionId, JingleReason.Reason.decline);
    }

    public IQ sendSessionTerminateDecline(FullJid recipient, String sessionId) throws SmackException.NotConnectedException, InterruptedException, XMPPException.XMPPErrorException, SmackException.NoResponseException {
        Jingle jingle = this.createSessionTerminateDecline(recipient, sessionId);
        return (IQ)this.connection.createStanzaCollectorAndSend(jingle).nextResultOrThrow();
    }

    public Jingle createSessionTerminateSuccess(FullJid recipient, String sessionId) {
        return this.createSessionTerminate(recipient, sessionId, JingleReason.Reason.success);
    }

    public IQ sendSessionTerminateSuccess(FullJid recipient, String sessionId) throws InterruptedException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException {
        Jingle jingle = this.createSessionTerminateSuccess(recipient, sessionId);
        return (IQ)this.connection.createStanzaCollectorAndSend(jingle).nextResultOrThrow();
    }

    public Jingle createSessionTerminateBusy(FullJid recipient, String sessionId) {
        return this.createSessionTerminate(recipient, sessionId, JingleReason.Reason.busy);
    }

    public IQ sendSessionTerminateBusy(FullJid recipient, String sessionId) throws InterruptedException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException {
        Jingle jingle = this.createSessionTerminateBusy(recipient, sessionId);
        return (IQ)this.connection.createStanzaCollectorAndSend(jingle).nextResultOrThrow();
    }

    public Jingle createSessionTerminateAlternativeSession(FullJid recipient, String sessionId, String altSessionId) {
        return this.createSessionTerminate(recipient, sessionId, JingleReason.AlternativeSession(altSessionId));
    }

    public IQ sendSessionTerminateAlternativeSession(FullJid recipient, String sessionId, String altSessionId) throws InterruptedException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException {
        Jingle jingle = this.createSessionTerminateAlternativeSession(recipient, sessionId, altSessionId);
        return (IQ)this.connection.createStanzaCollectorAndSend(jingle).nextResultOrThrow();
    }

    public Jingle createSessionTerminateCancel(FullJid recipient, String sessionId) {
        return this.createSessionTerminate(recipient, sessionId, JingleReason.Reason.cancel);
    }

    public IQ sendSessionTerminateCancel(FullJid recipient, String sessionId) throws InterruptedException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException {
        Jingle jingle = this.createSessionTerminateCancel(recipient, sessionId);
        return (IQ)this.connection.createStanzaCollectorAndSend(jingle).nextResultOrThrow();
    }

    public Jingle createSessionTerminateContentCancel(FullJid recipient, String sessionId, JingleContent.Creator contentCreator, String contentName) {
        Jingle.Builder jb = Jingle.builder(this.connection);
        jb.setAction(JingleAction.session_terminate).setSessionId(sessionId);
        JingleContent.Builder cb = JingleContent.getBuilder();
        cb.setCreator(contentCreator).setName(contentName);
        Jingle jingle = jb.addJingleContent(cb.build()).build();
        jingle.setFrom(this.connection.getUser());
        jingle.setTo(recipient);
        return jingle;
    }

    public IQ sendSessionTerminateContentCancel(FullJid recipient, String sessionId, JingleContent.Creator contentCreator, String contentName) throws SmackException.NotConnectedException, InterruptedException, XMPPException.XMPPErrorException, SmackException.NoResponseException {
        Jingle jingle = this.createSessionTerminateContentCancel(recipient, sessionId, contentCreator, contentName);
        return (IQ)this.connection.createStanzaCollectorAndSend(jingle).nextResultOrThrow();
    }

    public Jingle createSessionTerminateUnsupportedTransports(FullJid recipient, String sessionId) {
        return this.createSessionTerminate(recipient, sessionId, JingleReason.Reason.unsupported_transports);
    }

    public IQ sendSessionTerminateUnsupportedTransports(FullJid recipient, String sessionId) throws InterruptedException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException {
        Jingle jingle = this.createSessionTerminateUnsupportedTransports(recipient, sessionId);
        return (IQ)this.connection.createStanzaCollectorAndSend(jingle).nextResultOrThrow();
    }

    public Jingle createSessionTerminateFailedTransport(FullJid recipient, String sessionId) {
        return this.createSessionTerminate(recipient, sessionId, JingleReason.Reason.failed_transport);
    }

    public IQ sendSessionTerminateFailedTransport(FullJid recipient, String sessionId) throws InterruptedException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException {
        Jingle jingle = this.createSessionTerminateFailedTransport(recipient, sessionId);
        return (IQ)this.connection.createStanzaCollectorAndSend(jingle).nextResultOrThrow();
    }

    public Jingle createSessionTerminateUnsupportedApplications(FullJid recipient, String sessionId) {
        return this.createSessionTerminate(recipient, sessionId, JingleReason.Reason.unsupported_applications);
    }

    public IQ sendSessionTerminateUnsupportedApplications(FullJid recipient, String sessionId) throws InterruptedException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException {
        Jingle jingle = this.createSessionTerminateUnsupportedApplications(recipient, sessionId);
        return (IQ)this.connection.createStanzaCollectorAndSend(jingle).nextResultOrThrow();
    }

    public Jingle createSessionTerminateFailedApplication(FullJid recipient, String sessionId) {
        return this.createSessionTerminate(recipient, sessionId, JingleReason.Reason.failed_application);
    }

    public IQ sendSessionTerminateFailedApplication(FullJid recipient, String sessionId) throws InterruptedException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException {
        Jingle jingle = this.createSessionTerminateFailedApplication(recipient, sessionId);
        return (IQ)this.connection.createStanzaCollectorAndSend(jingle).nextResultOrThrow();
    }

    public Jingle createSessionTerminateIncompatibleParameters(FullJid recipient, String sessionId) {
        return this.createSessionTerminate(recipient, sessionId, JingleReason.Reason.incompatible_parameters);
    }

    public IQ sendSessionTerminateIncompatibleParameters(FullJid recipient, String sessionId) throws InterruptedException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException {
        Jingle jingle = this.createSessionTerminateIncompatibleParameters(recipient, sessionId);
        return (IQ)this.connection.createStanzaCollectorAndSend(jingle).nextResultOrThrow();
    }

    public IQ sendContentRejectFileNotAvailable(FullJid recipient, String sessionId, JingleContentDescription description2) {
        return null;
    }

    public Jingle createSessionPing(FullJid recipient, String sessionId) {
        Jingle.Builder jb = Jingle.builder(this.connection);
        jb.setSessionId(sessionId).setAction(JingleAction.session_info);
        Jingle jingle = jb.build();
        jingle.setFrom(this.connection.getUser());
        jingle.setTo(recipient);
        return jingle;
    }

    public IQ sendSessionPing(FullJid recipient, String sessionId) throws SmackException.NotConnectedException, InterruptedException, XMPPException.XMPPErrorException, SmackException.NoResponseException {
        Jingle jingle = this.createSessionPing(recipient, sessionId);
        return (IQ)this.connection.createStanzaCollectorAndSend(jingle).nextResultOrThrow();
    }

    public IQ createAck(Jingle jingle) {
        return IQ.createResultIQ(jingle);
    }

    public void sendAck(Jingle jingle) throws SmackException.NotConnectedException, InterruptedException {
        this.connection.sendStanza(this.createAck(jingle));
    }

    public Jingle createTransportReplace(FullJid recipient, FullJid initiator, String sessionId, JingleContent.Creator contentCreator, String contentName, JingleContentTransport transport) {
        Jingle.Builder jb = Jingle.builder(this.connection);
        jb.setInitiator(initiator).setSessionId(sessionId).setAction(JingleAction.transport_replace);
        JingleContent.Builder cb = JingleContent.getBuilder();
        cb.setName(contentName).setCreator(contentCreator).setTransport(transport);
        Jingle jingle = jb.addJingleContent(cb.build()).build();
        jingle.setTo(recipient);
        jingle.setFrom(this.connection.getUser());
        return jingle;
    }

    public IQ sendTransportReplace(FullJid recipient, FullJid initiator, String sessionId, JingleContent.Creator contentCreator, String contentName, JingleContentTransport transport) throws SmackException.NotConnectedException, InterruptedException, XMPPException.XMPPErrorException, SmackException.NoResponseException {
        Jingle jingle = this.createTransportReplace(recipient, initiator, sessionId, contentCreator, contentName, transport);
        return (IQ)this.connection.createStanzaCollectorAndSend(jingle).nextResultOrThrow();
    }

    public Jingle createTransportAccept(FullJid recipient, FullJid initiator, String sessionId, JingleContent.Creator contentCreator, String contentName, JingleContentTransport transport) {
        Jingle.Builder jb = Jingle.builder(this.connection);
        jb.setAction(JingleAction.transport_accept).setInitiator(initiator).setSessionId(sessionId);
        JingleContent.Builder cb = JingleContent.getBuilder();
        cb.setCreator(contentCreator).setName(contentName).setTransport(transport);
        Jingle jingle = jb.addJingleContent(cb.build()).build();
        jingle.setTo(recipient);
        jingle.setFrom(this.connection.getUser());
        return jingle;
    }

    public IQ sendTransportAccept(FullJid recipient, FullJid initiator, String sessionId, JingleContent.Creator contentCreator, String contentName, JingleContentTransport transport) throws SmackException.NotConnectedException, InterruptedException, XMPPException.XMPPErrorException, SmackException.NoResponseException {
        Jingle jingle = this.createTransportAccept(recipient, initiator, sessionId, contentCreator, contentName, transport);
        return (IQ)this.connection.createStanzaCollectorAndSend(jingle).nextResultOrThrow();
    }

    public Jingle createTransportReject(FullJid recipient, FullJid initiator, String sessionId, JingleContent.Creator contentCreator, String contentName, JingleContentTransport transport) {
        Jingle.Builder jb = Jingle.builder(this.connection);
        jb.setAction(JingleAction.transport_reject).setInitiator(initiator).setSessionId(sessionId);
        JingleContent.Builder cb = JingleContent.getBuilder();
        cb.setCreator(contentCreator).setName(contentName).setTransport(transport);
        Jingle jingle = jb.addJingleContent(cb.build()).build();
        jingle.setTo(recipient);
        jingle.setFrom(this.connection.getUser());
        return jingle;
    }

    public IQ sendTransportReject(FullJid recipient, FullJid initiator, String sessionId, JingleContent.Creator contentCreator, String contentName, JingleContentTransport transport) throws SmackException.NotConnectedException, InterruptedException, XMPPException.XMPPErrorException, SmackException.NoResponseException {
        Jingle jingle = this.createTransportReject(recipient, initiator, sessionId, contentCreator, contentName, transport);
        return (IQ)this.connection.createStanzaCollectorAndSend(jingle).nextResultOrThrow();
    }

    public IQ createErrorUnknownSession(Jingle request) {
        StanzaError error = ((StanzaError.Builder)StanzaError.getBuilder().setCondition(StanzaError.Condition.item_not_found).addExtension(JingleError.UNKNOWN_SESSION)).build();
        return IQ.createErrorResponse((IQ)request, error);
    }

    public void sendErrorUnknownSession(Jingle request) throws SmackException.NotConnectedException, InterruptedException {
        this.connection.sendStanza(this.createErrorUnknownSession(request));
    }

    public IQ createErrorUnknownInitiator(Jingle request) {
        return IQ.createErrorResponse((IQ)request, StanzaError.Condition.service_unavailable);
    }

    public void sendErrorUnknownInitiator(Jingle request) throws SmackException.NotConnectedException, InterruptedException {
        this.connection.sendStanza(this.createErrorUnknownInitiator(request));
    }

    public IQ createErrorUnsupportedInfo(Jingle request) {
        StanzaError error = ((StanzaError.Builder)StanzaError.getBuilder().setCondition(StanzaError.Condition.feature_not_implemented).addExtension(JingleError.UNSUPPORTED_INFO)).build();
        return IQ.createErrorResponse((IQ)request, error);
    }

    public void sendErrorUnsupportedInfo(Jingle request) throws SmackException.NotConnectedException, InterruptedException {
        this.connection.sendStanza(this.createErrorUnsupportedInfo(request));
    }

    public IQ createErrorTieBreak(Jingle request) {
        StanzaError error = ((StanzaError.Builder)StanzaError.getBuilder().setCondition(StanzaError.Condition.conflict).addExtension(JingleError.TIE_BREAK)).build();
        return IQ.createErrorResponse((IQ)request, error);
    }

    public void sendErrorTieBreak(Jingle request) throws SmackException.NotConnectedException, InterruptedException {
        this.connection.sendStanza(this.createErrorTieBreak(request));
    }

    public IQ createErrorOutOfOrder(Jingle request) {
        StanzaError error = ((StanzaError.Builder)StanzaError.getBuilder().setCondition(StanzaError.Condition.unexpected_request).addExtension(JingleError.OUT_OF_ORDER)).build();
        return IQ.createErrorResponse((IQ)request, error);
    }

    public void sendErrorOutOfOrder(Jingle request) throws SmackException.NotConnectedException, InterruptedException {
        this.connection.sendStanza(this.createErrorOutOfOrder(request));
    }

    public IQ createErrorMalformedRequest(Jingle request) {
        return IQ.createErrorResponse((IQ)request, StanzaError.Condition.bad_request);
    }

    public void sendErrorMalformedRequest(Jingle request) throws SmackException.NotConnectedException, InterruptedException {
        this.connection.sendStanza(this.createErrorMalformedRequest(request));
    }
}

