/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node.outgoing;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.rtp.RtpExtensionType;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.node.ModifierNode;
import org.jitsi.nlj.util.ReadOnlyStreamInformationStore;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.rtp.rtp.header_extensions.AbsSendTimeHeaderExtension;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0014J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0016R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lorg/jitsi/nlj/transform/node/outgoing/AbsSendTime;", "Lorg/jitsi/nlj/transform/node/ModifierNode;", "streamInformationStore", "Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;", "(Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;)V", "extensionId", "", "Ljava/lang/Integer;", "getStreamInformationStore", "()Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "modify", "Lorg/jitsi/nlj/PacketInfo;", "packetInfo", "trace", "", "f", "Lkotlin/Function0;", "jitsi-media-transform"})
public final class AbsSendTime
extends ModifierNode {
    @NotNull
    private final ReadOnlyStreamInformationStore streamInformationStore;
    @Nullable
    private Integer extensionId;

    public AbsSendTime(@NotNull ReadOnlyStreamInformationStore streamInformationStore) {
        Intrinsics.checkNotNullParameter(streamInformationStore, "streamInformationStore");
        super("Absolute send time");
        this.streamInformationStore = streamInformationStore;
        this.streamInformationStore.onRtpExtensionMapping(RtpExtensionType.ABS_SEND_TIME, (Function1<? super Integer, Unit>)new Function1<Integer, Unit>(){

            @Override
            public final void invoke(@Nullable Integer it) {
                extensionId = it;
            }
        });
    }

    @NotNull
    public final ReadOnlyStreamInformationStore getStreamInformationStore() {
        return this.streamInformationStore;
    }

    @Override
    @NotNull
    protected PacketInfo modify(@NotNull PacketInfo packetInfo) {
        block2: {
            Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
            if (this.streamInformationStore.getSupportsTcc()) {
                return packetInfo;
            }
            Integer n = this.extensionId;
            if (n == null) break block2;
            int absSendTimeExtId = ((Number)n).intValue();
            boolean bl = false;
            RtpPacket rtpPacket = (RtpPacket)packetInfo.packetAs();
            RtpPacket.HeaderExtension headerExtension = rtpPacket.getHeaderExtension(absSendTimeExtId);
            if (headerExtension == null) {
                headerExtension = rtpPacket.addHeaderExtension(absSendTimeExtId, 3);
            }
            RtpPacket.HeaderExtension ext = headerExtension;
            AbsSendTimeHeaderExtension.Companion.setTime(ext, System.nanoTime());
        }
        return packetInfo;
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u2d1 = nodeStatsBlock = super.getNodeStats();
        boolean bl = false;
        $this$getNodeStats_u24lambda_u2d1.addString("abs_send_time_ext_id", String.valueOf(this.extensionId));
        return nodeStatsBlock;
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        f.invoke();
    }
}

