/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.rtcp;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.rtp.extensions.bytearray.ByteArrayUtils;
import org.jitsi.rtp.rtcp.CnameSdesItem;
import org.jitsi.rtp.rtcp.EmptySdesItem;
import org.jitsi.rtp.rtcp.SdesItemType;
import org.jitsi.rtp.rtcp.UnknownSdesItem;
import org.jitsi.rtp.util.BufferPool;
import org.jitsi.rtp.util.FieldParsersKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b&\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lorg/jitsi/rtp/rtcp/SdesItem;", "", "type", "Lorg/jitsi/rtp/rtcp/SdesItemType;", "(Lorg/jitsi/rtp/rtcp/SdesItemType;)V", "sizeBytes", "", "getSizeBytes", "()I", "getType", "()Lorg/jitsi/rtp/rtcp/SdesItemType;", "Companion", "rtp"})
public abstract class SdesItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SdesItemType type;
    public static final int SDES_ITEM_HEADER_SIZE = 2;
    public static final int TYPE_OFFSET = 0;
    public static final int LENGTH_OFFSET = 1;
    public static final int DATA_OFFSET = 2;

    public SdesItem(@NotNull SdesItemType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        this.type = type2;
    }

    @NotNull
    public final SdesItemType getType() {
        return this.type;
    }

    public abstract int getSizeBytes();

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004J\u0016\u0010\r\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0004J\u0016\u0010\u000e\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0004J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jitsi/rtp/rtcp/SdesItem$Companion;", "", "()V", "DATA_OFFSET", "", "LENGTH_OFFSET", "SDES_ITEM_HEADER_SIZE", "TYPE_OFFSET", "copyData", "", "buf", "baseOffset", "dataLength", "getLength", "getType", "parse", "Lorg/jitsi/rtp/rtcp/SdesItem;", "offset", "rtp"})
    public static final class Companion {
        private Companion() {
        }

        public final int getType(@NotNull byte[] buf, int baseOffset) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            return FieldParsersKt.getByteAsInt(buf, baseOffset + 0);
        }

        public final int getLength(@NotNull byte[] buf, int baseOffset) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            return FieldParsersKt.getByteAsInt(buf, baseOffset + 1);
        }

        @NotNull
        public final byte[] copyData(@NotNull byte[] buf, int baseOffset, int dataLength) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            if (dataLength <= 0) {
                return ByteArrayUtils.Companion.getEmptyByteArray();
            }
            byte[] copy2 = BufferPool.Companion.getGetArray().invoke(dataLength);
            System.arraycopy(buf, baseOffset + 2, copy2, 0, dataLength);
            return copy2;
        }

        @NotNull
        public final SdesItem parse(@NotNull byte[] buf, int offset) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            int typeValue = this.getType(buf, offset);
            SdesItemType type2 = SdesItemType.Companion.fromInt(typeValue);
            if (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()] != 2) {
                int length = this.getLength(buf, offset);
                return WhenMappings.$EnumSwitchMapping$0[type2.ordinal()] == 1 ? (SdesItem)new CnameSdesItem(buf, offset, length) : (SdesItem)new UnknownSdesItem(typeValue, buf, offset, length);
            }
            return EmptySdesItem.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[SdesItemType.values().length];
                nArray[SdesItemType.CNAME.ordinal()] = 1;
                nArray[SdesItemType.EMPTY.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

