/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.stats;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.stats.BridgeJitterStats;
import org.jitsi.nlj.stats.PacketDelayStats;
import org.jitsi.rtp.extensions.PacketExtensionsKt;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.stats.BucketStats;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0007R\u001a\u0010\u0003\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000e8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000f\u0010\u0002\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lorg/jitsi/videobridge/stats/PacketTransitStats;", "", "()V", "bridgeJitter", "", "getBridgeJitter$annotations", "getBridgeJitter", "()D", "bridgeJitterStats", "Lorg/jitsi/nlj/stats/BridgeJitterStats;", "rtcpPacketDelayStats", "Lorg/jitsi/nlj/stats/PacketDelayStats;", "rtpPacketDelayStats", "statsJson", "Lorg/jitsi/utils/OrderedJsonObject;", "getStatsJson$annotations", "getStatsJson", "()Lorg/jitsi/utils/OrderedJsonObject;", "getPacketDelayStats", "packetSent", "", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "jitsi-videobridge"})
public final class PacketTransitStats {
    @NotNull
    public static final PacketTransitStats INSTANCE = new PacketTransitStats();
    @NotNull
    private static final PacketDelayStats rtpPacketDelayStats = new PacketDelayStats(null, null, 3, null);
    @NotNull
    private static final PacketDelayStats rtcpPacketDelayStats = new PacketDelayStats(null, null, 3, null);
    @NotNull
    private static final BridgeJitterStats bridgeJitterStats = new BridgeJitterStats(null, 1, null);

    private PacketTransitStats() {
    }

    @JvmStatic
    public static final void packetSent(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        if (PacketExtensionsKt.looksLikeRtp(packetInfo.getPacket())) {
            rtpPacketDelayStats.addPacket(packetInfo);
            bridgeJitterStats.packetSent(packetInfo);
        } else if (PacketExtensionsKt.looksLikeRtcp(packetInfo.getPacket())) {
            rtcpPacketDelayStats.addPacket(packetInfo);
        }
    }

    @NotNull
    public static final OrderedJsonObject getStatsJson() {
        OrderedJsonObject stats = new OrderedJsonObject();
        ((Map)stats).put("e2e_packet_delay", INSTANCE.getPacketDelayStats());
        ((Map)stats).put("overall_bridge_jitter", bridgeJitterStats.getJitter());
        return stats;
    }

    @JvmStatic
    public static /* synthetic */ void getStatsJson$annotations() {
    }

    public static final double getBridgeJitter() {
        return bridgeJitterStats.getJitter();
    }

    @JvmStatic
    public static /* synthetic */ void getBridgeJitter$annotations() {
    }

    private final OrderedJsonObject getPacketDelayStats() {
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject $this$getPacketDelayStats_u24lambda_u2d0 = orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        $this$getPacketDelayStats_u24lambda_u2d0.put("rtp", rtpPacketDelayStats.toJson(BucketStats.Format.CumulativeRight));
        $this$getPacketDelayStats_u24lambda_u2d0.put("rtcp", rtcpPacketDelayStats.toJson(BucketStats.Format.CumulativeRight));
        return orderedJsonObject;
    }
}

