/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi_modified.sctp4j.example;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.jitsi_modified.sctp4j.Sctp4j;
import org.jitsi_modified.sctp4j.SctpServerSocket;
import org.jitsi_modified.sctp4j.SctpSocket;

public class Server {
    public static void main(String[] args2) throws UnknownHostException, SocketException, ExecutionException, InterruptedException {
        Sctp4j.init(5000);
        InetAddress remoteAddr = InetAddress.getByName("127.0.0.1");
        int remotePort = 48002;
        InetAddress localAddr = InetAddress.getByName("127.0.0.1");
        int localPort = 48001;
        int localSctpPort = 5001;
        DatagramSocket socket = new DatagramSocket(localPort, localAddr);
        SctpServerSocket server = Sctp4j.createServerSocket(localSctpPort);
        server.outgoingDataSender = (data2, offset, length) -> {
            DatagramPacket packet = new DatagramPacket(data2, offset, length, remoteAddr, remotePort);
            try {
                socket.send(packet);
            }
            catch (IOException e) {
                System.out.println("Error sending packet: " + e.toString());
            }
            return 0;
        };
        CompletableFuture serverReceivedData = new CompletableFuture();
        final CompletableFuture<Boolean> connectionReady = new CompletableFuture<Boolean>();
        server.eventHandler = new SctpSocket.SctpSocketEventHandler(){

            @Override
            public void onReady() {
                System.out.println("Server socket is ready for use");
                connectionReady.complete(true);
            }

            @Override
            public void onDisconnected() {
                System.out.println("Server socket disconnected");
            }
        };
        server.dataCallback = (data2, sid, ssn, tsn, ppid, context, flags) -> {
            String message = new String(data2);
            System.out.println("Server received data: " + message);
            serverReceivedData.complete(message);
            connectionReady.thenRun(() -> {
                System.out.println("Server accepted connection and received data, sending response");
                String response2 = "Polo";
                server.send(ByteBuffer.wrap(response2.getBytes()), true, sid, (int)ppid);
            });
        };
        new Thread(() -> {
            byte[] buf = new byte[1600];
            DatagramPacket p = new DatagramPacket(buf, 1600);
            try {
                do {
                    socket.receive(p);
                    server.onConnIn(p.getData(), p.getOffset(), p.getLength());
                } while (!serverReceivedData.isDone());
            }
            catch (IOException e) {
                System.out.println("Error receiving from udp socket: " + e.toString());
            }
        }).start();
        server.listen();
        while (!server.accept()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println("Server accepted connection");
        connectionReady.complete(true);
        String clientMessage = (String)serverReceivedData.get();
        server.close();
        System.out.println("Server received message: '" + clientMessage + "'");
    }
}

