/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.entities;

import java.util.HashSet;
import java.util.Set;
import org.keycloak.models.RealmModel;
import org.keycloak.models.cache.infinispan.entities.AbstractRevisioned;
import org.keycloak.models.cache.infinispan.entities.UserQuery;

public class UserListQuery
extends AbstractRevisioned
implements UserQuery {
    private final Set<String> users;
    private final String realm;
    private final String realmName;

    public UserListQuery(Long revisioned, String id, RealmModel realm, Set<String> users) {
        super(revisioned, id);
        this.realm = realm.getId();
        this.realmName = realm.getName();
        this.users = users;
    }

    public UserListQuery(Long revisioned, String id, RealmModel realm, String user) {
        super(revisioned, id);
        this.realm = realm.getId();
        this.realmName = realm.getName();
        this.users = new HashSet<String>();
        this.users.add(user);
    }

    @Override
    public Set<String> getUsers() {
        return this.users;
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    public String toString() {
        return "UserListQuery{id='" + this.getId() + "'realmName='" + this.realmName + '\'' + '}';
    }
}

