/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.entities;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.SingleUseObjectValueModel;

@SerializeWith(value=ExternalizerImpl.class)
public class SingleUseObjectValueEntity
implements SingleUseObjectValueModel {
    private final Map<String, String> notes;

    public SingleUseObjectValueEntity(Map<String, String> notes) {
        this.notes = notes == null ? Collections.EMPTY_MAP : new HashMap<String, String>(notes);
    }

    public Map<String, String> getNotes() {
        return Collections.unmodifiableMap(this.notes);
    }

    public String getNote(String name) {
        return this.notes.get(name);
    }

    public String toString() {
        return String.format("SingleUseObjectValueEntity [ notes=%s ]", this.notes.toString());
    }

    public static class ExternalizerImpl
    implements Externalizer<SingleUseObjectValueEntity> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, SingleUseObjectValueEntity t) throws IOException {
            output.writeByte(1);
            output.writeBoolean(t.notes.isEmpty());
            if (!t.notes.isEmpty()) {
                output.writeObject(t.notes);
            }
        }

        public SingleUseObjectValueEntity readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            byte version = input.readByte();
            if (version != 1) {
                throw new IOException("Invalid version: " + version);
            }
            boolean notesEmpty = input.readBoolean();
            Map notes = notesEmpty ? Collections.EMPTY_MAP : (Map)input.readObject();
            return new SingleUseObjectValueEntity(notes);
        }
    }
}

