/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.remotestore;

import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryModified;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryRemoved;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheEntryCreatedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryModifiedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryRemovedEvent;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.context.Flag;
import org.jboss.logging.Logger;
import org.keycloak.connections.infinispan.InfinispanUtil;
import org.keycloak.connections.infinispan.TopologyInfo;
import org.keycloak.executors.ExecutorsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.remotestore.ClientListenerExecutorDecorator;
import org.keycloak.models.utils.KeycloakModelUtils;

@ClientListener
public class RemoteCacheSessionListener<K, V extends SessionEntity> {
    protected static final Logger logger = Logger.getLogger(RemoteCacheSessionListener.class);
    private static final int MAXIMUM_REPLACE_RETRIES = 10;
    private Cache<K, SessionEntityWrapper<V>> cache;
    private RemoteCache<K, SessionEntityWrapper<V>> remoteCache;
    private TopologyInfo topologyInfo;
    private ClientListenerExecutorDecorator<K> executor;
    private BiFunction<RealmModel, V, Long> lifespanMsLoader;
    private BiFunction<RealmModel, V, Long> maxIdleTimeMsLoader;
    private KeycloakSessionFactory sessionFactory;

    protected RemoteCacheSessionListener() {
    }

    protected void init(KeycloakSession session, Cache<K, SessionEntityWrapper<V>> cache, RemoteCache<K, SessionEntityWrapper<V>> remoteCache, BiFunction<RealmModel, V, Long> lifespanMsLoader, BiFunction<RealmModel, V, Long> maxIdleTimeMsLoader) {
        this.cache = cache;
        this.remoteCache = remoteCache;
        this.topologyInfo = InfinispanUtil.getTopologyInfo(session);
        this.lifespanMsLoader = lifespanMsLoader;
        this.maxIdleTimeMsLoader = maxIdleTimeMsLoader;
        this.sessionFactory = session.getKeycloakSessionFactory();
        ExecutorService executor = ((ExecutorsProvider)session.getProvider(ExecutorsProvider.class)).getExecutor("client-listener-" + cache.getName());
        this.executor = new ClientListenerExecutorDecorator(executor);
    }

    @ClientCacheEntryCreated
    public void created(ClientCacheEntryCreatedEvent event) {
        Object key = event.getKey();
        if (this.shouldUpdateLocalCache(event.getType(), key, event.isCommandRetried())) {
            this.executor.submit(event, () -> this.createRemoteEntityInCache(key, event.getVersion()));
        }
    }

    @ClientCacheEntryModified
    public void updated(ClientCacheEntryModifiedEvent event) {
        Object key = event.getKey();
        if (this.shouldUpdateLocalCache(event.getType(), key, event.isCommandRetried())) {
            this.executor.submit(event, () -> this.replaceRemoteEntityInCache(key, event.getVersion()));
        }
    }

    protected void createRemoteEntityInCache(K key, long eventVersion) {
        MetadataValue remoteSessionVersioned = this.remoteCache.getWithMetadata(key);
        if (remoteSessionVersioned == null || remoteSessionVersioned.getValue() == null) {
            logger.debugf("Entity '%s' not present in remoteCache. Ignoring create", key);
            return;
        }
        Object remoteSession = ((SessionEntityWrapper)remoteSessionVersioned.getValue()).getEntity();
        SessionEntityWrapper newWrapper = new SessionEntityWrapper(remoteSession);
        logger.debugf("Read session entity wrapper from the remote cache: %s", remoteSession);
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.sessionFactory, session -> {
            RealmModel realm = session.realms().getRealm(((SessionEntity)newWrapper.getEntity()).getRealmId());
            long lifespanMs = this.lifespanMsLoader.apply(realm, newWrapper.getEntity());
            long maxIdleTimeMs = this.maxIdleTimeMsLoader.apply(realm, newWrapper.getEntity());
            logger.tracef("Calling putIfAbsent for entity '%s' in the cache '%s' . lifespan: %d ms, maxIdleTime: %d ms", new Object[]{key, this.remoteCache.getName(), lifespanMs, maxIdleTimeMs});
            this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_STORE, Flag.SKIP_CACHE_LOAD, Flag.IGNORE_RETURN_VALUES}).putIfAbsent(key, (Object)newWrapper, lifespanMs, TimeUnit.MILLISECONDS, maxIdleTimeMs, TimeUnit.MILLISECONDS);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replaceRemoteEntityInCache(K key, long eventVersion) {
        AtomicBoolean replaced = new AtomicBoolean(false);
        int replaceRetries = 0;
        int sleepInterval = 25;
        do {
            ++replaceRetries;
            SessionEntityWrapper localEntityWrapper = (SessionEntityWrapper)this.cache.get(key);
            MetadataValue remoteSessionVersioned = this.remoteCache.getWithMetadata(key);
            if (remoteSessionVersioned == null || remoteSessionVersioned.getValue() == null) {
                logger.debugf("Entity '%s' not present in remoteCache. Ignoring replace", key);
                return;
            }
            if (remoteSessionVersioned.getVersion() < eventVersion) {
                try {
                    logger.debugf("Got replace remote entity event prematurely for entity '%s', will try again. Event version: %d, got: %d", key, (Object)eventVersion, (Object)(remoteSessionVersioned == null ? -1L : remoteSessionVersioned.getVersion()));
                    Thread.sleep(new Random().nextInt(sleepInterval));
                }
                catch (InterruptedException ex) {
                }
                finally {
                    sleepInterval <<= 1;
                }
            } else {
                Object remoteSession = ((SessionEntityWrapper)remoteSessionVersioned.getValue()).getEntity();
                logger.debugf("Read session entity from the remote cache: %s . replaceRetries=%d", remoteSession, (Object)replaceRetries);
                SessionEntityWrapper sessionWrapper = ((SessionEntity)remoteSession).mergeRemoteEntityWithLocalEntity(localEntityWrapper);
                KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.sessionFactory, session -> {
                    RealmModel realm = session.realms().getRealm(((SessionEntity)sessionWrapper.getEntity()).getRealmId());
                    long lifespanMs = this.lifespanMsLoader.apply(realm, sessionWrapper.getEntity());
                    long maxIdleTimeMs = this.maxIdleTimeMsLoader.apply(realm, sessionWrapper.getEntity());
                    replaced.set(this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_STORE, Flag.SKIP_CACHE_LOAD, Flag.IGNORE_RETURN_VALUES}).replace(key, (Object)localEntityWrapper, (Object)sessionWrapper, lifespanMs, TimeUnit.MILLISECONDS, maxIdleTimeMs, TimeUnit.MILLISECONDS));
                });
                if (replaced.get()) continue;
                logger.debugf("Did not succeed in merging sessions, will try again: %s", remoteSession);
            }
        } while (replaceRetries < 10 && !replaced.get());
    }

    @ClientCacheEntryRemoved
    public void removed(ClientCacheEntryRemovedEvent event) {
        Object key = event.getKey();
        if (this.shouldUpdateLocalCache(event.getType(), key, event.isCommandRetried())) {
            this.executor.submit(event, () -> this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_STORE, Flag.SKIP_CACHE_LOAD, Flag.IGNORE_RETURN_VALUES}).remove(key));
        }
    }

    protected boolean shouldUpdateLocalCache(ClientEvent.Type type, K key, boolean commandRetried) {
        if (!this.cache.getStatus().allowInvocations()) {
            return false;
        }
        boolean result = commandRetried ? true : this.topologyInfo.amIOwner(this.cache, key);
        logger.debugf("Received event from remote store. Event '%s', key '%s', skip '%b'", (Object)type, key, (Object)(!result ? 1 : 0));
        return result;
    }

    public static <K, V extends SessionEntity> RemoteCacheSessionListener createListener(KeycloakSession session, Cache<K, SessionEntityWrapper<V>> cache, RemoteCache<K, SessionEntityWrapper<V>> remoteCache, BiFunction<RealmModel, V, Long> lifespanMsLoader, BiFunction<RealmModel, V, Long> maxIdleTimeMsLoader) {
        RemoteCacheSessionListener<K, V> listener = new RemoteCacheSessionListener<K, V>();
        listener.init(session, cache, remoteCache, lifespanMsLoader, maxIdleTimeMsLoader);
        return listener;
    }

    @ClientListener(includeCurrentState=false)
    public static class DontFetchInitialStateCacheListener
    extends RemoteCacheSessionListener {
    }

    @ClientListener(includeCurrentState=true)
    public static class FetchInitialStateCacheListener
    extends RemoteCacheSessionListener {
    }
}

