/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.stream;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.entities.AuthenticatedClientSessionEntity;
import org.keycloak.models.sessions.infinispan.util.KeycloakMarshallUtil;

@SerializeWith(value=ExternalizerImpl.class)
public class AuthenticatedClientSessionPredicate
implements Predicate<Map.Entry<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>>> {
    private final String realm;
    private Integer expired;

    private AuthenticatedClientSessionPredicate(String realm) {
        this.realm = realm;
    }

    public static AuthenticatedClientSessionPredicate create(String realm) {
        return new AuthenticatedClientSessionPredicate(realm);
    }

    public AuthenticatedClientSessionPredicate expired(Integer expired) {
        this.expired = expired;
        return this;
    }

    @Override
    public boolean test(Map.Entry<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>> entry) {
        AuthenticatedClientSessionEntity entity = entry.getValue().getEntity();
        if (!this.realm.equals(entity.getRealmId())) {
            return false;
        }
        return this.expired == null || entity.getTimestamp() <= this.expired;
    }

    public static class ExternalizerImpl
    implements Externalizer<AuthenticatedClientSessionPredicate> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, AuthenticatedClientSessionPredicate obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)obj.realm, (ObjectOutput)output);
            KeycloakMarshallUtil.marshall(obj.expired, output);
        }

        public AuthenticatedClientSessionPredicate readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public AuthenticatedClientSessionPredicate readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            AuthenticatedClientSessionPredicate res = new AuthenticatedClientSessionPredicate(MarshallUtil.unmarshallString((ObjectInput)input));
            res.expired(KeycloakMarshallUtil.unmarshallInteger(input));
            return res;
        }
    }
}

